package org.immutables.fixture.builder.attribute_builders;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FirstPartyWithBuilderExtension}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new FirstPartyWithBuilderExtension.Builder()}.
 */
@Generated(from = "FirstPartyWithBuilderExtension", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFirstPartyWithBuilderExtension
    extends FirstPartyWithBuilderExtension {
  private final String value;

  private ImmutableFirstPartyWithBuilderExtension(String value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FirstPartyWithBuilderExtension#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFirstPartyWithBuilderExtension withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableFirstPartyWithBuilderExtension(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFirstPartyWithBuilderExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFirstPartyWithBuilderExtension
        && equalTo(0, (ImmutableFirstPartyWithBuilderExtension) another);
  }

  private boolean equalTo(int synthetic, ImmutableFirstPartyWithBuilderExtension another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FirstPartyWithBuilderExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FirstPartyWithBuilderExtension")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FirstPartyWithBuilderExtension} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FirstPartyWithBuilderExtension instance
   */
  public static ImmutableFirstPartyWithBuilderExtension copyOf(FirstPartyWithBuilderExtension instance) {
    if (instance instanceof ImmutableFirstPartyWithBuilderExtension) {
      return (ImmutableFirstPartyWithBuilderExtension) instance;
    }
    return new FirstPartyWithBuilderExtension.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableFirstPartyWithBuilderExtension ImmutableFirstPartyWithBuilderExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FirstPartyWithBuilderExtension", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    protected @Nullable String value;

    /**
     * Creates a builder for {@link ImmutableFirstPartyWithBuilderExtension ImmutableFirstPartyWithBuilderExtension} instances.
     * <pre>
     * new FirstPartyWithBuilderExtension.Builder()
     *    .value(String) // required {@link FirstPartyWithBuilderExtension#value() value}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof FirstPartyWithBuilderExtension.Builder)) {
        throw new UnsupportedOperationException("Use: new FirstPartyWithBuilderExtension.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code FirstPartyWithBuilderExtension} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final FirstPartyWithBuilderExtension.Builder from(FirstPartyWithBuilderExtension instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      return (FirstPartyWithBuilderExtension.Builder) this;
    }

    /**
     * Initializes the value for the {@link FirstPartyWithBuilderExtension#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final FirstPartyWithBuilderExtension.Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return (FirstPartyWithBuilderExtension.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableFirstPartyWithBuilderExtension ImmutableFirstPartyWithBuilderExtension}.
     * @return An immutable instance of FirstPartyWithBuilderExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFirstPartyWithBuilderExtension build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFirstPartyWithBuilderExtension(value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build FirstPartyWithBuilderExtension, some of required attributes are not set " + attributes;
    }
  }
}
