package org.immutables.fixture.builder.detection;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NewTokenAttributeBuilderParent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNewTokenAttributeBuilderParent.builder()}.
 */
@Generated(from = "NewTokenAttributeBuilderParent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNewTokenAttributeBuilderParent
    extends NewTokenAttributeBuilderParent {
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder thirdParty;

  private ImmutableNewTokenAttributeBuilderParent(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder thirdParty) {
    this.thirdParty = thirdParty;
  }

  /**
   * @return The value of the {@code thirdParty} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder getThirdParty() {
    return thirdParty;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NewTokenAttributeBuilderParent#getThirdParty() thirdParty} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdParty
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNewTokenAttributeBuilderParent withThirdParty(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
    if (this.thirdParty == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder newValue = Objects.requireNonNull(value, "thirdParty");
    return new ImmutableNewTokenAttributeBuilderParent(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNewTokenAttributeBuilderParent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNewTokenAttributeBuilderParent
        && equalTo(0, (ImmutableNewTokenAttributeBuilderParent) another);
  }

  private boolean equalTo(int synthetic, ImmutableNewTokenAttributeBuilderParent another) {
    return thirdParty.equals(another.thirdParty);
  }

  /**
   * Computes a hash code from attributes: {@code thirdParty}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + thirdParty.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NewTokenAttributeBuilderParent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NewTokenAttributeBuilderParent")
        .omitNullValues()
        .add("thirdParty", thirdParty)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NewTokenAttributeBuilderParent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NewTokenAttributeBuilderParent instance
   */
  public static ImmutableNewTokenAttributeBuilderParent copyOf(NewTokenAttributeBuilderParent instance) {
    if (instance instanceof ImmutableNewTokenAttributeBuilderParent) {
      return (ImmutableNewTokenAttributeBuilderParent) instance;
    }
    return ImmutableNewTokenAttributeBuilderParent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNewTokenAttributeBuilderParent ImmutableNewTokenAttributeBuilderParent}.
   * <pre>
   * ImmutableNewTokenAttributeBuilderParent.builder()
   *    .thirdParty(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder) // required {@link NewTokenAttributeBuilderParent#getThirdParty() thirdParty}
   *    .build();
   * </pre>
   * @return A new ImmutableNewTokenAttributeBuilderParent builder
   */
  public static ImmutableNewTokenAttributeBuilderParent.Builder builder() {
    return new ImmutableNewTokenAttributeBuilderParent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNewTokenAttributeBuilderParent ImmutableNewTokenAttributeBuilderParent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NewTokenAttributeBuilderParent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_THIRD_PARTY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder thirdParty;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.detection.NestedDetection} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NestedDetection instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.detection.NewTokenAttributeBuilderParent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NewTokenAttributeBuilderParent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof NestedDetection) {
        NestedDetection instance = (NestedDetection) object;
        thirdParty(instance.getThirdParty());
      }
    }

    /**
     * Initializes the value for the {@link NewTokenAttributeBuilderParent#getThirdParty() thirdParty} attribute.
     * @param thirdParty The value for thirdParty 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder thirdParty(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder thirdParty) {
      this.thirdParty = new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(Objects.requireNonNull(thirdParty, "thirdParty"));
      initBits &= ~INIT_BIT_THIRD_PARTY;
      return this;
    }

    /**
     * Returns a builder for {@link NewTokenAttributeBuilderParent#getThirdParty() thirdParty}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder thirdPartyBuilder() {
      if (this.thirdParty == null) {
        this.thirdParty = new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY;

      return this.thirdParty;
    }

    /**
     * Sets {@link NewTokenAttributeBuilderParent#getThirdParty() thirdParty} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final Builder thirdPartyBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder thirdParty) {
      this.thirdParty = thirdParty;
      initBits &= ~INIT_BIT_THIRD_PARTY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNewTokenAttributeBuilderParent ImmutableNewTokenAttributeBuilderParent}.
     * @return An immutable instance of NewTokenAttributeBuilderParent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNewTokenAttributeBuilderParent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNewTokenAttributeBuilderParent(
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(thirdParty));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_THIRD_PARTY) != 0) attributes.add("thirdParty");
      return "Cannot build NewTokenAttributeBuilderParent, some of required attributes are not set " + attributes;
    }



    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
      if (value == null) return null;
      return new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
      if (value == null) return null;
      return new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(value);
    }

  }



  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
    if (value == null) return null;
    return new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
    if (value == null) return null;
    return new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(value);
  }

}
