package org.immutables.fixture.couse;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.couse.sub.C;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractA}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code A.builder()}.
 */
@Generated(from = "AbstractA", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class A implements AbstractA {
  private final B b;
  private final C c;

  private A(B b, C c) {
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public B b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public C c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link A#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final A withB(B value) {
    if (this.b == value) return this;
    B newValue = Objects.requireNonNull(value, "b");
    return new A(newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link A#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final A withC(C value) {
    if (this.c == value) return this;
    C newValue = Objects.requireNonNull(value, "c");
    return new A(this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code A} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof A
        && equalTo(0, (A) another);
  }

  private boolean equalTo(int synthetic, A another) {
    return b.equals(another.b)
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code A} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("A")
        .omitNullValues()
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractA} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable A instance
   */
  static A copyOf(AbstractA instance) {
    if (instance instanceof A) {
      return (A) instance;
    }
    return A.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link A A}.
   * <pre>
   * A.builder()
   *    .b(org.immutables.fixture.couse.B) // required {@link A#b() b}
   *    .c(org.immutables.fixture.couse.sub.C) // required {@link A#c() c}
   *    .build();
   * </pre>
   * @return A new A builder
   */
  public static A.Builder builder() {
    return new A.Builder();
  }

  /**
   * Builds instances of type {@link A A}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractA", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_B = 0x1L;
    private static final long INIT_BIT_C = 0x2L;
    private long initBits = 0x3L;

    private @Nullable B b;
    private @Nullable C c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code A} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(A instance) {
      return from((AbstractA) instance);
    }

    /**
     * Copy abstract value type {@code AbstractA} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(AbstractA instance) {
      Objects.requireNonNull(instance, "instance");
      b(instance.b());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link A#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(B b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link A#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(C c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link A A}.
     * @return An immutable instance of A
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public A build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new A(b, c);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build A, some of required attributes are not set " + attributes;
    }
  }
}
