package org.immutables.fixture.couse;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.couse.sub.ImmutableHasEnumOtherPackage;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EnumUser}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEnumUser.builder()}.
 */
@Generated(from = "EnumUser", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEnumUser implements EnumUser {
  private final ImmutableHasEnum.Type type;
  private final ImmutableHasEnumOtherPackage.Type type2;

  private ImmutableEnumUser(
      ImmutableHasEnum.Type type,
      ImmutableHasEnumOtherPackage.Type type2) {
    this.type = type;
    this.type2 = type2;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public ImmutableHasEnum.Type getType() {
    return type;
  }

  /**
   * @return The value of the {@code type2} attribute
   */
  @Override
  public ImmutableHasEnumOtherPackage.Type getType2() {
    return type2;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnumUser#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnumUser withType(ImmutableHasEnum.Type value) {
    if (this.type == value) return this;
    ImmutableHasEnum.Type newValue = Objects.requireNonNull(value, "type");
    return new ImmutableEnumUser(newValue, this.type2);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnumUser#getType2() type2} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type2
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnumUser withType2(ImmutableHasEnumOtherPackage.Type value) {
    if (this.type2 == value) return this;
    ImmutableHasEnumOtherPackage.Type newValue = Objects.requireNonNull(value, "type2");
    return new ImmutableEnumUser(this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEnumUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEnumUser
        && equalTo(0, (ImmutableEnumUser) another);
  }

  private boolean equalTo(int synthetic, ImmutableEnumUser another) {
    return type.equals(another.type)
        && type2.equals(another.type2);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code type2}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + type2.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EnumUser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EnumUser")
        .omitNullValues()
        .add("type", type)
        .add("type2", type2)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link EnumUser} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EnumUser instance
   */
  public static ImmutableEnumUser copyOf(EnumUser instance) {
    if (instance instanceof ImmutableEnumUser) {
      return (ImmutableEnumUser) instance;
    }
    return ImmutableEnumUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEnumUser ImmutableEnumUser}.
   * <pre>
   * ImmutableEnumUser.builder()
   *    .type(org.immutables.fixture.couse.ImmutableHasEnum.Type) // required {@link EnumUser#getType() type}
   *    .type2(org.immutables.fixture.couse.sub.ImmutableHasEnumOtherPackage.Type) // required {@link EnumUser#getType2() type2}
   *    .build();
   * </pre>
   * @return A new ImmutableEnumUser builder
   */
  public static ImmutableEnumUser.Builder builder() {
    return new ImmutableEnumUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEnumUser ImmutableEnumUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EnumUser", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_TYPE2 = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ImmutableHasEnum.Type type;
    private @Nullable ImmutableHasEnumOtherPackage.Type type2;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EnumUser} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(EnumUser instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      type2(instance.getType2());
      return this;
    }

    /**
     * Initializes the value for the {@link EnumUser#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(ImmutableHasEnum.Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link EnumUser#getType2() type2} attribute.
     * @param type2 The value for type2 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type2(ImmutableHasEnumOtherPackage.Type type2) {
      this.type2 = Objects.requireNonNull(type2, "type2");
      initBits &= ~INIT_BIT_TYPE2;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEnumUser ImmutableEnumUser}.
     * @return An immutable instance of EnumUser
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEnumUser build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEnumUser(type, type2);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_TYPE2) != 0) attributes.add("type2");
      return "Cannot build EnumUser, some of required attributes are not set " + attributes;
    }
  }
}
