package org.immutables.fixture.deep;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeepAndJdkOnly.Deep}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeep.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDeep.of()}.
 */
@Generated(from = "DeepAndJdkOnly.Deep", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeep implements DeepAndJdkOnly.Deep {
  private final int a;
  private final int b;

  private ImmutableDeep(int a, int b) {
    this.a = a;
    this.b = b;
  }

  private ImmutableDeep(ImmutableDeep original, int a, int b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public int b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeepAndJdkOnly.Deep#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeep withA(int value) {
    if (this.a == value) return this;
    return new ImmutableDeep(this, value, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeepAndJdkOnly.Deep#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeep withB(int value) {
    if (this.b == value) return this;
    return new ImmutableDeep(this, this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeep} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeep
        && equalTo(0, (ImmutableDeep) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeep another) {
    return a == another.a
        && b == another.b;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b;
    return h;
  }

  /**
   * Prints the immutable value {@code Deep} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Deep{"
        + "a=" + a
        + ", b=" + b
        + "}";
  }

  /**
   * Construct a new immutable {@code Deep} instance.
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @return An immutable Deep instance
   */
  public static ImmutableDeep of(int a, int b) {
    return new ImmutableDeep(a, b);
  }

  /**
   * Creates an immutable copy of a {@link DeepAndJdkOnly.Deep} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Deep instance
   */
  public static ImmutableDeep copyOf(DeepAndJdkOnly.Deep instance) {
    if (instance instanceof ImmutableDeep) {
      return (ImmutableDeep) instance;
    }
    return ImmutableDeep.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeep ImmutableDeep}.
   * <pre>
   * ImmutableDeep.builder()
   *    .a(int) // required {@link DeepAndJdkOnly.Deep#a() a}
   *    .b(int) // required {@link DeepAndJdkOnly.Deep#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableDeep builder
   */
  public static ImmutableDeep.Builder builder() {
    return new ImmutableDeep.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeep ImmutableDeep}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeepAndJdkOnly.Deep", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private int b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Deep} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeepAndJdkOnly.Deep instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      return this;
    }

    /**
     * Initializes the value for the {@link DeepAndJdkOnly.Deep#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link DeepAndJdkOnly.Deep#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(int b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeep ImmutableDeep}.
     * @return An immutable instance of Deep
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeep build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDeep(null, a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build Deep, some of required attributes are not set " + attributes;
    }
  }
}
