package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Canvas.Point Point} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiablePoint is not thread-safe</em>
 * @see ImmutablePoint
 */
@Generated(from = "Canvas.Point", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Canvas.Point"})
@NotThreadSafe
public final class ModifiablePoint implements Canvas.Point {
  private static final long INIT_BIT_X = 0x1L;
  private static final long INIT_BIT_Y = 0x2L;
  private long initBits = 0x3L;

  private int x;
  private int y;

  private ModifiablePoint() {}

  /**
   * Construct a modifiable instance of {@code Point}.
   * @param x The value for the {@link Canvas.Point#x() x} attribute 
   * @param y The value for the {@link Canvas.Point#y() y} attribute 
   * @return A new modifiable instance
   */
  public static ModifiablePoint create(int x, int y) {
    return new ModifiablePoint()
        .setX(x)
        .setY(y);
  }

  /**
   * Construct a modifiable instance of {@code Point}.
   * @return A new modifiable instance
   */
  public static ModifiablePoint create() {
    return new ModifiablePoint();
  }

  /**
   * @return value of {@code x} attribute
   */
  @Override
  public final int x() {
    if (!xIsSet()) {
      checkRequiredAttributes();
    }
    return x;
  }

  /**
   * @return value of {@code y} attribute
   */
  @Override
  public final int y() {
    if (!yIsSet()) {
      checkRequiredAttributes();
    }
    return y;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiablePoint clear() {
    initBits = 0x3L;
    x = 0;
    y = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Canvas.Point} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiablePoint from(Canvas.Point instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiablePoint) {
      from((ModifiablePoint) instance);
      return this;
    }
    setX(instance.x());
    setY(instance.y());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Canvas.Point} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiablePoint from(ModifiablePoint instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.xIsSet()) {
      setX(instance.x());
    }
    if (instance.yIsSet()) {
      setY(instance.y());
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Canvas.Point#x() x} attribute.
   * @param x The value for x
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiablePoint setX(int x) {
    this.x = x;
    initBits &= ~INIT_BIT_X;
    return this;
  }

  /**
   * Assigns a value to the {@link Canvas.Point#y() y} attribute.
   * @param y The value for y
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiablePoint setY(int y) {
    this.y = y;
    initBits &= ~INIT_BIT_Y;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link Canvas.Point#x() x} is set.
   * @return {@code true} if set
   */
  public final boolean xIsSet() {
    return (initBits & INIT_BIT_X) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Canvas.Point#y() y} is set.
   * @return {@code true} if set
   */
  public final boolean yIsSet() {
    return (initBits & INIT_BIT_Y) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiablePoint unsetX() {
    initBits |= INIT_BIT_X;
    x = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiablePoint unsetY() {
    initBits |= INIT_BIT_Y;
    y = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!xIsSet()) attributes.add("x");
    if (!yIsSet()) attributes.add("y");
    return "Point is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutablePoint ImmutablePoint}.
   * @return An immutable instance of Point
   */
  public final ImmutablePoint toImmutable() {
    checkRequiredAttributes();
    return ImmutablePoint.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiablePoint} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiablePoint)) return false;
    ModifiablePoint other = (ModifiablePoint) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiablePoint another) {
    return x == another.x
        && y == another.y;
  }

  /**
   * Computes a hash code from attributes: {@code x}, {@code y}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + x;
    h += (h << 5) + y;
    return h;
  }

  /**
   * Generates a string representation of this {@code Point}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiablePoint")
        .add("x", xIsSet() ? x() : "?")
        .add("y", yIsSet() ? y() : "?")
        .toString();
  }
}
