package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExtendingBuilderGenericBounds}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ExtendingBuilderGenericBounds.Builder()}.
 */
@Generated(from = "ExtendingBuilderGenericBounds", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExtendingBuilderGenericBounds<T extends Abc>
    extends ExtendingBuilderGenericBounds<T> {
  private final T attr;

  private ImmutableExtendingBuilderGenericBounds(T attr) {
    this.attr = attr;
  }

  /**
   * @return The value of the {@code attr} attribute
   */
  @Override
  public T attr() {
    return attr;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtendingBuilderGenericBounds#attr() attr} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtendingBuilderGenericBounds<T> withAttr(T value) {
    if (this.attr == value) return this;
    T newValue = Objects.requireNonNull(value, "attr");
    return new ImmutableExtendingBuilderGenericBounds<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExtendingBuilderGenericBounds} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExtendingBuilderGenericBounds<?>
        && equalTo(0, (ImmutableExtendingBuilderGenericBounds<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableExtendingBuilderGenericBounds<?> another) {
    return attr.equals(another.attr);
  }

  /**
   * Computes a hash code from attributes: {@code attr}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + attr.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExtendingBuilderGenericBounds} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExtendingBuilderGenericBounds")
        .omitNullValues()
        .add("attr", attr)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ExtendingBuilderGenericBounds} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ExtendingBuilderGenericBounds instance
   */
  public static <T extends Abc> ImmutableExtendingBuilderGenericBounds<T> copyOf(ExtendingBuilderGenericBounds<T> instance) {
    if (instance instanceof ImmutableExtendingBuilderGenericBounds<?>) {
      return (ImmutableExtendingBuilderGenericBounds<T>) instance;
    }
    return new ExtendingBuilderGenericBounds.Builder<T>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableExtendingBuilderGenericBounds ImmutableExtendingBuilderGenericBounds}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExtendingBuilderGenericBounds", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<T extends Abc> {
    private static final long INIT_BIT_ATTR = 0x1L;
    private long initBits = 0x1L;

    private @Nullable T attr;

    /**
     * Creates a builder for {@link ImmutableExtendingBuilderGenericBounds ImmutableExtendingBuilderGenericBounds} instances.
     * <pre>
     * new ExtendingBuilderGenericBounds.Builder&amp;lt;T&amp;gt;()
     *    .attr(T) // required {@link ExtendingBuilderGenericBounds#attr() attr}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ExtendingBuilderGenericBounds.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new ExtendingBuilderGenericBounds.Builder<T>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExtendingBuilderGenericBounds} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ExtendingBuilderGenericBounds.Builder<T> from(ExtendingBuilderGenericBounds<T> instance) {
      Objects.requireNonNull(instance, "instance");
      attr(instance.attr());
      return (ExtendingBuilderGenericBounds.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link ExtendingBuilderGenericBounds#attr() attr} attribute.
     * @param attr The value for attr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ExtendingBuilderGenericBounds.Builder<T> attr(T attr) {
      this.attr = Objects.requireNonNull(attr, "attr");
      initBits &= ~INIT_BIT_ATTR;
      return (ExtendingBuilderGenericBounds.Builder<T>) this;
    }

    /**
     * Builds a new {@link ImmutableExtendingBuilderGenericBounds ImmutableExtendingBuilderGenericBounds}.
     * @return An immutable instance of ExtendingBuilderGenericBounds
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExtendingBuilderGenericBounds<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExtendingBuilderGenericBounds<>(attr);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ATTR) != 0) attributes.add("attr");
      return "Cannot build ExtendingBuilderGenericBounds, some of required attributes are not set " + attributes;
    }
  }
}
