package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Firstie}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFirstie.builder()}.
 */
@Generated(from = "Firstie", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFirstie<T, V extends Runnable & Serializable>
    implements Firstie<T, V> {
  private final T ref;
  private final ImmutableList<V> commands;

  private ImmutableFirstie(T ref, ImmutableList<V> commands) {
    this.ref = ref;
    this.commands = commands;
  }

  /**
   * @return The value of the {@code ref} attribute
   */
  @Override
  public T ref() {
    return ref;
  }

  /**
   * @return The value of the {@code commands} attribute
   */
  @Override
  public ImmutableList<V> commands() {
    return commands;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Firstie#ref() ref} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFirstie<T, V> withRef(T value) {
    if (this.ref == value) return this;
    T newValue = Objects.requireNonNull(value, "ref");
    return new ImmutableFirstie<>(newValue, this.commands);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Firstie#commands() commands}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableFirstie<T, V> withCommands(V... elements) {
    ImmutableList<V> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFirstie<>(this.ref, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Firstie#commands() commands}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of commands elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFirstie<T, V> withCommands(Iterable<? extends V> elements) {
    if (this.commands == elements) return this;
    ImmutableList<V> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFirstie<>(this.ref, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFirstie} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFirstie<?, ?>
        && equalTo(0, (ImmutableFirstie<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFirstie<?, ?> another) {
    return ref.equals(another.ref)
        && commands.equals(another.commands);
  }

  /**
   * Computes a hash code from attributes: {@code ref}, {@code commands}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + ref.hashCode();
    h += (h << 5) + commands.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Firstie} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Firstie")
        .omitNullValues()
        .add("ref", ref)
        .add("commands", commands)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Firstie} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param <V> generic parameter V
   * @param instance The instance to copy
   * @return A copied immutable Firstie instance
   */
  public static <T, V extends Runnable & Serializable> ImmutableFirstie<T, V> copyOf(Firstie<T, V> instance) {
    if (instance instanceof ImmutableFirstie<?, ?>) {
      return (ImmutableFirstie<T, V>) instance;
    }
    return ImmutableFirstie.<T, V>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFirstie ImmutableFirstie}.
   * <pre>
   * ImmutableFirstie.&amp;lt;T, V&amp;gt;builder()
   *    .ref(T) // required {@link Firstie#ref() ref}
   *    .addCommands|addAllCommands(V) // {@link Firstie#commands() commands} elements
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param <V> generic parameter V
   * @return A new ImmutableFirstie builder
   */
  public static <T, V extends Runnable & Serializable> ImmutableFirstie.Builder<T, V> builder() {
    return new ImmutableFirstie.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFirstie ImmutableFirstie}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Firstie", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T, V extends Runnable & Serializable> {
    private static final long INIT_BIT_REF = 0x1L;
    private long initBits = 0x1L;

    private @Nullable T ref;
    private ImmutableList.Builder<V> commands = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableFirstie} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> from(ModifiableFirstie<T, V> instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.refIsSet()) {
        ref(instance.ref());
      }
      addAllCommands(instance.commands());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Firstie} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> from(Firstie<T, V> instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableFirstie<?, ?>) {
        return from((ModifiableFirstie<T, V>) instance);
      }
      ref(instance.ref());
      addAllCommands(instance.commands());
      return this;
    }

    /**
     * Initializes the value for the {@link Firstie#ref() ref} attribute.
     * @param ref The value for ref 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> ref(T ref) {
      this.ref = Objects.requireNonNull(ref, "ref");
      initBits &= ~INIT_BIT_REF;
      return this;
    }

    /**
     * Adds one element to {@link Firstie#commands() commands} list.
     * @param element A commands element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> addCommands(V element) {
      this.commands.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Firstie#commands() commands} list.
     * @param elements An array of commands elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T, V> addCommands(V... elements) {
      this.commands.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Firstie#commands() commands} list.
     * @param elements An iterable of commands elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> commands(Iterable<? extends V> elements) {
      this.commands = ImmutableList.builder();
      return addAllCommands(elements);
    }

    /**
     * Adds elements to {@link Firstie#commands() commands} list.
     * @param elements An iterable of commands elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> addAllCommands(Iterable<? extends V> elements) {
      this.commands.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFirstie ImmutableFirstie}.
     * @return An immutable instance of Firstie
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFirstie<T, V> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFirstie<>(ref, commands.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REF) != 0) attributes.add("ref");
      return "Cannot build Firstie, some of required attributes are not set " + attributes;
    }
  }
}
