package org.immutables.fixture.generics;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GenericInnerBuild}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGenericInnerBuild.builder()}.
 */
@Generated(from = "GenericInnerBuild", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableGenericInnerBuild<T, X>
    implements GenericInnerBuild<T, X> {

  private ImmutableGenericInnerBuild(ImmutableGenericInnerBuild.Builder<T, X> builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGenericInnerBuild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGenericInnerBuild<?, ?>
        && equalTo(0, (ImmutableGenericInnerBuild<?, ?>) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableGenericInnerBuild<?, ?> another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -2072411052;
  }

  /**
   * Prints the immutable value {@code GenericInnerBuild}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GenericInnerBuild{}";
  }

  /**
   * Creates an immutable copy of a {@link GenericInnerBuild} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable GenericInnerBuild instance
   */
  public static <T, X> ImmutableGenericInnerBuild<T, X> copyOf(GenericInnerBuild<T, X> instance) {
    if (instance instanceof ImmutableGenericInnerBuild<?, ?>) {
      return (ImmutableGenericInnerBuild<T, X>) instance;
    }
    return ImmutableGenericInnerBuild.<T, X>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGenericInnerBuild ImmutableGenericInnerBuild}.
   * <pre>
   * ImmutableGenericInnerBuild.&amp;lt;T, X&amp;gt;builder()
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param <X> generic parameter X
   * @return A new ImmutableGenericInnerBuild builder
   */
  public static <T, X> ImmutableGenericInnerBuild.Builder<T, X> builder() {
    return new ImmutableGenericInnerBuild.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableGenericInnerBuild ImmutableGenericInnerBuild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericInnerBuild", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T, X> implements GenericInnerBuild.Builder<T> {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GenericInnerBuild} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, X> from(GenericInnerBuild<T, X> instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableGenericInnerBuild ImmutableGenericInnerBuild}.
     * @return An immutable instance of GenericInnerBuild
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGenericInnerBuild<T, X> build() {
      return new ImmutableGenericInnerBuild<T, X>(this);
    }
  }
}
