package org.immutables.fixture.generics;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GenericsAsItIs}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGenericsAsItIs.builder()}.
 */
@Generated(from = "GenericsAsItIs", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableGenericsAsItIs<T> implements GenericsAsItIs<T> {

  private ImmutableGenericsAsItIs(ImmutableGenericsAsItIs.Builder<T> builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGenericsAsItIs} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGenericsAsItIs<?>
        && equalTo(0, (ImmutableGenericsAsItIs<?>) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableGenericsAsItIs<?> another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1072882748;
  }

  /**
   * Prints the immutable value {@code GenericsAsItIs}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GenericsAsItIs{}";
  }

  /**
   * Creates an immutable copy of a {@link GenericsAsItIs} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable GenericsAsItIs instance
   */
  public static <T> ImmutableGenericsAsItIs<T> copyOf(GenericsAsItIs<T> instance) {
    if (instance instanceof ImmutableGenericsAsItIs<?>) {
      return (ImmutableGenericsAsItIs<T>) instance;
    }
    return ImmutableGenericsAsItIs.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGenericsAsItIs ImmutableGenericsAsItIs}.
   * <pre>
   * ImmutableGenericsAsItIs.&amp;lt;T&amp;gt;builder()
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableGenericsAsItIs builder
   */
  public static <T> ImmutableGenericsAsItIs.Builder<T> builder() {
    return new ImmutableGenericsAsItIs.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableGenericsAsItIs ImmutableGenericsAsItIs}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericsAsItIs", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GenericsAsItIs} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericsAsItIs<T> instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableGenericsAsItIs ImmutableGenericsAsItIs}.
     * @return An immutable instance of GenericsAsItIs
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGenericsAsItIs<T> build() {
      return new ImmutableGenericsAsItIs<T>(this);
    }
  }
}
