package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Secondie Secondie} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableSecondie is not thread-safe</em>
 * @param <T> generic parameter T
 * @param <V> generic parameter V
 * @see ImmutableSecondie
 */
@Generated(from = "Secondie", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Secondie"})
@NotThreadSafe
public final class ModifiableSecondie<T, V> implements Secondie<T, V> {
  private static final long OPT_BIT_SET = 0x1L;
  private long optBits;

  private @Nullable V integer;
  private @Nullable ArrayList<T> list = null;
  private @Nullable LinkedHashSet<V> set = null;
  private final ArrayListMultimap<T, V> coll = ArrayListMultimap.create();

  private ModifiableSecondie() {}

  /**
   * Construct a modifiable instance of {@code Secondie}.
   * @param <T> generic parameter T
   * @param <V> generic parameter V
   * @param integer The value for the {@link Secondie#integer() integer} attribute (can be {@code null})
   * @param list The value for the {@link Secondie#list() list} attribute (can be {@code null})
   * @return A new modifiable instance
   */
  public static <T, V> ModifiableSecondie<T, V> create(@Nullable V integer, @Nullable Iterable<? extends T> list) {
    return new ModifiableSecondie<T, V>()
        .setInteger(integer)
        .addAllList(list);
  }

  /**
   * Construct a modifiable instance of {@code Secondie}.
   * @param <T> generic parameter T
   * @param <V> generic parameter V
   * @return A new modifiable instance
   */
  public static <T, V> ModifiableSecondie<T, V> create() {
    return new ModifiableSecondie<>();
  }

  /**
   * @return value of {@code integer} attribute, may be {@code null}
   */
  @Override
  public final @Nullable V integer() {
    return integer;
  }

  /**
   * @return modifiable list {@code list}
   */
  @Override
  public final @Nullable List<T> list() {
    return list;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code set} attribute
   */
  @Override
  public final @Nullable Set<V> set() {
    if (setIsSet()) {
      return set;
    } else {
      return Secondie.super.set();
    }
  }

  /**
   * @return value of {@code coll} attribute
   */
  @Override
  public final Multimap<T, V> coll() {
    return coll;
  }

  /**
   * @return newly computed, not cached value of {@code lst} attribute
   */
  @Override
  public final @Nullable List<V> lst() {
    return Secondie.super.lst();
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> clear() {
    optBits = 0;
    integer = null;
    list = null;
    set = null;
    coll.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Secondie} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableSecondie<T, V> from(Secondie<T, V> instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableSecondie<?, ?>) {
      from((ModifiableSecondie<T, V>) instance);
      return this;
    }
    @Nullable V integerValue = instance.integer();
    if (integerValue != null) {
      setInteger(integerValue);
    }
    addAllList(instance.list());
    addAllSet(instance.set());
    putAllColl(instance.coll());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Secondie} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableSecondie<T, V> from(ModifiableSecondie<T, V> instance) {
    Objects.requireNonNull(instance, "instance");
    @Nullable V integerValue = instance.integer();
    if (integerValue != null) {
      setInteger(integerValue);
    }
    addAllList(instance.list());
    addAllSet(instance.set());
    putAllColl(instance.coll());
    return this;
  }

  /**
   * Assigns a value to the {@link Secondie#integer() integer} attribute.
   * @param integer The value for integer, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> setInteger(@Nullable V integer) {
    this.integer = integer;
    return this;
  }

  /**
   * Adds one element to {@link Secondie#list() list} list.
   * @param element The list element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> addList(T element) {
    if (this.list == null) {
      this.list = new ArrayList<T>();
    }
    Objects.requireNonNull(element, "list element");
    this.list.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Secondie#list() list} list.
   * @param elements An array of list elements
   * @return {@code this} for use in a chained invocation
   */
  @SafeVarargs
  @CanIgnoreReturnValue
  public final ModifiableSecondie<T, V> addList(T... elements) {
    for (T e : elements) {
      addList(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Secondie#list() list} list.
   * @param elements An iterable of list elements, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> setList(@Nullable Iterable<? extends T> elements) {
    if (elements == null) {
      this.list = null;
      return this;
    }
    if (this.list == null) {
      this.list = new ArrayList<T>();
    } else {
      this.list.clear();
    }
    addAllList(elements);
    return this;
  }

  /**
   * Adds elements to {@link Secondie#list() list} list.
   * @param elements An iterable of list elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> addAllList(Iterable<? extends T> elements) {
    if (elements == null) return this;
    if (this.list == null) {
      this.list = new ArrayList<T>();
    }
    for (T e : elements) {
      addList(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Secondie#set() set} set.
   * @param element The set element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> addSet(V element) {
    if (this.set == null) {
      this.set = new LinkedHashSet<V>();
    }
    Objects.requireNonNull(element, "set element");
    this.set.add(element);
    optBits |= OPT_BIT_SET;
    return this;
  }

  /**
   * Adds elements to {@link Secondie#set() set} set.
   * @param elements An array of set elements
   * @return {@code this} for use in a chained invocation
   */
  @SafeVarargs
  @CanIgnoreReturnValue
  public final ModifiableSecondie<T, V> addSet(V... elements) {
    for (V e : elements) {
      addSet(e);
    }
    optBits |= OPT_BIT_SET;
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Secondie#set() set} set.
   * @param elements An iterable of set elements, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> setSet(@Nullable Iterable<? extends V> elements) {
    if (elements == null) {
      this.set = null;
      optBits |= OPT_BIT_SET;
      return this;
    }
    if (this.set == null) {
      this.set = new LinkedHashSet<V>();
    } else {
      this.set.clear();
    }
    addAllSet(elements);
    return this;
  }

  /**
   * Adds elements to {@link Secondie#set() set} set.
   * @param elements An iterable of set elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> addAllSet(Iterable<? extends V> elements) {
    if (elements == null) return this;
    if (this.set == null) {
      this.set = new LinkedHashSet<V>();
    }
    for (V e : elements) {
      addSet(e);
    }
    optBits |= OPT_BIT_SET;
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@link Secondie#coll() coll} true. Nulls are not permitted
   * @param key The key for coll
   * @param values The values for coll
   * @return {@code this} for use in a chained invocation
   */
  @SafeVarargs
  @CanIgnoreReturnValue
  public final ModifiableSecondie<T, V> putColl(T key, V... values) {
    putAllColl(key, Arrays.asList(values));
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@link Secondie#coll() coll} true. Nulls are not permitted
   * @param key The key for coll
   * @param values The values for coll
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> putAllColl(T key, Iterable<V> values) {
    for (V v : values) {
      this.coll.put(
          Objects.requireNonNull(key, "coll key"),
          Objects.requireNonNull(v, "coll value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@link Secondie#coll() coll} map.
   * @param key The key in coll map
   * @param value The associated value in the coll map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> putColl(T key, V value) {
    this.coll.put(
        Objects.requireNonNull(key, "coll key"),
        Objects.requireNonNull(value, "coll value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Secondie#coll() coll} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the coll map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> setColl(Multimap<? extends T, ? extends V> entries) {
    this.coll.clear();
    for (Map.Entry<? extends T, ? extends V> e : entries.entries()) {
      T k = e.getKey();
      V v = e.getValue();
      this.coll.put(
          Objects.requireNonNull(k, "coll key"),
          Objects.requireNonNull(v, "coll value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Secondie#coll() coll} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to coll map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSecondie<T, V> putAllColl(Multimap<? extends T, ? extends V> entries) {
    for (Map.Entry<? extends T, ? extends V> e : entries.entries()) {
      T k = e.getKey();
      V v = e.getValue();
      this.coll.put(
          Objects.requireNonNull(k, "coll key"),
          Objects.requireNonNull(v, "coll value"));
    }
    return this;
  }

  /**
   * Returns {@code true} if the default attribute {@link Secondie#set() set} is set.
   * @return {@code true} if set
   */
  public final boolean setIsSet() {
    return (optBits & OPT_BIT_SET) != 0;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableSecondie<T, V> unsetSet() {
    optBits |= 0;
    set = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableSecondie ImmutableSecondie}.
   * @return An immutable instance of Secondie
   */
  public final ImmutableSecondie<T, V> toImmutable() {
    return ImmutableSecondie.<T, V>copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableSecondie<?, ?>} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableSecondie<?, ?>)) return false;
    ModifiableSecondie<?, ?> other = (ModifiableSecondie<?, ?>) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableSecondie<?, ?> another) {
    Set<V> set = set();
    List<V> lst = lst();
    return Objects.equals(integer, another.integer)
        && Objects.equals(list, another.list)
        && Objects.equals(set, another.set())
        && coll.equals(another.coll)
        && Objects.equals(lst, another.lst());
  }

  /**
   * Computes a hash code from attributes: {@code integer}, {@code list}, {@code set}, {@code coll}, {@code lst}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(integer);
    h += (h << 5) + Objects.hashCode(list);
    Set<V> set = set();
    h += (h << 5) + Objects.hashCode(set);
    h += (h << 5) + coll.hashCode();
    List<V> lst = lst();
    h += (h << 5) + Objects.hashCode(lst);
    return h;
  }

  /**
   * Generates a string representation of this {@code Secondie}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableSecondie")
        .add("integer", integer())
        .add("list", list())
        .add("set", set())
        .add("coll", coll())
        .toString();
  }
}
