package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AnyGetterInBuilder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new AnyGetterInBuilder.Builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAnyGetterInBuilder.of()}.
 */
@Generated(from = "AnyGetterInBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAnyGetterInBuilder extends AnyGetterInBuilder {
  private final Map<String, JsonNode> any;

  private ImmutableAnyGetterInBuilder(Map<String, ? extends JsonNode> any) {
    this.any = createUnmodifiableMap(true, false, any);
  }

  private ImmutableAnyGetterInBuilder(
      ImmutableAnyGetterInBuilder original,
      Map<String, JsonNode> any) {
    this.any = any;
  }

  /**
   * @return The value of the {@code any} attribute
   */
  @JsonProperty("any")
  @JsonAnyGetter
  @Override
  public Map<String, JsonNode> any() {
    return any;
  }

  /**
   * Copy the current immutable object by replacing the {@link AnyGetterInBuilder#any() any} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the any map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnyGetterInBuilder withAny(Map<String, ? extends JsonNode> entries) {
    if (this.any == entries) return this;
    Map<String, JsonNode> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableAnyGetterInBuilder(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnyGetterInBuilder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnyGetterInBuilder
        && equalTo(0, (ImmutableAnyGetterInBuilder) another);
  }

  private boolean equalTo(int synthetic, ImmutableAnyGetterInBuilder another) {
    return any.equals(another.any);
  }

  /**
   * Computes a hash code from attributes: {@code any}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + any.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AnyGetterInBuilder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AnyGetterInBuilder{"
        + "any=" + any
        + "}";
  }

  /**
   * Construct a new immutable {@code AnyGetterInBuilder} instance.
   * @param any The value for the {@code any} attribute
   * @return An immutable AnyGetterInBuilder instance
   */
  public static ImmutableAnyGetterInBuilder of(Map<String, ? extends JsonNode> any) {
    return new ImmutableAnyGetterInBuilder(any);
  }

  /**
   * Creates an immutable copy of a {@link AnyGetterInBuilder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AnyGetterInBuilder instance
   */
  public static ImmutableAnyGetterInBuilder copyOf(AnyGetterInBuilder instance) {
    if (instance instanceof ImmutableAnyGetterInBuilder) {
      return (ImmutableAnyGetterInBuilder) instance;
    }
    return new AnyGetterInBuilder.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableAnyGetterInBuilder ImmutableAnyGetterInBuilder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AnyGetterInBuilder", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private Map<String, JsonNode> any = new LinkedHashMap<String, JsonNode>();

    /**
     * Creates a builder for {@link ImmutableAnyGetterInBuilder ImmutableAnyGetterInBuilder} instances.
     * <pre>
     * new AnyGetterInBuilder.Builder()
     *    .putAny|putAllAny(String =&gt; com.fasterxml.jackson.databind.JsonNode) // {@link AnyGetterInBuilder#any() any} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof AnyGetterInBuilder.Builder)) {
        throw new UnsupportedOperationException("Use: new AnyGetterInBuilder.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code AnyGetterInBuilder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AnyGetterInBuilder.Builder from(AnyGetterInBuilder instance) {
      Objects.requireNonNull(instance, "instance");
      putAllAny(instance.any());
      return (AnyGetterInBuilder.Builder) this;
    }

    /**
     * Put one entry to the {@link AnyGetterInBuilder#any() any} map.
     * @param key The key in the any map
     * @param value The associated value in the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final AnyGetterInBuilder.Builder putAny(String key, JsonNode value) {
      this.any.put(
          Objects.requireNonNull(key, "any key"),
          Objects.requireNonNull(value, "any value"));
      return (AnyGetterInBuilder.Builder) this;
    }

    /**
     * Put one entry to the {@link AnyGetterInBuilder#any() any} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AnyGetterInBuilder.Builder putAny(Map.Entry<String, ? extends JsonNode> entry) {
      String k = entry.getKey();
      JsonNode v = entry.getValue();
      this.any.put(
          Objects.requireNonNull(k, "any key"),
          Objects.requireNonNull(v, "any value"));
      return (AnyGetterInBuilder.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link AnyGetterInBuilder#any() any} map. Nulls are not permitted
     * @param entries The entries that will be added to the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("any")
    public final AnyGetterInBuilder.Builder any(Map<String, ? extends JsonNode> entries) {
      this.any.clear();
      return putAllAny(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link AnyGetterInBuilder#any() any} map. Nulls are not permitted
     * @param entries The entries that will be added to the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AnyGetterInBuilder.Builder putAllAny(Map<String, ? extends JsonNode> entries) {
      for (Map.Entry<String, ? extends JsonNode> e : entries.entrySet()) {
        String k = e.getKey();
        JsonNode v = e.getValue();
        this.any.put(
            Objects.requireNonNull(k, "any key"),
            Objects.requireNonNull(v, "any value"));
      }
      return (AnyGetterInBuilder.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableAnyGetterInBuilder ImmutableAnyGetterInBuilder}.
     * @return An immutable instance of AnyGetterInBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnyGetterInBuilder build() {
      return new ImmutableAnyGetterInBuilder(null, createUnmodifiableMap(false, false, any));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
