package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AnyGetterSetter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAnyGetterSetter.builder()}.
 */
@Generated(from = "AnyGetterSetter", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAnyGetterSetter implements AnyGetterSetter {
  private final ImmutableMap<String, Object> any;

  private ImmutableAnyGetterSetter(ImmutableMap<String, Object> any) {
    this.any = any;
  }

  /**
   * @return The value of the {@code any} attribute
   */
  @JsonProperty("any")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getAny() {
    return any;
  }

  /**
   * Copy the current immutable object by replacing the {@link AnyGetterSetter#getAny() any} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the any map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnyGetterSetter withAny(Map<String, ? extends Object> entries) {
    if (this.any == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableAnyGetterSetter(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnyGetterSetter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnyGetterSetter
        && equalTo(0, (ImmutableAnyGetterSetter) another);
  }

  private boolean equalTo(int synthetic, ImmutableAnyGetterSetter another) {
    return any.equals(another.any);
  }

  /**
   * Computes a hash code from attributes: {@code any}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + any.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AnyGetterSetter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AnyGetterSetter")
        .omitNullValues()
        .add("any", any)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AnyGetterSetter", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AnyGetterSetter {
    final Map<String, Object> any = new HashMap<String, Object>();

    @JsonAnySetter
    public void setAny(String key, Object value) {
      this.any.put(key, value);
    }
    @Override
    public Map<String, Object> getAny() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAnyGetterSetter fromJson(Json json) {
    ImmutableAnyGetterSetter.Builder builder = ImmutableAnyGetterSetter.builder();
    if (json.any != null) {
      builder.putAllAny(json.any);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AnyGetterSetter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AnyGetterSetter instance
   */
  public static ImmutableAnyGetterSetter copyOf(AnyGetterSetter instance) {
    if (instance instanceof ImmutableAnyGetterSetter) {
      return (ImmutableAnyGetterSetter) instance;
    }
    return ImmutableAnyGetterSetter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAnyGetterSetter ImmutableAnyGetterSetter}.
   * <pre>
   * ImmutableAnyGetterSetter.builder()
   *    .putAny|putAllAny(String =&gt; Object) // {@link AnyGetterSetter#getAny() any} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableAnyGetterSetter builder
   */
  public static ImmutableAnyGetterSetter.Builder builder() {
    return new ImmutableAnyGetterSetter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAnyGetterSetter ImmutableAnyGetterSetter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AnyGetterSetter", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<String, Object> any = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AnyGetterSetter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AnyGetterSetter instance) {
      Objects.requireNonNull(instance, "instance");
      putAllAny(instance.getAny());
      return this;
    }

    /**
     * Put one entry to the {@link AnyGetterSetter#getAny() any} map.
     * @param key The key in the any map
     * @param value The associated value in the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putAny(String key, Object value) {
      this.any.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link AnyGetterSetter#getAny() any} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAny(Map.Entry<String, ? extends Object> entry) {
      this.any.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link AnyGetterSetter#getAny() any} map. Nulls are not permitted
     * @param entries The entries that will be added to the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("any")
    public final Builder any(Map<String, ? extends Object> entries) {
      this.any = ImmutableMap.builder();
      return putAllAny(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link AnyGetterSetter#getAny() any} map. Nulls are not permitted
     * @param entries The entries that will be added to the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllAny(Map<String, ? extends Object> entries) {
      this.any.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAnyGetterSetter ImmutableAnyGetterSetter}.
     * @return An immutable instance of AnyGetterSetter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnyGetterSetter build() {
      return new ImmutableAnyGetterSetter(any.build());
    }
  }
}
