package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultTypingProblem.EmptyObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEmptyObject.builder()}.
 */
@Generated(from = "DefaultTypingProblem.EmptyObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEmptyObject
    extends DefaultTypingProblem.EmptyObject {

  private ImmutableEmptyObject(ImmutableEmptyObject.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEmptyObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEmptyObject
        && equalTo(0, (ImmutableEmptyObject) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableEmptyObject another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -2089322345;
  }

  /**
   * Prints the immutable value {@code EmptyObject}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EmptyObject{}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DefaultTypingProblem.EmptyObject", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends DefaultTypingProblem.EmptyObject {
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEmptyObject fromJson(Json json) {
    ImmutableEmptyObject.Builder builder = ImmutableEmptyObject.builder();
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DefaultTypingProblem.EmptyObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EmptyObject instance
   */
  public static ImmutableEmptyObject copyOf(DefaultTypingProblem.EmptyObject instance) {
    if (instance instanceof ImmutableEmptyObject) {
      return (ImmutableEmptyObject) instance;
    }
    return ImmutableEmptyObject.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEmptyObject ImmutableEmptyObject}.
   * <pre>
   * ImmutableEmptyObject.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableEmptyObject builder
   */
  public static ImmutableEmptyObject.Builder builder() {
    return new ImmutableEmptyObject.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEmptyObject ImmutableEmptyObject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultTypingProblem.EmptyObject", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EmptyObject} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DefaultTypingProblem.EmptyObject instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableEmptyObject ImmutableEmptyObject}.
     * @return An immutable instance of EmptyObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEmptyObject build() {
      return new ImmutableEmptyObject(this);
    }
  }
}
