package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JacksonMappedWithNoAnnotations}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJacksonMappedWithNoAnnotations.builder()}.
 */
@Generated(from = "JacksonMappedWithNoAnnotations", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJacksonMappedWithNoAnnotations
    implements JacksonMappedWithNoAnnotations {
  private final String someString;

  private ImmutableJacksonMappedWithNoAnnotations(String someString) {
    this.someString = someString;
  }

  /**
   * @return The value of the {@code someString} attribute
   */
  @JsonProperty("someString")
  @Override
  public String getSomeString() {
    return someString;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JacksonMappedWithNoAnnotations#getSomeString() someString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for someString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJacksonMappedWithNoAnnotations withSomeString(String value) {
    String newValue = Objects.requireNonNull(value, "someString");
    if (this.someString.equals(newValue)) return this;
    return new ImmutableJacksonMappedWithNoAnnotations(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJacksonMappedWithNoAnnotations} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJacksonMappedWithNoAnnotations
        && equalTo(0, (ImmutableJacksonMappedWithNoAnnotations) another);
  }

  private boolean equalTo(int synthetic, ImmutableJacksonMappedWithNoAnnotations another) {
    return someString.equals(another.someString);
  }

  /**
   * Computes a hash code from attributes: {@code someString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + someString.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JacksonMappedWithNoAnnotations} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JacksonMappedWithNoAnnotations")
        .omitNullValues()
        .add("someString", someString)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JacksonMappedWithNoAnnotations", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JacksonMappedWithNoAnnotations {
    @Nullable String someString;
    @JsonProperty("someString")
    public void setSomeString(String someString) {
      this.someString = someString;
    }
    @Override
    public String getSomeString() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJacksonMappedWithNoAnnotations fromJson(Json json) {
    ImmutableJacksonMappedWithNoAnnotations.Builder builder = ImmutableJacksonMappedWithNoAnnotations.builder();
    if (json.someString != null) {
      builder.someString(json.someString);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JacksonMappedWithNoAnnotations} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JacksonMappedWithNoAnnotations instance
   */
  public static ImmutableJacksonMappedWithNoAnnotations copyOf(JacksonMappedWithNoAnnotations instance) {
    if (instance instanceof ImmutableJacksonMappedWithNoAnnotations) {
      return (ImmutableJacksonMappedWithNoAnnotations) instance;
    }
    return ImmutableJacksonMappedWithNoAnnotations.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJacksonMappedWithNoAnnotations ImmutableJacksonMappedWithNoAnnotations}.
   * <pre>
   * ImmutableJacksonMappedWithNoAnnotations.builder()
   *    .someString(String) // required {@link JacksonMappedWithNoAnnotations#getSomeString() someString}
   *    .build();
   * </pre>
   * @return A new ImmutableJacksonMappedWithNoAnnotations builder
   */
  public static ImmutableJacksonMappedWithNoAnnotations.Builder builder() {
    return new ImmutableJacksonMappedWithNoAnnotations.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJacksonMappedWithNoAnnotations ImmutableJacksonMappedWithNoAnnotations}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JacksonMappedWithNoAnnotations", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOME_STRING = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String someString;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JacksonMappedWithNoAnnotations} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JacksonMappedWithNoAnnotations instance) {
      Objects.requireNonNull(instance, "instance");
      someString(instance.getSomeString());
      return this;
    }

    /**
     * Initializes the value for the {@link JacksonMappedWithNoAnnotations#getSomeString() someString} attribute.
     * @param someString The value for someString 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder someString(String someString) {
      this.someString = Objects.requireNonNull(someString, "someString");
      initBits &= ~INIT_BIT_SOME_STRING;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJacksonMappedWithNoAnnotations ImmutableJacksonMappedWithNoAnnotations}.
     * @return An immutable instance of JacksonMappedWithNoAnnotations
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJacksonMappedWithNoAnnotations build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJacksonMappedWithNoAnnotations(someString);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOME_STRING) != 0) attributes.add("someString");
      return "Cannot build JacksonMappedWithNoAnnotations, some of required attributes are not set " + attributes;
    }
  }
}
