package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link KeywordNames}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableKeywordNames.builder()}.
 */
@Generated(from = "KeywordNames", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableKeywordNames implements KeywordNames {
  private final long getLong;
  private final boolean isDefault;

  private ImmutableKeywordNames(long getLong, boolean isDefault) {
    this.getLong = getLong;
    this.isDefault = isDefault;
  }

  /**
   * @return The value of the {@code getLong} attribute
   */
  @JsonProperty
  @Override
  public long getLong() {
    return getLong;
  }

  /**
   * @return The value of the {@code isDefault} attribute
   */
  @JsonProperty
  @Override
  public boolean isDefault() {
    return isDefault;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeywordNames#getLong() long} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for getLong
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeywordNames withLong(long value) {
    if (this.getLong == value) return this;
    return new ImmutableKeywordNames(value, this.isDefault);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeywordNames#isDefault() default} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isDefault
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeywordNames withDefault(boolean value) {
    if (this.isDefault == value) return this;
    return new ImmutableKeywordNames(this.getLong, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableKeywordNames} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableKeywordNames
        && equalTo(0, (ImmutableKeywordNames) another);
  }

  private boolean equalTo(int synthetic, ImmutableKeywordNames another) {
    return getLong == another.getLong
        && isDefault == another.isDefault;
  }

  /**
   * Computes a hash code from attributes: {@code getLong}, {@code isDefault}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(getLong);
    h += (h << 5) + Booleans.hashCode(isDefault);
    return h;
  }

  /**
   * Prints the immutable value {@code KeywordNames} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("KeywordNames")
        .omitNullValues()
        .add("long", getLong)
        .add("default", isDefault)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "KeywordNames", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements KeywordNames {
    long getLong;
    boolean getLongIsSet;
    boolean isDefault;
    boolean isDefaultIsSet;
    @JsonProperty
    public void setLong(long getLong) {
      this.getLong = getLong;
      this.getLongIsSet = true;
    }
    @JsonProperty
    public void setDefault(boolean isDefault) {
      this.isDefault = isDefault;
      this.isDefaultIsSet = true;
    }
    @Override
    public long getLong() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isDefault() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableKeywordNames fromJson(Json json) {
    ImmutableKeywordNames.Builder builder = ImmutableKeywordNames.builder();
    if (json.getLongIsSet) {
      builder.setLong(json.getLong);
    }
    if (json.isDefaultIsSet) {
      builder.setDefault(json.isDefault);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link KeywordNames} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable KeywordNames instance
   */
  public static ImmutableKeywordNames copyOf(KeywordNames instance) {
    if (instance instanceof ImmutableKeywordNames) {
      return (ImmutableKeywordNames) instance;
    }
    return ImmutableKeywordNames.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableKeywordNames ImmutableKeywordNames}.
   * <pre>
   * ImmutableKeywordNames.builder()
   *    .setLong(long) // required {@link KeywordNames#getLong() long}
   *    .setDefault(boolean) // required {@link KeywordNames#isDefault() default}
   *    .build();
   * </pre>
   * @return A new ImmutableKeywordNames builder
   */
  public static ImmutableKeywordNames.Builder builder() {
    return new ImmutableKeywordNames.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableKeywordNames ImmutableKeywordNames}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "KeywordNames", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GET_LONG = 0x1L;
    private static final long INIT_BIT_IS_DEFAULT = 0x2L;
    private long initBits = 0x3L;

    private long getLong;
    private boolean isDefault;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeywordNames} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(KeywordNames instance) {
      Objects.requireNonNull(instance, "instance");
      setLong(instance.getLong());
      setDefault(instance.isDefault());
      return this;
    }

    /**
     * Initializes the value for the {@link KeywordNames#getLong() long} attribute.
     * @param getLong The value for getLong 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder setLong(long getLong) {
      this.getLong = getLong;
      initBits &= ~INIT_BIT_GET_LONG;
      return this;
    }

    /**
     * Initializes the value for the {@link KeywordNames#isDefault() default} attribute.
     * @param isDefault The value for isDefault 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder setDefault(boolean isDefault) {
      this.isDefault = isDefault;
      initBits &= ~INIT_BIT_IS_DEFAULT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableKeywordNames ImmutableKeywordNames}.
     * @return An immutable instance of KeywordNames
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableKeywordNames build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableKeywordNames(getLong, isDefault);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GET_LONG) != 0) attributes.add("long");
      if ((initBits & INIT_BIT_IS_DEFAULT) != 0) attributes.add("default");
      return "Cannot build KeywordNames, some of required attributes are not set " + attributes;
    }
  }
}
