package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProjectInformation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProjectInformation.builder()}.
 */
@Generated(from = "ProjectInformation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProjectInformation implements ProjectInformation {
  private final Integer organizationId;

  private ImmutableProjectInformation(Integer organizationId) {
    this.organizationId = organizationId;
  }

  /**
   * @return The value of the {@code organizationId} attribute
   */
  @JsonProperty
  @Override
  public Integer getOrganizationId() {
    return organizationId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectInformation#getOrganizationId() organizationId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for organizationId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectInformation withOrganizationId(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "organizationId");
    if (this.organizationId.equals(newValue)) return this;
    return new ImmutableProjectInformation(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProjectInformation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProjectInformation
        && equalTo(0, (ImmutableProjectInformation) another);
  }

  private boolean equalTo(int synthetic, ImmutableProjectInformation another) {
    return organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProjectInformation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProjectInformation")
        .omitNullValues()
        .add("organizationId", organizationId)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ProjectInformation", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ProjectInformation {
    @Nullable Integer organizationId;
    @JsonProperty
    public void setOrganizationId(Integer organizationId) {
      this.organizationId = organizationId;
    }
    @Override
    public Integer getOrganizationId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableProjectInformation fromJson(Json json) {
    ImmutableProjectInformation.Builder builder = ImmutableProjectInformation.builder();
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ProjectInformation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProjectInformation instance
   */
  public static ImmutableProjectInformation copyOf(ProjectInformation instance) {
    if (instance instanceof ImmutableProjectInformation) {
      return (ImmutableProjectInformation) instance;
    }
    return ImmutableProjectInformation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProjectInformation ImmutableProjectInformation}.
   * <pre>
   * ImmutableProjectInformation.builder()
   *    .organizationId(Integer) // required {@link ProjectInformation#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new ImmutableProjectInformation builder
   */
  public static ImmutableProjectInformation.Builder builder() {
    return new ImmutableProjectInformation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProjectInformation ImmutableProjectInformation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProjectInformation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Integer organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProjectInformation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ProjectInformation instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectInformation#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder organizationId(Integer organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProjectInformation ImmutableProjectInformation}.
     * @return An immutable instance of ProjectInformation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProjectInformation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProjectInformation(organizationId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build ProjectInformation, some of required attributes are not set " + attributes;
    }
  }
}
