package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BlogEvent.AbstractPostAdded}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PostAdded.builder()}.
 */
@Generated(from = "BlogEvent.AbstractPostAdded", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class PostAdded implements BlogEvent.AbstractPostAdded {
  private final String postId;
  private final BodyChanged content;

  private PostAdded(String postId, BodyChanged content) {
    this.postId = postId;
    this.content = content;
  }

  /**
   * @return The value of the {@code postId} attribute
   */
  @JsonProperty("postId")
  @Override
  public String getPostId() {
    return postId;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public BodyChanged getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlogEvent.AbstractPostAdded#getPostId() postId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for postId
   * @return A modified copy of the {@code this} object
   */
  public final PostAdded withPostId(String value) {
    String newValue = Objects.requireNonNull(value, "postId");
    if (this.postId.equals(newValue)) return this;
    return new PostAdded(newValue, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlogEvent.AbstractPostAdded#getContent() content} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final PostAdded withContent(BodyChanged value) {
    if (this.content == value) return this;
    BodyChanged newValue = Objects.requireNonNull(value, "content");
    return new PostAdded(this.postId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code PostAdded} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PostAdded
        && equalTo(0, (PostAdded) another);
  }

  private boolean equalTo(int synthetic, PostAdded another) {
    return postId.equals(another.postId)
        && content.equals(another.content);
  }

  /**
   * Computes a hash code from attributes: {@code postId}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + postId.hashCode();
    h += (h << 5) + content.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PostAdded} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PostAdded")
        .omitNullValues()
        .add("postId", postId)
        .add("content", content)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "BlogEvent.AbstractPostAdded", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BlogEvent.AbstractPostAdded {
    @Nullable String postId;
    @Nullable BodyChanged content;
    @JsonProperty("postId")
    public void setPostId(String postId) {
      this.postId = postId;
    }
    @JsonProperty("content")
    public void setContent(BodyChanged content) {
      this.content = content;
    }
    @Override
    public String getPostId() { throw new UnsupportedOperationException(); }
    @Override
    public BodyChanged getContent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static PostAdded fromJson(Json json) {
    PostAdded.Builder builder = PostAdded.builder();
    if (json.postId != null) {
      builder.postId(json.postId);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link BlogEvent.AbstractPostAdded} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PostAdded instance
   */
  public static PostAdded copyOf(BlogEvent.AbstractPostAdded instance) {
    if (instance instanceof PostAdded) {
      return (PostAdded) instance;
    }
    return PostAdded.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link PostAdded PostAdded}.
   * <pre>
   * PostAdded.builder()
   *    .postId(String) // required {@link BlogEvent.AbstractPostAdded#getPostId() postId}
   *    .content(org.immutables.fixture.jackson.BodyChanged) // required {@link BlogEvent.AbstractPostAdded#getContent() content}
   *    .build();
   * </pre>
   * @return A new PostAdded builder
   */
  public static PostAdded.Builder builder() {
    return new PostAdded.Builder();
  }

  /**
   * Builds instances of type {@link PostAdded PostAdded}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BlogEvent.AbstractPostAdded", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_POST_ID = 0x1L;
    private static final long INIT_BIT_CONTENT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String postId;
    private @Nullable BodyChanged content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractPostAdded} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BlogEvent.AbstractPostAdded instance) {
      Objects.requireNonNull(instance, "instance");
      postId(instance.getPostId());
      content(instance.getContent());
      return this;
    }

    /**
     * Initializes the value for the {@link BlogEvent.AbstractPostAdded#getPostId() postId} attribute.
     * @param postId The value for postId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder postId(String postId) {
      this.postId = Objects.requireNonNull(postId, "postId");
      initBits &= ~INIT_BIT_POST_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BlogEvent.AbstractPostAdded#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder content(BodyChanged content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Builds a new {@link PostAdded PostAdded}.
     * @return An immutable instance of PostAdded
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PostAdded build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PostAdded(postId, content);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_POST_ID) != 0) attributes.add("postId");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build PostAdded, some of required attributes are not set " + attributes;
    }
  }
}
