package org.immutables.fixture.jdkonly;

import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ApplBuilder} collects parameters and invokes the static factory method:
 * {@code org.immutables.fixture.jdkonly.JdkOptionalBuilderFactory.appl(..)}.
 * Call the {@link #build()} method to get a result of type {@code int}.
 * <p><em>{@code ApplBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "JdkOptionalBuilderFactory.appl", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class ApplBuilder {
  private Optional<Integer> a = Optional.absent();
  private java.util.Optional<String> b = java.util.Optional.empty();
  private OptionalInt c = OptionalInt.empty();

  /**
   * Creates a {@code ApplBuilder} factory builder.
   * <pre>
   * new ApplBuilder()
   *    .a(Integer) // optional {@code a}
   *    .b(String) // optional {@code b}
   *    .c(int) // optional {@code c}
   *    .build();
   * </pre>
   */
  public ApplBuilder() {
  }

  /**
   * Initializes the optional value {@code a} to a.
   * @param a The value for a
   * @return {@code this} builder for chained invocation
   */
  @CanIgnoreReturnValue 
  public final ApplBuilder a(int a) {
    this.a = Optional.of(a);
    return this;
  }

  /**
   * Initializes the optional value {@code a} to a.
   * @param a The value for a
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ApplBuilder a(Optional<Integer> a) {
    this.a = a;
    return this;
  }

  /**
   * Initializes the optional value {@code b} to b.
   * @param b The value for b
   * @return {@code this} builder for chained invocation
   */
  @CanIgnoreReturnValue 
  public final ApplBuilder b(String b) {
    this.b = java.util.Optional.of(b);
    return this;
  }

  /**
   * Initializes the optional value {@code b} to b.
   * @param b The value for b
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ApplBuilder b(java.util.Optional<String> b) {
    this.b = (java.util.Optional<String>) Objects.requireNonNull(b, "b");
    return this;
  }

  /**
   * Initializes the optional value {@code c} to c.
   * @param c The value for c
   * @return {@code this} builder for chained invocation
   */
  @CanIgnoreReturnValue 
  public final ApplBuilder c(int c) {
    this.c = OptionalInt.of(c);
    return this;
  }

  /**
   * Initializes the optional value {@code c} to c.
   * @param c The value for c
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ApplBuilder c(OptionalInt c) {
    this.c = (OptionalInt) Objects.requireNonNull(c, "c");
    return this;
  }

  /**
   * Invokes {@code org.immutables.fixture.jdkonly.JdkOptionalBuilderFactory.appl(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code int}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public int build() {
    return JdkOptionalBuilderFactory.appl(a, b, c);
  }
}
