package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HasOptionalToString}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHasOptionalToString.builder()}.
 */
@Generated(from = "HasOptionalToString", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableHasOptionalToString implements HasOptionalToString {
  private final @Nullable Integer into;
  private final String mandatory;
  private final @Nullable String nullable;
  private final @Nullable String optional;

  private ImmutableHasOptionalToString(
      @Nullable Integer into,
      String mandatory,
      @Nullable String nullable,
      @Nullable String optional) {
    this.into = into;
    this.mandatory = mandatory;
    this.nullable = nullable;
    this.optional = optional;
  }

  /**
   * @return The value of the {@code into} attribute
   */
  @Override
  public OptionalInt into() {
    return into != null
        ? OptionalInt.of(into)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code mandatory} attribute
   */
  @Override
  public String mandatory() {
    return mandatory;
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @Override
  public @Nullable String nullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code optional} attribute
   */
  @Override
  public Optional<String> optional() {
    return Optional.ofNullable(optional);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HasOptionalToString#into() into} attribute.
   * @param value The value for into
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHasOptionalToString withInto(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.into, newValue)) return this;
    return new ImmutableHasOptionalToString(newValue, this.mandatory, this.nullable, this.optional);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HasOptionalToString#into() into} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for into
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHasOptionalToString withInto(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.into, value)) return this;
    return new ImmutableHasOptionalToString(value, this.mandatory, this.nullable, this.optional);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HasOptionalToString#mandatory() mandatory} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mandatory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHasOptionalToString withMandatory(String value) {
    String newValue = Objects.requireNonNull(value, "mandatory");
    if (this.mandatory.equals(newValue)) return this;
    return new ImmutableHasOptionalToString(this.into, newValue, this.nullable, this.optional);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HasOptionalToString#nullable() nullable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHasOptionalToString withNullable(@Nullable String value) {
    if (Objects.equals(this.nullable, value)) return this;
    return new ImmutableHasOptionalToString(this.into, this.mandatory, value, this.optional);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HasOptionalToString#optional() optional} attribute.
   * @param value The value for optional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHasOptionalToString withOptional(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "optional");
    if (Objects.equals(this.optional, newValue)) return this;
    return new ImmutableHasOptionalToString(this.into, this.mandatory, this.nullable, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HasOptionalToString#optional() optional} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHasOptionalToString withOptional(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.optional, value)) return this;
    return new ImmutableHasOptionalToString(this.into, this.mandatory, this.nullable, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHasOptionalToString} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHasOptionalToString
        && equalTo(0, (ImmutableHasOptionalToString) another);
  }

  private boolean equalTo(int synthetic, ImmutableHasOptionalToString another) {
    return Objects.equals(into, another.into)
        && mandatory.equals(another.mandatory)
        && Objects.equals(nullable, another.nullable)
        && Objects.equals(optional, another.optional);
  }

  /**
   * Computes a hash code from attributes: {@code into}, {@code mandatory}, {@code nullable}, {@code optional}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(into);
    h += (h << 5) + mandatory.hashCode();
    h += (h << 5) + Objects.hashCode(nullable);
    h += (h << 5) + Objects.hashCode(optional);
    return h;
  }

  /**
   * Prints the immutable value {@code HasOptionalToString} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("HasOptionalToString{");
    if (into != null) {
      builder.append("into=").append(into);
    }
    if (builder.length() > 20) builder.append(", ");
    builder.append("mandatory=").append(mandatory);
    if (nullable != null) {
      builder.append(", ");
      builder.append("nullable=").append(nullable);
    }
    if (optional != null) {
      builder.append(", ");
      builder.append("optional=").append(optional);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link HasOptionalToString} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HasOptionalToString instance
   */
  public static ImmutableHasOptionalToString copyOf(HasOptionalToString instance) {
    if (instance instanceof ImmutableHasOptionalToString) {
      return (ImmutableHasOptionalToString) instance;
    }
    return ImmutableHasOptionalToString.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHasOptionalToString ImmutableHasOptionalToString}.
   * <pre>
   * ImmutableHasOptionalToString.builder()
   *    .into(int) // optional {@link HasOptionalToString#into() into}
   *    .mandatory(String) // required {@link HasOptionalToString#mandatory() mandatory}
   *    .nullable(String | null) // nullable {@link HasOptionalToString#nullable() nullable}
   *    .optional(String) // optional {@link HasOptionalToString#optional() optional}
   *    .build();
   * </pre>
   * @return A new ImmutableHasOptionalToString builder
   */
  public static ImmutableHasOptionalToString.Builder builder() {
    return new ImmutableHasOptionalToString.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHasOptionalToString ImmutableHasOptionalToString}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HasOptionalToString", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MANDATORY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Integer into;
    private @Nullable String mandatory;
    private @Nullable String nullable;
    private @Nullable String optional;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HasOptionalToString} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HasOptionalToString instance) {
      Objects.requireNonNull(instance, "instance");
      OptionalInt intoOptional = instance.into();
      if (intoOptional.isPresent()) {
        into(intoOptional);
      }
      mandatory(instance.mandatory());
      @Nullable String nullableValue = instance.nullable();
      if (nullableValue != null) {
        nullable(nullableValue);
      }
      Optional<String> optionalOptional = instance.optional();
      if (optionalOptional.isPresent()) {
        optional(optionalOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link HasOptionalToString#into() into} to into.
     * @param into The value for into
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder into(int into) {
      this.into = into;
      return this;
    }

    /**
     * Initializes the optional value {@link HasOptionalToString#into() into} to into.
     * @param into The value for into
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder into(OptionalInt into) {
      this.into = into.isPresent() ? into.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the value for the {@link HasOptionalToString#mandatory() mandatory} attribute.
     * @param mandatory The value for mandatory 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mandatory(String mandatory) {
      this.mandatory = Objects.requireNonNull(mandatory, "mandatory");
      initBits &= ~INIT_BIT_MANDATORY;
      return this;
    }

    /**
     * Initializes the value for the {@link HasOptionalToString#nullable() nullable} attribute.
     * @param nullable The value for nullable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nullable(@Nullable String nullable) {
      this.nullable = nullable;
      return this;
    }

    /**
     * Initializes the optional value {@link HasOptionalToString#optional() optional} to optional.
     * @param optional The value for optional
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder optional(String optional) {
      this.optional = Objects.requireNonNull(optional, "optional");
      return this;
    }

    /**
     * Initializes the optional value {@link HasOptionalToString#optional() optional} to optional.
     * @param optional The value for optional
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder optional(Optional<String> optional) {
      this.optional = optional.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableHasOptionalToString ImmutableHasOptionalToString}.
     * @return An immutable instance of HasOptionalToString
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHasOptionalToString build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHasOptionalToString(into, mandatory, nullable, optional);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANDATORY) != 0) attributes.add("mandatory");
      return "Cannot build HasOptionalToString, some of required attributes are not set " + attributes;
    }
  }
}
