package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JdkCopyCons}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJdkCopyCons.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableJdkCopyCons.of()}.
 */
@Generated(from = "JdkCopyCons", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJdkCopyCons implements JdkCopyCons {
  private final List<String> strings;

  private ImmutableJdkCopyCons(Iterable<String> strings) {
    this.strings = createUnmodifiableList(false, createSafeList(strings, true, false));
  }

  private ImmutableJdkCopyCons(ImmutableJdkCopyCons original, List<String> strings) {
    this.strings = strings;
  }

  /**
   * @return The value of the {@code strings} attribute
   */
  @Override
  public List<String> getStrings() {
    return strings;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkCopyCons#getStrings() strings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkCopyCons withStrings(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJdkCopyCons(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkCopyCons#getStrings() strings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of strings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkCopyCons withStrings(Iterable<String> elements) {
    if (this.strings == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJdkCopyCons(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkCopyCons} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJdkCopyCons
        && equalTo(0, (ImmutableJdkCopyCons) another);
  }

  private boolean equalTo(int synthetic, ImmutableJdkCopyCons another) {
    return strings.equals(another.strings);
  }

  /**
   * Computes a hash code from attributes: {@code strings}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + strings.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JdkCopyCons} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JdkCopyCons{"
        + "strings=" + strings
        + "}";
  }

  /**
   * Construct a new immutable {@code JdkCopyCons} instance.
   * @param strings The value for the {@code strings} attribute
   * @return An immutable JdkCopyCons instance
   */
  public static ImmutableJdkCopyCons of(List<String> strings) {
    return of((Iterable<String>) strings);
  }

  /**
   * Construct a new immutable {@code JdkCopyCons} instance.
   * @param strings The value for the {@code strings} attribute
   * @return An immutable JdkCopyCons instance
   */
  public static ImmutableJdkCopyCons of(Iterable<String> strings) {
    return new ImmutableJdkCopyCons(strings);
  }

  /**
   * Creates an immutable copy of a {@link JdkCopyCons} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkCopyCons instance
   */
  public static ImmutableJdkCopyCons copyOf(JdkCopyCons instance) {
    if (instance instanceof ImmutableJdkCopyCons) {
      return (ImmutableJdkCopyCons) instance;
    }
    return ImmutableJdkCopyCons.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJdkCopyCons ImmutableJdkCopyCons}.
   * <pre>
   * ImmutableJdkCopyCons.builder()
   *    .addStrings|addAllStrings(String) // {@link JdkCopyCons#getStrings() strings} elements
   *    .build();
   * </pre>
   * @return A new ImmutableJdkCopyCons builder
   */
  public static ImmutableJdkCopyCons.Builder builder() {
    return new ImmutableJdkCopyCons.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJdkCopyCons ImmutableJdkCopyCons}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JdkCopyCons", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<String> strings = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JdkCopyCons} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JdkCopyCons instance) {
      Objects.requireNonNull(instance, "instance");
      addAllStrings(instance.getStrings());
      return this;
    }

    /**
     * Adds one element to {@link JdkCopyCons#getStrings() strings} list.
     * @param element A strings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStrings(String element) {
      this.strings.add(Objects.requireNonNull(element, "strings element"));
      return this;
    }

    /**
     * Adds elements to {@link JdkCopyCons#getStrings() strings} list.
     * @param elements An array of strings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStrings(String... elements) {
      for (String element : elements) {
        this.strings.add(Objects.requireNonNull(element, "strings element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JdkCopyCons#getStrings() strings} list.
     * @param elements An iterable of strings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder strings(Iterable<String> elements) {
      this.strings.clear();
      return addAllStrings(elements);
    }

    /**
     * Adds elements to {@link JdkCopyCons#getStrings() strings} list.
     * @param elements An iterable of strings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStrings(Iterable<String> elements) {
      for (String element : elements) {
        this.strings.add(Objects.requireNonNull(element, "strings element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableJdkCopyCons ImmutableJdkCopyCons}.
     * @return An immutable instance of JdkCopyCons
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJdkCopyCons build() {
      return new ImmutableJdkCopyCons(null, createUnmodifiableList(true, strings));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
