package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ToImmutableCopyFalse.C}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableC.of()}.
 */
@Generated(from = "ToImmutableCopyFalse.C", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableC implements ToImmutableCopyFalse.C {
  private final int c;

  private ImmutableC(int c) {
    this.c = c;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public int c() {
    return c;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableC} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableC
        && equalTo(0, (ImmutableC) another);
  }

  private boolean equalTo(int synthetic, ImmutableC another) {
    return c == another.c;
  }

  /**
   * Computes a hash code from attributes: {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + c;
    return h;
  }

  /**
   * Prints the immutable value {@code C} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("C")
        .omitNullValues()
        .add("c", c)
        .toString();
  }

  /**
   * Construct a new immutable {@code C} instance.
   * @param c The value for the {@code c} attribute
   * @return An immutable C instance
   */
  public static ImmutableC of(int c) {
    return new ImmutableC(c);
  }
}
