package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClearBuilder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableClearBuilder.builder()}.
 */
@Generated(from = "ClearBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableClearBuilder implements ClearBuilder {
  private final boolean a;
  private final String b;
  private final List<String> l;
  private final int d;
  private final Set<RetentionPolicy> r;
  private final Map<String, Integer> m;

  private ImmutableClearBuilder(ImmutableClearBuilder.Builder builder) {
    this.a = builder.a;
    this.b = builder.b;
    this.l = createUnmodifiableList(true, builder.l);
    this.r = createUnmodifiableEnumSet(builder.r);
    this.m = createUnmodifiableMap(false, false, builder.m);
    this.d = builder.dIsSet()
        ? builder.d
        : ClearBuilder.super.d();
  }

  private ImmutableClearBuilder(
      boolean a,
      String b,
      List<String> l,
      int d,
      Set<RetentionPolicy> r,
      Map<String, Integer> m) {
    this.a = a;
    this.b = b;
    this.l = l;
    this.d = d;
    this.r = r;
    this.m = m;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public boolean a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String b() {
    return b;
  }

  /**
   * @return The value of the {@code l} attribute
   */
  @Override
  public List<String> l() {
    return l;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public int d() {
    return d;
  }

  /**
   * @return The value of the {@code r} attribute
   */
  @Override
  public Set<RetentionPolicy> r() {
    return r;
  }

  /**
   * @return The value of the {@code m} attribute
   */
  @Override
  public Map<String, Integer> m() {
    return m;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClearBuilder#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClearBuilder withA(boolean value) {
    if (this.a == value) return this;
    return new ImmutableClearBuilder(value, this.b, this.l, this.d, this.r, this.m);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClearBuilder#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClearBuilder withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableClearBuilder(this.a, newValue, this.l, this.d, this.r, this.m);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClearBuilder#l() l}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClearBuilder withL(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableClearBuilder(this.a, this.b, newValue, this.d, this.r, this.m);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClearBuilder#l() l}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of l elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClearBuilder withL(Iterable<String> elements) {
    if (this.l == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableClearBuilder(this.a, this.b, newValue, this.d, this.r, this.m);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClearBuilder#d() d} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClearBuilder withD(int value) {
    if (this.d == value) return this;
    return new ImmutableClearBuilder(this.a, this.b, this.l, value, this.r, this.m);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClearBuilder#r() r}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClearBuilder withR(RetentionPolicy... elements) {
    Set<RetentionPolicy> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ImmutableClearBuilder(this.a, this.b, this.l, this.d, newValue, this.m);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClearBuilder#r() r}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of r elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClearBuilder withR(Iterable<RetentionPolicy> elements) {
    if (this.r == elements) return this;
    Set<RetentionPolicy> newValue = createUnmodifiableEnumSet(elements);
    return new ImmutableClearBuilder(this.a, this.b, this.l, this.d, newValue, this.m);
  }

  /**
   * Copy the current immutable object by replacing the {@link ClearBuilder#m() m} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the m map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableClearBuilder withM(Map<String, ? extends Integer> entries) {
    if (this.m == entries) return this;
    Map<String, Integer> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableClearBuilder(this.a, this.b, this.l, this.d, this.r, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableClearBuilder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableClearBuilder
        && equalTo(0, (ImmutableClearBuilder) another);
  }

  private boolean equalTo(int synthetic, ImmutableClearBuilder another) {
    return a == another.a
        && b.equals(another.b)
        && l.equals(another.l)
        && d == another.d
        && r.equals(another.r)
        && m.equals(another.m);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code l}, {@code d}, {@code r}, {@code m}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(a);
    h += (h << 5) + b.hashCode();
    h += (h << 5) + l.hashCode();
    h += (h << 5) + d;
    h += (h << 5) + r.hashCode();
    h += (h << 5) + m.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ClearBuilder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ClearBuilder{"
        + "a=" + a
        + ", b=" + b
        + ", l=" + l
        + ", d=" + d
        + ", r=" + r
        + ", m=" + m
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ClearBuilder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ClearBuilder instance
   */
  public static ImmutableClearBuilder copyOf(ClearBuilder instance) {
    if (instance instanceof ImmutableClearBuilder) {
      return (ImmutableClearBuilder) instance;
    }
    return ImmutableClearBuilder.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableClearBuilder ImmutableClearBuilder}.
   * <pre>
   * ImmutableClearBuilder.builder()
   *    .a(boolean) // required {@link ClearBuilder#a() a}
   *    .b(String) // required {@link ClearBuilder#b() b}
   *    .addL|addAllL(String) // {@link ClearBuilder#l() l} elements
   *    .d(int) // optional {@link ClearBuilder#d() d}
   *    .addR|addAllR(annotation.RetentionPolicy) // {@link ClearBuilder#r() r} elements
   *    .putM|putAllM(String =&gt; int) // {@link ClearBuilder#m() m} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableClearBuilder builder
   */
  public static ImmutableClearBuilder.Builder builder() {
    return new ImmutableClearBuilder.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableClearBuilder ImmutableClearBuilder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClearBuilder", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long OPT_BIT_D = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private boolean a;
    private @Nullable String b;
    private List<String> l = new ArrayList<String>();
    private int d;
    private EnumSet<RetentionPolicy> r = EnumSet.noneOf(RetentionPolicy.class);
    private Map<String, Integer> m = new LinkedHashMap<String, Integer>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClearBuilder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ClearBuilder instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      addAllL(instance.l());
      d(instance.d());
      addAllR(instance.r());
      putAllM(instance.m());
      return this;
    }

    /**
     * Initializes the value for the {@link ClearBuilder#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(boolean a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link ClearBuilder#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Adds one element to {@link ClearBuilder#l() l} list.
     * @param element A l element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addL(String element) {
      this.l.add(Objects.requireNonNull(element, "l element"));
      return this;
    }

    /**
     * Adds elements to {@link ClearBuilder#l() l} list.
     * @param elements An array of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addL(String... elements) {
      for (String element : elements) {
        this.l.add(Objects.requireNonNull(element, "l element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClearBuilder#l() l} list.
     * @param elements An iterable of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l(Iterable<String> elements) {
      this.l.clear();
      return addAllL(elements);
    }

    /**
     * Adds elements to {@link ClearBuilder#l() l} list.
     * @param elements An iterable of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllL(Iterable<String> elements) {
      for (String element : elements) {
        this.l.add(Objects.requireNonNull(element, "l element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ClearBuilder#d() d} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ClearBuilder#d() d}.</em>
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d(int d) {
      this.d = d;
      optBits |= OPT_BIT_D;
      return this;
    }

    /**
     * Adds one element to {@link ClearBuilder#r() r} set.
     * @param element A r element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addR(RetentionPolicy element) {
      this.r.add(Objects.requireNonNull(element, "r element"));
      return this;
    }

    /**
     * Adds elements to {@link ClearBuilder#r() r} set.
     * @param elements An array of r elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addR(RetentionPolicy... elements) {
      for (RetentionPolicy element : elements) {
        this.r.add(Objects.requireNonNull(element, "r element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClearBuilder#r() r} set.
     * @param elements An iterable of r elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder r(Iterable<RetentionPolicy> elements) {
      this.r.clear();
      return addAllR(elements);
    }

    /**
     * Adds elements to {@link ClearBuilder#r() r} set.
     * @param elements An iterable of r elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllR(Iterable<RetentionPolicy> elements) {
      for (RetentionPolicy element : elements) {
        this.r.add(Objects.requireNonNull(element, "r element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link ClearBuilder#m() m} map.
     * @param key The key in the m map
     * @param value The associated value in the m map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putM(String key, int value) {
      this.m.put(
          Objects.requireNonNull(key, "m key"),
          Objects.requireNonNull(value, "m value"));
      return this;
    }

    /**
     * Put one entry to the {@link ClearBuilder#m() m} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putM(Map.Entry<String, ? extends Integer> entry) {
      String k = entry.getKey();
      Integer v = entry.getValue();
      this.m.put(
          Objects.requireNonNull(k, "m key"),
          Objects.requireNonNull(v, "m value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ClearBuilder#m() m} map. Nulls are not permitted
     * @param entries The entries that will be added to the m map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder m(Map<String, ? extends Integer> entries) {
      this.m.clear();
      return putAllM(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ClearBuilder#m() m} map. Nulls are not permitted
     * @param entries The entries that will be added to the m map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllM(Map<String, ? extends Integer> entries) {
      for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
        String k = e.getKey();
        Integer v = e.getValue();
        this.m.put(
            Objects.requireNonNull(k, "m key"),
            Objects.requireNonNull(v, "m value"));
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public Builder clear() {
      initBits = 0x3L;
      optBits = 0;
      this.a = false;
      this.b = null;
      this.l.clear();
      this.d = 0;
      this.r.clear();
      this.m.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableClearBuilder ImmutableClearBuilder}.
     * @return An immutable instance of ClearBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableClearBuilder build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableClearBuilder(this);
    }

    private boolean dIsSet() {
      return (optBits & OPT_BIT_D) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build ClearBuilder, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  @SuppressWarnings("unchecked")
  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
