package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Companion}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCompanion.builder()}.
 */
@Generated(from = "Companion", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCompanion implements Companion {
  private final int integer;
  private final String string;
  private final @Nullable Boolean bools;
  private final ImmutableList<String> str;
  private final ImmutableSet<Integer> ints;
  private final int[] arrayInts;
  private final String[] arrayStrings;
  private final ImmutableSortedSet<Integer> ords;
  private final ImmutableSet<RetentionPolicy> pols;
  private final ImmutableSortedSet<Integer> navs;
  private final ImmutableMap<Long, Integer> just;
  private final ImmutableSortedMap<Integer, String> ordsmap;
  private final ImmutableMap<RetentionPolicy, Integer> polsmap;
  private final ImmutableSortedMap<String, Integer> navsmap;

  private ImmutableCompanion(
      int integer,
      String string,
      @Nullable Boolean bools,
      ImmutableList<String> str,
      ImmutableSet<Integer> ints,
      int[] arrayInts,
      String[] arrayStrings,
      ImmutableSortedSet<Integer> ords,
      ImmutableSet<RetentionPolicy> pols,
      ImmutableSortedSet<Integer> navs,
      ImmutableMap<Long, Integer> just,
      ImmutableSortedMap<Integer, String> ordsmap,
      ImmutableMap<RetentionPolicy, Integer> polsmap,
      ImmutableSortedMap<String, Integer> navsmap) {
    this.integer = integer;
    this.string = string;
    this.bools = bools;
    this.str = str;
    this.ints = ints;
    this.arrayInts = arrayInts;
    this.arrayStrings = arrayStrings;
    this.ords = ords;
    this.pols = pols;
    this.navs = navs;
    this.just = just;
    this.ordsmap = ordsmap;
    this.polsmap = polsmap;
    this.navsmap = navsmap;
  }

  /**
   * @return The value of the {@code integer} attribute
   */
  @Override
  public int integer() {
    return integer;
  }

  /**
   * @return The value of the {@code string} attribute
   */
  @Override
  public String string() {
    return string;
  }

  /**
   * @return The value of the {@code bools} attribute
   */
  @Override
  public @Nullable Boolean bools() {
    return bools;
  }

  /**
   * @return The value of the {@code str} attribute
   */
  @Override
  public ImmutableList<String> str() {
    return str;
  }

  /**
   * @return The value of the {@code ints} attribute
   */
  @Override
  public ImmutableSet<Integer> ints() {
    return ints;
  }

  /**
   * @return A cloned {@code arrayInts} array
   */
  @Override
  public int[] arrayInts() {
    return arrayInts.clone();
  }

  /**
   * @return A cloned {@code arrayStrings} array
   */
  @Override
  public String[] arrayStrings() {
    return arrayStrings.clone();
  }

  /**
   * @return The value of the {@code ords} attribute
   */
  @Override
  public ImmutableSortedSet<Integer> ords() {
    return ords;
  }

  /**
   * @return The value of the {@code pols} attribute
   */
  @Override
  public ImmutableSet<RetentionPolicy> pols() {
    return pols;
  }

  /**
   * @return The value of the {@code navs} attribute
   */
  @Override
  public ImmutableSortedSet<Integer> navs() {
    return navs;
  }

  /**
   * @return The value of the {@code just} attribute
   */
  @Override
  public ImmutableMap<Long, Integer> just() {
    return just;
  }

  /**
   * @return The value of the {@code ordsmap} attribute
   */
  @Override
  public ImmutableSortedMap<Integer, String> ordsmap() {
    return ordsmap;
  }

  /**
   * @return The value of the {@code polsmap} attribute
   */
  @Override
  public ImmutableMap<RetentionPolicy, Integer> polsmap() {
    return polsmap;
  }

  /**
   * @return The value of the {@code navsmap} attribute
   */
  @Override
  public ImmutableSortedMap<String, Integer> navsmap() {
    return navsmap;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Companion#integer() integer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for integer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompanion withInteger(int value) {
    if (this.integer == value) return this;
    return new ImmutableCompanion(
        value,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Companion#string() string} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for string
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompanion withString(String value) {
    String newValue = Objects.requireNonNull(value, "string");
    if (this.string.equals(newValue)) return this;
    return new ImmutableCompanion(
        this.integer,
        newValue,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Companion#bools() bools} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bools (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompanion withBools(@Nullable Boolean value) {
    if (Objects.equals(this.bools, value)) return this;
    return new ImmutableCompanion(
        this.integer,
        this.string,
        value,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#str() str}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withStr(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        newValue,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#str() str}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of str elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withStr(Iterable<String> elements) {
    if (this.str == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        newValue,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#ints() ints}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withInts(int... elements) {
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(Ints.asList(elements));
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        newValue,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#ints() ints}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ints elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withInts(Iterable<Integer> elements) {
    if (this.ints == elements) return this;
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        newValue,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#arrayInts() arrayInts}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for arrayInts
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withArrayInts(int... elements) {
    int[] newValue = elements.clone();
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        newValue,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#arrayStrings() arrayStrings}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for arrayStrings
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withArrayStrings(String... elements) {
    String[] newValue = elements.clone();
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        newValue,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#ords() ords}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withOrds(int... elements) {
    ImmutableSortedSet<Integer> newValue = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural(),
        Ints.asList(elements));
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        newValue,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#ords() ords}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ords elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withOrds(Iterable<Integer> elements) {
    if (this.ords == elements) return this;
    ImmutableSortedSet<Integer> newValue = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural(),
        elements);
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        newValue,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#pols() pols}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withPols(RetentionPolicy... elements) {
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(Arrays.asList(elements));
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        newValue,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#pols() pols}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pols elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withPols(Iterable<RetentionPolicy> elements) {
    if (this.pols == elements) return this;
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(elements);
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        newValue,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#navs() navs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withNavs(int... elements) {
    ImmutableSortedSet<Integer> newValue = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural().reverse(),
        Ints.asList(elements));
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        newValue,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion#navs() navs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of navs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withNavs(Iterable<Integer> elements) {
    if (this.navs == elements) return this;
    ImmutableSortedSet<Integer> newValue = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural().reverse(),
        elements);
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        newValue,
        this.just,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object by replacing the {@link Companion#just() just} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the just map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withJust(Map<Long, ? extends Integer> entries) {
    if (this.just == entries) return this;
    ImmutableMap<Long, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        newValue,
        this.ordsmap,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object by replacing the {@link Companion#ordsmap() ordsmap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the ordsmap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withOrdsmap(Map<Integer, ? extends String> entries) {
    if (this.ordsmap == entries) return this;
    ImmutableSortedMap<Integer, String> newValue = ImmutableSortedMap.copyOf(entries,
        Ordering.<Integer>natural()
    );
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        newValue,
        this.polsmap,
        this.navsmap);
  }

  /**
   * Copy the current immutable object by replacing the {@link Companion#polsmap() polsmap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the polsmap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
    if (this.polsmap == entries) return this;
    ImmutableMap<RetentionPolicy, Integer> newValue = Maps.immutableEnumMap(entries);
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        newValue,
        this.navsmap);
  }

  /**
   * Copy the current immutable object by replacing the {@link Companion#navsmap() navsmap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the navsmap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompanion withNavsmap(Map<String, ? extends Integer> entries) {
    if (this.navsmap == entries) return this;
    ImmutableSortedMap<String, Integer> newValue = ImmutableSortedMap.copyOf(entries,
        Ordering.<String>natural().reverse()
    );
    return new ImmutableCompanion(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs,
        this.just,
        this.ordsmap,
        this.polsmap,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCompanion} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCompanion
        && equalTo(0, (ImmutableCompanion) another);
  }

  private boolean equalTo(int synthetic, ImmutableCompanion another) {
    return integer == another.integer
        && string.equals(another.string)
        && Objects.equals(bools, another.bools)
        && str.equals(another.str)
        && ints.equals(another.ints)
        && Arrays.equals(arrayInts, another.arrayInts)
        && Arrays.equals(arrayStrings, another.arrayStrings)
        && ords.equals(another.ords)
        && pols.equals(another.pols)
        && navs.equals(another.navs)
        && just.equals(another.just)
        && ordsmap.equals(another.ordsmap)
        && polsmap.equals(another.polsmap)
        && navsmap.equals(another.navsmap);
  }

  /**
   * Computes a hash code from attributes: {@code integer}, {@code string}, {@code bools}, {@code str}, {@code ints}, {@code arrayInts}, {@code arrayStrings}, {@code ords}, {@code pols}, {@code navs}, {@code just}, {@code ordsmap}, {@code polsmap}, {@code navsmap}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + integer;
    h += (h << 5) + string.hashCode();
    h += (h << 5) + Objects.hashCode(bools);
    h += (h << 5) + str.hashCode();
    h += (h << 5) + ints.hashCode();
    h += (h << 5) + Arrays.hashCode(arrayInts);
    h += (h << 5) + Arrays.hashCode(arrayStrings);
    h += (h << 5) + ords.hashCode();
    h += (h << 5) + pols.hashCode();
    h += (h << 5) + navs.hashCode();
    h += (h << 5) + just.hashCode();
    h += (h << 5) + ordsmap.hashCode();
    h += (h << 5) + polsmap.hashCode();
    h += (h << 5) + navsmap.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Companion} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Companion")
        .omitNullValues()
        .add("integer", integer)
        .add("string", string)
        .add("bools", bools)
        .add("str", str)
        .add("ints", ints)
        .add("arrayInts", Arrays.toString(arrayInts))
        .add("arrayStrings", Arrays.toString(arrayStrings))
        .add("ords", ords)
        .add("pols", pols)
        .add("navs", navs)
        .add("just", just)
        .add("ordsmap", ordsmap)
        .add("polsmap", polsmap)
        .add("navsmap", navsmap)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Companion} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Companion instance
   */
  public static ImmutableCompanion copyOf(Companion instance) {
    if (instance instanceof ImmutableCompanion) {
      return (ImmutableCompanion) instance;
    }
    return ImmutableCompanion.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCompanion ImmutableCompanion}.
   * <pre>
   * ImmutableCompanion.builder()
   *    .integer(int) // required {@link Companion#integer() integer}
   *    .string(String) // required {@link Companion#string() string}
   *    .bools(Boolean | null) // nullable {@link Companion#bools() bools}
   *    .addStr|addAllStr(String) // {@link Companion#str() str} elements
   *    .addInts|addAllInts(int) // {@link Companion#ints() ints} elements
   *    .arrayInts(int) // required {@link Companion#arrayInts() arrayInts}
   *    .arrayStrings(String) // required {@link Companion#arrayStrings() arrayStrings}
   *    .addOrds|addAllOrds(int) // {@link Companion#ords() ords} elements
   *    .addPols|addAllPols(annotation.RetentionPolicy) // {@link Companion#pols() pols} elements
   *    .addNavs|addAllNavs(int) // {@link Companion#navs() navs} elements
   *    .putJust|putAllJust(long =&gt; int) // {@link Companion#just() just} mappings
   *    .putOrdsmap|putAllOrdsmap(int =&gt; String) // {@link Companion#ordsmap() ordsmap} mappings
   *    .putPolsmap|putAllPolsmap(annotation.RetentionPolicy =&gt; int) // {@link Companion#polsmap() polsmap} mappings
   *    .putNavsmap|putAllNavsmap(String =&gt; int) // {@link Companion#navsmap() navsmap} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableCompanion builder
   */
  public static ImmutableCompanion.Builder builder() {
    return new ImmutableCompanion.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCompanion ImmutableCompanion}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Companion", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_INTEGER = 0x1L;
    private static final long INIT_BIT_STRING = 0x2L;
    private static final long INIT_BIT_ARRAY_INTS = 0x4L;
    private static final long INIT_BIT_ARRAY_STRINGS = 0x8L;
    private long initBits = 0xfL;

    private int integer;
    private @Nullable String string;
    private @Nullable Boolean bools;
    private ImmutableList.Builder<String> str = ImmutableList.builder();
    private ImmutableSet.Builder<Integer> ints = ImmutableSet.builder();
    private @Nullable int[] arrayInts;
    private @Nullable String[] arrayStrings;
    private ImmutableSortedSet.Builder<Integer> ords = ImmutableSortedSet.naturalOrder();
    private ImmutableSet.Builder<RetentionPolicy> pols = ImmutableSet.builder();
    private ImmutableSortedSet.Builder<Integer> navs = ImmutableSortedSet.reverseOrder();
    private ImmutableMap.Builder<Long, Integer> just = ImmutableMap.builder();
    private ImmutableSortedMap.Builder<Integer, String> ordsmap = ImmutableSortedMap.naturalOrder();
    private ImmutableMap.Builder<RetentionPolicy, Integer> polsmap = ImmutableMap.builder();
    private ImmutableSortedMap.Builder<String, Integer> navsmap = ImmutableSortedMap.reverseOrder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableCompanion} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableCompanion instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.integerIsSet()) {
        integer(instance.integer());
      }
      if (instance.stringIsSet()) {
        string(instance.string());
      }
      @Nullable Boolean boolsValue = instance.bools();
      if (boolsValue != null) {
        bools(boolsValue);
      }
      addAllStr(instance.str());
      addAllInts(instance.ints());
      if (instance.arrayIntsIsSet()) {
        arrayInts(instance.arrayInts());
      }
      if (instance.arrayStringsIsSet()) {
        arrayStrings(instance.arrayStrings());
      }
      addAllOrds(instance.ords());
      addAllPols(instance.pols());
      addAllNavs(instance.navs());
      putAllJust(instance.just());
      putAllOrdsmap(instance.ordsmap());
      putAllPolsmap(instance.polsmap());
      putAllNavsmap(instance.navsmap());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Companion} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Companion instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableCompanion) {
        return from((ModifiableCompanion) instance);
      }
      integer(instance.integer());
      string(instance.string());
      @Nullable Boolean boolsValue = instance.bools();
      if (boolsValue != null) {
        bools(boolsValue);
      }
      addAllStr(instance.str());
      addAllInts(instance.ints());
      arrayInts(instance.arrayInts());
      arrayStrings(instance.arrayStrings());
      addAllOrds(instance.ords());
      addAllPols(instance.pols());
      addAllNavs(instance.navs());
      putAllJust(instance.just());
      putAllOrdsmap(instance.ordsmap());
      putAllPolsmap(instance.polsmap());
      putAllNavsmap(instance.navsmap());
      return this;
    }

    /**
     * Initializes the value for the {@link Companion#integer() integer} attribute.
     * @param integer The value for integer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder integer(int integer) {
      this.integer = integer;
      initBits &= ~INIT_BIT_INTEGER;
      return this;
    }

    /**
     * Initializes the value for the {@link Companion#string() string} attribute.
     * @param string The value for string 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder string(String string) {
      this.string = Objects.requireNonNull(string, "string");
      initBits &= ~INIT_BIT_STRING;
      return this;
    }

    /**
     * Initializes the value for the {@link Companion#bools() bools} attribute.
     * @param bools The value for bools (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bools(@Nullable Boolean bools) {
      this.bools = bools;
      return this;
    }

    /**
     * Adds one element to {@link Companion#str() str} list.
     * @param element A str element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStr(String element) {
      this.str.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion#str() str} list.
     * @param elements An array of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStr(String... elements) {
      this.str.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion#str() str} list.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder str(Iterable<String> elements) {
      this.str = ImmutableList.builder();
      return addAllStr(elements);
    }

    /**
     * Adds elements to {@link Companion#str() str} list.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStr(Iterable<String> elements) {
      this.str.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Companion#ints() ints} set.
     * @param element A ints element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int element) {
      this.ints.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion#ints() ints} set.
     * @param elements An array of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int... elements) {
      this.ints.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ints(Iterable<Integer> elements) {
      this.ints = ImmutableSet.builder();
      return addAllInts(elements);
    }

    /**
     * Adds elements to {@link Companion#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInts(Iterable<Integer> elements) {
      this.ints.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Companion#arrayInts() arrayInts} attribute.
     * @param arrayInts The elements for arrayInts
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder arrayInts(int... arrayInts) {
      this.arrayInts = arrayInts.clone();
      initBits &= ~INIT_BIT_ARRAY_INTS;
      return this;
    }

    /**
     * Initializes the value for the {@link Companion#arrayStrings() arrayStrings} attribute.
     * @param arrayStrings The elements for arrayStrings
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder arrayStrings(String... arrayStrings) {
      this.arrayStrings = arrayStrings.clone();
      initBits &= ~INIT_BIT_ARRAY_STRINGS;
      return this;
    }

    /**
     * Adds one element to {@link Companion#ords() ords} sortedSet.
     * @param element A ords element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOrds(int element) {
      this.ords.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion#ords() ords} sortedSet.
     * @param elements An array of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOrds(int... elements) {
      this.ords.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion#ords() ords} sortedSet.
     * @param elements An iterable of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ords(Iterable<Integer> elements) {
      this.ords = ImmutableSortedSet.naturalOrder();
      return addAllOrds(elements);
    }

    /**
     * Adds elements to {@link Companion#ords() ords} sortedSet.
     * @param elements An iterable of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOrds(Iterable<Integer> elements) {
      this.ords.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Companion#pols() pols} set.
     * @param element A pols element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPols(RetentionPolicy element) {
      this.pols.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion#pols() pols} set.
     * @param elements An array of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPols(RetentionPolicy... elements) {
      this.pols.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pols(Iterable<RetentionPolicy> elements) {
      this.pols = ImmutableSet.builder();
      return addAllPols(elements);
    }

    /**
     * Adds elements to {@link Companion#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
      this.pols.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Companion#navs() navs} sortedSet.
     * @param element A navs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNavs(int element) {
      this.navs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion#navs() navs} sortedSet.
     * @param elements An array of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNavs(int... elements) {
      this.navs.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion#navs() navs} sortedSet.
     * @param elements An iterable of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder navs(Iterable<Integer> elements) {
      this.navs = ImmutableSortedSet.reverseOrder();
      return addAllNavs(elements);
    }

    /**
     * Adds elements to {@link Companion#navs() navs} sortedSet.
     * @param elements An iterable of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNavs(Iterable<Integer> elements) {
      this.navs.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link Companion#just() just} map.
     * @param key The key in the just map
     * @param value The associated value in the just map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putJust(long key, int value) {
      this.just.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Companion#just() just} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putJust(Map.Entry<Long, ? extends Integer> entry) {
      this.just.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Companion#just() just} map. Nulls are not permitted
     * @param entries The entries that will be added to the just map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder just(Map<Long, ? extends Integer> entries) {
      this.just = ImmutableMap.builder();
      return putAllJust(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Companion#just() just} map. Nulls are not permitted
     * @param entries The entries that will be added to the just map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllJust(Map<Long, ? extends Integer> entries) {
      this.just.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link Companion#ordsmap() ordsmap} map.
     * @param key The key in the ordsmap map
     * @param value The associated value in the ordsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOrdsmap(int key, String value) {
      this.ordsmap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Companion#ordsmap() ordsmap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOrdsmap(Map.Entry<Integer, ? extends String> entry) {
      this.ordsmap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Companion#ordsmap() ordsmap} map. Nulls are not permitted
     * @param entries The entries that will be added to the ordsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ordsmap(Map<Integer, ? extends String> entries) {
      this.ordsmap = ImmutableSortedMap.naturalOrder();
      return putAllOrdsmap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Companion#ordsmap() ordsmap} map. Nulls are not permitted
     * @param entries The entries that will be added to the ordsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllOrdsmap(Map<Integer, ? extends String> entries) {
      this.ordsmap.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link Companion#polsmap() polsmap} map.
     * @param key The key in the polsmap map
     * @param value The associated value in the polsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPolsmap(RetentionPolicy key, int value) {
      this.polsmap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Companion#polsmap() polsmap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPolsmap(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
      this.polsmap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Companion#polsmap() polsmap} map. Nulls are not permitted
     * @param entries The entries that will be added to the polsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder polsmap(Map<RetentionPolicy, ? extends Integer> entries) {
      this.polsmap = ImmutableMap.builder();
      return putAllPolsmap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Companion#polsmap() polsmap} map. Nulls are not permitted
     * @param entries The entries that will be added to the polsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
      this.polsmap.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link Companion#navsmap() navsmap} map.
     * @param key The key in the navsmap map
     * @param value The associated value in the navsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putNavsmap(String key, int value) {
      this.navsmap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Companion#navsmap() navsmap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putNavsmap(Map.Entry<String, ? extends Integer> entry) {
      this.navsmap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Companion#navsmap() navsmap} map. Nulls are not permitted
     * @param entries The entries that will be added to the navsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder navsmap(Map<String, ? extends Integer> entries) {
      this.navsmap = ImmutableSortedMap.reverseOrder();
      return putAllNavsmap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Companion#navsmap() navsmap} map. Nulls are not permitted
     * @param entries The entries that will be added to the navsmap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllNavsmap(Map<String, ? extends Integer> entries) {
      this.navsmap.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCompanion ImmutableCompanion}.
     * @return An immutable instance of Companion
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCompanion build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCompanion(
          integer,
          string,
          bools,
          str.build(),
          ints.build(),
          arrayInts,
          arrayStrings,
          ords.build(),
          Sets.immutableEnumSet(pols.build()),
          navs.build(),
          just.build(),
          ordsmap.build(),
          Maps.immutableEnumMap(polsmap.build()),
          navsmap.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INTEGER) != 0) attributes.add("integer");
      if ((initBits & INIT_BIT_STRING) != 0) attributes.add("string");
      if ((initBits & INIT_BIT_ARRAY_INTS) != 0) attributes.add("arrayInts");
      if ((initBits & INIT_BIT_ARRAY_STRINGS) != 0) attributes.add("arrayStrings");
      return "Cannot build Companion, some of required attributes are not set " + attributes;
    }
  }
}
