package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Companion.JdkComp}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJdkComp.builder()}.
 */
@Generated(from = "Companion.JdkComp", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJdkComp implements Companion.JdkComp {
  private final int integer;
  private final String string;
  private final @Nullable Boolean bools;
  private final List<String> str;
  private final Set<Integer> ints;
  private final int[] arrayInts;
  private final String[] arrayStrings;
  private final SortedSet<Integer> ords;
  private final Set<RetentionPolicy> pols;
  private final NavigableSet<Integer> navs;

  private ImmutableJdkComp(
      int integer,
      String string,
      @Nullable Boolean bools,
      List<String> str,
      Set<Integer> ints,
      int[] arrayInts,
      String[] arrayStrings,
      SortedSet<Integer> ords,
      Set<RetentionPolicy> pols,
      NavigableSet<Integer> navs) {
    this.integer = integer;
    this.string = string;
    this.bools = bools;
    this.str = str;
    this.ints = ints;
    this.arrayInts = arrayInts;
    this.arrayStrings = arrayStrings;
    this.ords = ords;
    this.pols = pols;
    this.navs = navs;
  }

  /**
   * @return The value of the {@code integer} attribute
   */
  @Override
  public int integer() {
    return integer;
  }

  /**
   * @return The value of the {@code string} attribute
   */
  @Override
  public String string() {
    return string;
  }

  /**
   * @return The value of the {@code bools} attribute
   */
  @Override
  public @Nullable Boolean bools() {
    return bools;
  }

  /**
   * @return The value of the {@code str} attribute
   */
  @Override
  public List<String> str() {
    return str;
  }

  /**
   * @return The value of the {@code ints} attribute
   */
  @Override
  public Set<Integer> ints() {
    return ints;
  }

  /**
   * @return A cloned {@code arrayInts} array
   */
  @Override
  public int[] arrayInts() {
    return arrayInts.clone();
  }

  /**
   * @return A cloned {@code arrayStrings} array
   */
  @Override
  public String[] arrayStrings() {
    return arrayStrings.clone();
  }

  /**
   * @return The value of the {@code ords} attribute
   */
  @Override
  public SortedSet<Integer> ords() {
    return ords;
  }

  /**
   * @return The value of the {@code pols} attribute
   */
  @Override
  public Set<RetentionPolicy> pols() {
    return pols;
  }

  /**
   * @return The value of the {@code navs} attribute
   */
  @Override
  public NavigableSet<Integer> navs() {
    return navs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Companion.JdkComp#integer() integer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for integer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkComp withInteger(int value) {
    if (this.integer == value) return this;
    return new ImmutableJdkComp(
        value,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Companion.JdkComp#string() string} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for string
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkComp withString(String value) {
    String newValue = Objects.requireNonNull(value, "string");
    if (this.string.equals(newValue)) return this;
    return new ImmutableJdkComp(
        this.integer,
        newValue,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Companion.JdkComp#bools() bools} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bools (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkComp withBools(@Nullable Boolean value) {
    if (Objects.equals(this.bools, value)) return this;
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        value,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#str() str}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withStr(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        newValue,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#str() str}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of str elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withStr(Iterable<String> elements) {
    if (this.str == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        newValue,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#ints() ints}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withInts(int... elements) {
    ArrayList<Integer> wrappedList = new ArrayList<>(elements.length);
    for (int element : elements) {
      wrappedList.add(element);
    }
    Set<Integer> newValue = createUnmodifiableSet(wrappedList);
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        newValue,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#ints() ints}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ints elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withInts(Iterable<Integer> elements) {
    if (this.ints == elements) return this;
    Set<Integer> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        newValue,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#arrayInts() arrayInts}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for arrayInts
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withArrayInts(int... elements) {
    int[] newValue = elements.clone();
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        newValue,
        this.arrayStrings,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#arrayStrings() arrayStrings}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for arrayStrings
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withArrayStrings(String... elements) {
    String[] newValue = elements.clone();
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        newValue,
        this.ords,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#ords() ords}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withOrds(int... elements) {
    ArrayList<Integer> wrappedList = new ArrayList<>(elements.length);
    for (int element : elements) {
      wrappedList.add(element);
    }
    SortedSet<Integer> newValue = createUnmodifiableSortedSet(false, wrappedList);
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        newValue,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#ords() ords}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ords elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withOrds(Iterable<Integer> elements) {
    if (this.ords == elements) return this;
    SortedSet<Integer> newValue = createUnmodifiableSortedSet(false, createSafeList(elements, true, false));
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        newValue,
        this.pols,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#pols() pols}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withPols(RetentionPolicy... elements) {
    Set<RetentionPolicy> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        newValue,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#pols() pols}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pols elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withPols(Iterable<RetentionPolicy> elements) {
    if (this.pols == elements) return this;
    Set<RetentionPolicy> newValue = createUnmodifiableEnumSet(elements);
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        newValue,
        this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#navs() navs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withNavs(int... elements) {
    ArrayList<Integer> wrappedList = new ArrayList<>(elements.length);
    for (int element : elements) {
      wrappedList.add(element);
    }
    NavigableSet<Integer> newValue = createUnmodifiableSortedSet(true, wrappedList);
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.JdkComp#navs() navs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of navs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkComp withNavs(Iterable<Integer> elements) {
    if (this.navs == elements) return this;
    NavigableSet<Integer> newValue = createUnmodifiableSortedSet(true, createSafeList(elements, true, false));
    return new ImmutableJdkComp(
        this.integer,
        this.string,
        this.bools,
        this.str,
        this.ints,
        this.arrayInts,
        this.arrayStrings,
        this.ords,
        this.pols,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkComp} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJdkComp
        && equalTo(0, (ImmutableJdkComp) another);
  }

  private boolean equalTo(int synthetic, ImmutableJdkComp another) {
    return integer == another.integer
        && string.equals(another.string)
        && Objects.equals(bools, another.bools)
        && str.equals(another.str)
        && ints.equals(another.ints)
        && Arrays.equals(arrayInts, another.arrayInts)
        && Arrays.equals(arrayStrings, another.arrayStrings)
        && ords.equals(another.ords)
        && pols.equals(another.pols)
        && navs.equals(another.navs);
  }

  /**
   * Computes a hash code from attributes: {@code integer}, {@code string}, {@code bools}, {@code str}, {@code ints}, {@code arrayInts}, {@code arrayStrings}, {@code ords}, {@code pols}, {@code navs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + integer;
    h += (h << 5) + string.hashCode();
    h += (h << 5) + Objects.hashCode(bools);
    h += (h << 5) + str.hashCode();
    h += (h << 5) + ints.hashCode();
    h += (h << 5) + Arrays.hashCode(arrayInts);
    h += (h << 5) + Arrays.hashCode(arrayStrings);
    h += (h << 5) + ords.hashCode();
    h += (h << 5) + pols.hashCode();
    h += (h << 5) + navs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JdkComp} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JdkComp{"
        + "integer=" + integer
        + ", string=" + string
        + ", bools=" + bools
        + ", str=" + str
        + ", ints=" + ints
        + ", arrayInts=" + Arrays.toString(arrayInts)
        + ", arrayStrings=" + Arrays.toString(arrayStrings)
        + ", ords=" + ords
        + ", pols=" + pols
        + ", navs=" + navs
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Companion.JdkComp} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkComp instance
   */
  public static ImmutableJdkComp copyOf(Companion.JdkComp instance) {
    if (instance instanceof ImmutableJdkComp) {
      return (ImmutableJdkComp) instance;
    }
    return ImmutableJdkComp.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJdkComp ImmutableJdkComp}.
   * <pre>
   * ImmutableJdkComp.builder()
   *    .integer(int) // required {@link Companion.JdkComp#integer() integer}
   *    .string(String) // required {@link Companion.JdkComp#string() string}
   *    .bools(Boolean | null) // nullable {@link Companion.JdkComp#bools() bools}
   *    .addStr|addAllStr(String) // {@link Companion.JdkComp#str() str} elements
   *    .addInts|addAllInts(int) // {@link Companion.JdkComp#ints() ints} elements
   *    .arrayInts(int) // required {@link Companion.JdkComp#arrayInts() arrayInts}
   *    .arrayStrings(String) // required {@link Companion.JdkComp#arrayStrings() arrayStrings}
   *    .addOrds|addAllOrds(int) // {@link Companion.JdkComp#ords() ords} elements
   *    .addPols|addAllPols(annotation.RetentionPolicy) // {@link Companion.JdkComp#pols() pols} elements
   *    .addNavs|addAllNavs(int) // {@link Companion.JdkComp#navs() navs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableJdkComp builder
   */
  public static ImmutableJdkComp.Builder builder() {
    return new ImmutableJdkComp.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJdkComp ImmutableJdkComp}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Companion.JdkComp", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_INTEGER = 0x1L;
    private static final long INIT_BIT_STRING = 0x2L;
    private static final long INIT_BIT_ARRAY_INTS = 0x4L;
    private static final long INIT_BIT_ARRAY_STRINGS = 0x8L;
    private long initBits = 0xfL;

    private int integer;
    private @Nullable String string;
    private @Nullable Boolean bools;
    private List<String> str = new ArrayList<String>();
    private List<Integer> ints = new ArrayList<Integer>();
    private @Nullable int[] arrayInts;
    private @Nullable String[] arrayStrings;
    private List<Integer> ords = new ArrayList<Integer>();
    private EnumSet<RetentionPolicy> pols = EnumSet.noneOf(RetentionPolicy.class);
    private List<Integer> navs = new ArrayList<Integer>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableJdkComp} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableJdkComp instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.integerIsSet()) {
        integer(instance.integer());
      }
      if (instance.stringIsSet()) {
        string(instance.string());
      }
      @Nullable Boolean boolsValue = instance.bools();
      if (boolsValue != null) {
        bools(boolsValue);
      }
      addAllStr(instance.str());
      addAllInts(instance.ints());
      if (instance.arrayIntsIsSet()) {
        arrayInts(instance.arrayInts());
      }
      if (instance.arrayStringsIsSet()) {
        arrayStrings(instance.arrayStrings());
      }
      addAllOrds(instance.ords());
      addAllPols(instance.pols());
      addAllNavs(instance.navs());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code JdkComp} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Companion.JdkComp instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableJdkComp) {
        return from((ModifiableJdkComp) instance);
      }
      integer(instance.integer());
      string(instance.string());
      @Nullable Boolean boolsValue = instance.bools();
      if (boolsValue != null) {
        bools(boolsValue);
      }
      addAllStr(instance.str());
      addAllInts(instance.ints());
      arrayInts(instance.arrayInts());
      arrayStrings(instance.arrayStrings());
      addAllOrds(instance.ords());
      addAllPols(instance.pols());
      addAllNavs(instance.navs());
      return this;
    }

    /**
     * Initializes the value for the {@link Companion.JdkComp#integer() integer} attribute.
     * @param integer The value for integer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder integer(int integer) {
      this.integer = integer;
      initBits &= ~INIT_BIT_INTEGER;
      return this;
    }

    /**
     * Initializes the value for the {@link Companion.JdkComp#string() string} attribute.
     * @param string The value for string 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder string(String string) {
      this.string = Objects.requireNonNull(string, "string");
      initBits &= ~INIT_BIT_STRING;
      return this;
    }

    /**
     * Initializes the value for the {@link Companion.JdkComp#bools() bools} attribute.
     * @param bools The value for bools (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bools(@Nullable Boolean bools) {
      this.bools = bools;
      return this;
    }

    /**
     * Adds one element to {@link Companion.JdkComp#str() str} list.
     * @param element A str element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStr(String element) {
      this.str.add(Objects.requireNonNull(element, "str element"));
      return this;
    }

    /**
     * Adds elements to {@link Companion.JdkComp#str() str} list.
     * @param elements An array of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStr(String... elements) {
      for (String element : elements) {
        this.str.add(Objects.requireNonNull(element, "str element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.JdkComp#str() str} list.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder str(Iterable<String> elements) {
      this.str.clear();
      return addAllStr(elements);
    }

    /**
     * Adds elements to {@link Companion.JdkComp#str() str} list.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStr(Iterable<String> elements) {
      for (String element : elements) {
        this.str.add(Objects.requireNonNull(element, "str element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Companion.JdkComp#ints() ints} set.
     * @param element A ints element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int element) {
      this.ints.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion.JdkComp#ints() ints} set.
     * @param elements An array of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int... elements) {
      for (int element : elements) {
        this.ints.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.JdkComp#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ints(Iterable<Integer> elements) {
      this.ints.clear();
      return addAllInts(elements);
    }

    /**
     * Adds elements to {@link Companion.JdkComp#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInts(Iterable<Integer> elements) {
      for (Integer element : elements) {
        this.ints.add(Objects.requireNonNull(element, "ints element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Companion.JdkComp#arrayInts() arrayInts} attribute.
     * @param arrayInts The elements for arrayInts
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder arrayInts(int... arrayInts) {
      this.arrayInts = arrayInts.clone();
      initBits &= ~INIT_BIT_ARRAY_INTS;
      return this;
    }

    /**
     * Initializes the value for the {@link Companion.JdkComp#arrayStrings() arrayStrings} attribute.
     * @param arrayStrings The elements for arrayStrings
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder arrayStrings(String... arrayStrings) {
      this.arrayStrings = arrayStrings.clone();
      initBits &= ~INIT_BIT_ARRAY_STRINGS;
      return this;
    }

    /**
     * Adds one element to {@link Companion.JdkComp#ords() ords} sortedSet.
     * @param element A ords element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOrds(int element) {
      this.ords.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion.JdkComp#ords() ords} sortedSet.
     * @param elements An array of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOrds(int... elements) {
      for (int element : elements) {
        this.ords.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.JdkComp#ords() ords} sortedSet.
     * @param elements An iterable of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ords(Iterable<Integer> elements) {
      this.ords.clear();
      return addAllOrds(elements);
    }

    /**
     * Adds elements to {@link Companion.JdkComp#ords() ords} sortedSet.
     * @param elements An iterable of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOrds(Iterable<Integer> elements) {
      for (Integer element : elements) {
        this.ords.add(Objects.requireNonNull(element, "ords element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Companion.JdkComp#pols() pols} set.
     * @param element A pols element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPols(RetentionPolicy element) {
      this.pols.add(Objects.requireNonNull(element, "pols element"));
      return this;
    }

    /**
     * Adds elements to {@link Companion.JdkComp#pols() pols} set.
     * @param elements An array of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPols(RetentionPolicy... elements) {
      for (RetentionPolicy element : elements) {
        this.pols.add(Objects.requireNonNull(element, "pols element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.JdkComp#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pols(Iterable<RetentionPolicy> elements) {
      this.pols.clear();
      return addAllPols(elements);
    }

    /**
     * Adds elements to {@link Companion.JdkComp#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
      for (RetentionPolicy element : elements) {
        this.pols.add(Objects.requireNonNull(element, "pols element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Companion.JdkComp#navs() navs} sortedSet.
     * @param element A navs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNavs(int element) {
      this.navs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion.JdkComp#navs() navs} sortedSet.
     * @param elements An array of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNavs(int... elements) {
      for (int element : elements) {
        this.navs.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.JdkComp#navs() navs} sortedSet.
     * @param elements An iterable of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder navs(Iterable<Integer> elements) {
      this.navs.clear();
      return addAllNavs(elements);
    }

    /**
     * Adds elements to {@link Companion.JdkComp#navs() navs} sortedSet.
     * @param elements An iterable of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNavs(Iterable<Integer> elements) {
      for (Integer element : elements) {
        this.navs.add(Objects.requireNonNull(element, "navs element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableJdkComp ImmutableJdkComp}.
     * @return An immutable instance of JdkComp
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJdkComp build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJdkComp(
          integer,
          string,
          bools,
          createUnmodifiableList(true, str),
          createUnmodifiableSet(ints),
          arrayInts,
          arrayStrings,
          createUnmodifiableSortedSet(false, createSafeList(ords, false, false)),
          createUnmodifiableEnumSet(pols),
          createUnmodifiableSortedSet(true, createSafeList(navs, false, false)));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INTEGER) != 0) attributes.add("integer");
      if ((initBits & INIT_BIT_STRING) != 0) attributes.add("string");
      if ((initBits & INIT_BIT_ARRAY_INTS) != 0) attributes.add("arrayInts");
      if ((initBits & INIT_BIT_ARRAY_STRINGS) != 0) attributes.add("arrayStrings");
      return "Cannot build JdkComp, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  @SuppressWarnings("unchecked")
  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }

  private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
    TreeSet<T> set = reverse
        ? new TreeSet<T>(Collections.<T>reverseOrder())
        : new TreeSet<T>();
    set.addAll(list);
    return Collections.unmodifiableNavigableSet(set);
  }
}
