package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MutableImmutableCollection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMutableImmutableCollection.builder()}.
 */
@Generated(from = "MutableImmutableCollection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMutableImmutableCollection
    extends MutableImmutableCollection {
  private final ImmutableList<String> a;
  private final ImmutableSet<String> b;
  private final ImmutableMultimap<String, Integer> c;
  private final ImmutableMap<Void, Void> d;

  private ImmutableMutableImmutableCollection(
      ImmutableList<String> a,
      ImmutableSet<String> b,
      ImmutableMultimap<String, Integer> c,
      ImmutableMap<Void, Void> d) {
    this.a = a;
    this.b = b;
    this.c = c;
    this.d = d;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  ImmutableList<String> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  ImmutableSet<String> b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  ImmutableMultimap<String, Integer> c() {
    return c;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  ImmutableMap<Void, Void> d() {
    return d;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MutableImmutableCollection#a() a}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMutableImmutableCollection withA(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMutableImmutableCollection(newValue, this.b, this.c, this.d);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MutableImmutableCollection#a() a}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of a elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMutableImmutableCollection withA(Iterable<String> elements) {
    if (this.a == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMutableImmutableCollection(newValue, this.b, this.c, this.d);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MutableImmutableCollection#b() b}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMutableImmutableCollection withB(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableMutableImmutableCollection(this.a, newValue, this.c, this.d);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MutableImmutableCollection#b() b}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of b elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMutableImmutableCollection withB(Iterable<String> elements) {
    if (this.b == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableMutableImmutableCollection(this.a, newValue, this.c, this.d);
  }

  /**
   * Copy the current immutable object by replacing the {@link MutableImmutableCollection#c() c} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the c map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMutableImmutableCollection withC(Multimap<String, ? extends Integer> entries) {
    if (this.c == entries) return this;
    ImmutableMultimap<String, Integer> newValue = ImmutableMultimap.copyOf(entries);
    return new ImmutableMutableImmutableCollection(this.a, this.b, newValue, this.d);
  }

  /**
   * Copy the current immutable object by replacing the {@link MutableImmutableCollection#d() d} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the d map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMutableImmutableCollection withD(Map<? extends Void, ? extends Void> entries) {
    if (this.d == entries) return this;
    ImmutableMap<Void, Void> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableMutableImmutableCollection(this.a, this.b, this.c, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMutableImmutableCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMutableImmutableCollection
        && equalTo(0, (ImmutableMutableImmutableCollection) another);
  }

  private boolean equalTo(int synthetic, ImmutableMutableImmutableCollection another) {
    return a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && d.equals(another.d);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}, {@code d}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + d.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MutableImmutableCollection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MutableImmutableCollection")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .add("d", d)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MutableImmutableCollection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MutableImmutableCollection instance
   */
  public static ImmutableMutableImmutableCollection copyOf(MutableImmutableCollection instance) {
    if (instance instanceof ImmutableMutableImmutableCollection) {
      return (ImmutableMutableImmutableCollection) instance;
    }
    return ImmutableMutableImmutableCollection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMutableImmutableCollection ImmutableMutableImmutableCollection}.
   * <pre>
   * ImmutableMutableImmutableCollection.builder()
   *    .addA|addAllA(String) // {@link MutableImmutableCollection#a() a} elements
   *    .addB|addAllB(String) // {@link MutableImmutableCollection#b() b} elements
   *    .putC|putAllC(String =&gt; int) // {@link MutableImmutableCollection#c() c} mappings
   *    .putD|putAllD(Void =&gt; Void) // {@link MutableImmutableCollection#d() d} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableMutableImmutableCollection builder
   */
  public static ImmutableMutableImmutableCollection.Builder builder() {
    return new ImmutableMutableImmutableCollection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMutableImmutableCollection ImmutableMutableImmutableCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MutableImmutableCollection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> a = ImmutableList.builder();
    private ImmutableSet.Builder<String> b = ImmutableSet.builder();
    private ImmutableMultimap.Builder<String, Integer> c = ImmutableMultimap.builder();
    private ImmutableMap.Builder<Void, Void> d = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableMutableImmutableCollection} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableMutableImmutableCollection instance) {
      Objects.requireNonNull(instance, "instance");
      addAllA(instance.a());
      addAllB(instance.b());
      putAllC(instance.c());
      putAllD(instance.d());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code MutableImmutableCollection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MutableImmutableCollection instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableMutableImmutableCollection) {
        return from((ModifiableMutableImmutableCollection) instance);
      }
      addAllA(instance.a());
      addAllB(instance.b());
      putAllC(instance.c());
      putAllD(instance.d());
      return this;
    }

    /**
     * Adds one element to {@link MutableImmutableCollection#a() a} list.
     * @param element A a element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addA(String element) {
      this.a.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MutableImmutableCollection#a() a} list.
     * @param elements An array of a elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addA(String... elements) {
      this.a.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MutableImmutableCollection#a() a} list.
     * @param elements An iterable of a elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(Iterable<String> elements) {
      this.a = ImmutableList.builder();
      return addAllA(elements);
    }

    /**
     * Adds elements to {@link MutableImmutableCollection#a() a} list.
     * @param elements An iterable of a elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllA(Iterable<String> elements) {
      this.a.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link MutableImmutableCollection#b() b} set.
     * @param element A b element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(String element) {
      this.b.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MutableImmutableCollection#b() b} set.
     * @param elements An array of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(String... elements) {
      this.b.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MutableImmutableCollection#b() b} set.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(Iterable<String> elements) {
      this.b = ImmutableSet.builder();
      return addAllB(elements);
    }

    /**
     * Adds elements to {@link MutableImmutableCollection#b() b} set.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllB(Iterable<String> elements) {
      this.b.addAll(elements);
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link MutableImmutableCollection#c() c} true. Nulls are not permitted
     * @param key The key for c
     * @param values The values for c
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putC(String key, int... values) {
      this.c.putAll(key, Ints.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link MutableImmutableCollection#c() c} true. Nulls are not permitted
     * @param key The key for c
     * @param values The values for c
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllC(String key, Iterable<Integer> values) {
      this.c.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link MutableImmutableCollection#c() c} map.
     * @param key The key in the c map
     * @param value The associated value in the c map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putC(String key, int value) {
      this.c.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MutableImmutableCollection#c() c} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putC(Map.Entry<String, ? extends Integer> entry) {
      this.c.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MutableImmutableCollection#c() c} map. Nulls are not permitted
     * @param entries The entries that will be added to the c map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(Multimap<String, ? extends Integer> entries) {
      this.c = ImmutableMultimap.builder();
      return putAllC(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MutableImmutableCollection#c() c} map. Nulls are not permitted
     * @param entries The entries that will be added to the c map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllC(Multimap<String, ? extends Integer> entries) {
      this.c.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link MutableImmutableCollection#d() d} map.
     * @param key The key in the d map
     * @param value The associated value in the d map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putD(Void key, Void value) {
      this.d.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MutableImmutableCollection#d() d} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putD(Map.Entry<? extends Void, ? extends Void> entry) {
      this.d.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MutableImmutableCollection#d() d} map. Nulls are not permitted
     * @param entries The entries that will be added to the d map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d(Map<? extends Void, ? extends Void> entries) {
      this.d = ImmutableMap.builder();
      return putAllD(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MutableImmutableCollection#d() d} map. Nulls are not permitted
     * @param entries The entries that will be added to the d map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllD(Map<? extends Void, ? extends Void> entries) {
      this.d.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableMutableImmutableCollection ImmutableMutableImmutableCollection}.
     * @return An immutable instance of MutableImmutableCollection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMutableImmutableCollection build() {
      return new ImmutableMutableImmutableCollection(a.build(), b.build(), c.build(), d.build());
    }
  }
}
