package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullableList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableList.builder()}.
 */
@Generated(from = "NullableList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNullableList implements NullableList {
  private final @Nullable Object object;
  private final @Nullable ImmutableList<Object> objects;

  private ImmutableNullableList(
      @Nullable Object object,
      @Nullable ImmutableList<Object> objects) {
    this.object = object;
    this.objects = objects;
  }

  /**
   * @return The value of the {@code object} attribute
   */
  @Override
  public @Nullable Object getObject() {
    return object;
  }

  /**
   * @return The value of the {@code objects} attribute
   */
  @Override
  public @Nullable ImmutableList<Object> getObjects() {
    return objects;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NullableList#getObject() object} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for object (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullableList withObject(@Nullable Object value) {
    if (this.object == value) return this;
    return new ImmutableNullableList(value, this.objects);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableList#getObjects() objects}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableList withObjects(@Nullable Object... elements) {
    if (elements == null) {
      return new ImmutableNullableList(this.object, null);
    }
    @Nullable ImmutableList<Object> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableNullableList(this.object, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableList#getObjects() objects}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objects elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableList withObjects(@Nullable Iterable<? extends Object> elements) {
    if (this.objects == elements) return this;
    @Nullable ImmutableList<Object> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableNullableList(this.object, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableList
        && equalTo(0, (ImmutableNullableList) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableList another) {
    return Objects.equals(object, another.object)
        && Objects.equals(objects, another.objects);
  }

  /**
   * Computes a hash code from attributes: {@code object}, {@code objects}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(object);
    h += (h << 5) + Objects.hashCode(objects);
    return h;
  }

  /**
   * Prints the immutable value {@code NullableList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullableList")
        .omitNullValues()
        .add("object", object)
        .add("objects", objects)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NullableList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableList instance
   */
  public static ImmutableNullableList copyOf(NullableList instance) {
    if (instance instanceof ImmutableNullableList) {
      return (ImmutableNullableList) instance;
    }
    return ImmutableNullableList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableList ImmutableNullableList}.
   * <pre>
   * ImmutableNullableList.builder()
   *    .object(Object | null) // nullable {@link NullableList#getObject() object}
   *    .objects(List&amp;lt;Object&amp;gt; | null) // nullable {@link NullableList#getObjects() objects}
   *    .build();
   * </pre>
   * @return A new ImmutableNullableList builder
   */
  public static ImmutableNullableList.Builder builder() {
    return new ImmutableNullableList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableList ImmutableNullableList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullableList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Object object;
    private ImmutableList.Builder<Object> objects = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableNullableList} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableNullableList instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Object objectValue = instance.getObject();
      if (objectValue != null) {
        object(objectValue);
      }
      @Nullable List<Object> objectsValue = instance.getObjects();
      if (objectsValue != null) {
        addAllObjects(objectsValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullableList instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableNullableList) {
        return from((ModifiableNullableList) instance);
      }
      @Nullable Object objectValue = instance.getObject();
      if (objectValue != null) {
        object(objectValue);
      }
      @Nullable List<Object> objectsValue = instance.getObjects();
      if (objectsValue != null) {
        addAllObjects(objectsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NullableList#getObject() object} attribute.
     * @param object The value for object (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder object(@Nullable Object object) {
      this.object = object;
      return this;
    }

    /**
     * Adds one element to {@link NullableList#getObjects() objects} list.
     * @param element A objects element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjects(Object element) {
      if (this.objects == null) {
        this.objects = ImmutableList.builder();
      }
      this.objects.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NullableList#getObjects() objects} list.
     * @param elements An array of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjects(Object... elements) {
      if (this.objects == null) {
        this.objects = ImmutableList.builder();
      }
      this.objects.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NullableList#getObjects() objects} list.
     * @param elements An iterable of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder objects(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.objects = null;
        return this;
      }
      this.objects = ImmutableList.builder();
      return addAllObjects(elements);
    }

    /**
     * Adds elements to {@link NullableList#getObjects() objects} list.
     * @param elements An iterable of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjects(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "objects element");
      if (this.objects == null) {
        this.objects = ImmutableList.builder();
      }
      this.objects.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableList ImmutableNullableList}.
     * @return An immutable instance of NullableList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableList build() {
      return new ImmutableNullableList(object, objects == null ? null : objects.build());
    }
  }
}
