package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link BeanFriendly BeanFriendly} type.
 * <p>Use the constructor to create new modifiable instances. You may even extend this class to
 * add some convenience methods, however most of the methods in this class are final
 * to preserve safety and predictable invariants.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableBeanFriendly is not thread-safe</em>
 * @see ImmutableBeanFriendly
 */
@Generated(from = "BeanFriendly", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "BeanFriendly"})
@NotThreadSafe
public class ModifiableBeanFriendly implements BeanFriendly {
  private static final long INIT_BIT_PRIMARY = 0x1L;
  private static final long INIT_BIT_ID = 0x2L;
  private static final long INIT_BIT_DESCRIPTION = 0x4L;
  private static final long OPT_BIT_DEFAULT_NULLABLE_MOD = 0x1L;
  private long initBits = 0x7L;
  private long optBits;

  private boolean primary;
  private int id;
  private String description;
  private Set<String> names = new LinkedHashSet<String>();
  private Map<String, String> options = new LinkedHashMap<String, String>();
  private @Nullable BeanFriendly.Mod mod;
  private BeanFriendly.Mod defaultMod;
  private @Nullable BeanFriendly.Mod defaultNullableMod;
  private @Nullable List<Integer> extra = null;

  /**
   * @return value of {@code primary} attribute
   */
  @Override
  public boolean isPrimary() {
    if (!primaryIsSet()) {
      checkRequiredAttributes();
    }
    return primary;
  }

  /**
   * @return value of {@code id} attribute
   */
  @Override
  public int getId() {
    if (!idIsSet()) {
      checkRequiredAttributes();
    }
    return id;
  }

  /**
   * @return value of {@code description} attribute
   */
  @Override
  public String getDescription() {
    if (!descriptionIsSet()) {
      checkRequiredAttributes();
    }
    return description;
  }

  /**
   * @return modifiable set {@code names}
   */
  @Override
  public Set<String> getNames() {
    return names;
  }

  /**
   * @return value of {@code options} attribute
   */
  @Override
  public Map<String, String> getOptions() {
    return options;
  }

  /**
   * @return value of {@code mod} attribute, may be {@code null}
   */
  @Override
  public @Nullable BeanFriendly.Mod getMod() {
    return mod;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code defaultMod} attribute
   */
  @Override
  public BeanFriendly.Mod getDefaultMod() {
    if (defaultModIsSet()) {
      return defaultMod;
    } else {
      BeanFriendly.Mod defaultMod = BeanFriendly.super.getDefaultMod();
      return defaultMod instanceof ModifiableMod
          ? (ModifiableMod) defaultMod
          : new ModifiableMod().from(defaultMod);
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code defaultNullableMod} attribute
   */
  @Override
  public @Nullable BeanFriendly.Mod getDefaultNullableMod() {
    if (defaultNullableModIsSet()) {
      return defaultNullableMod;
    } else {
      BeanFriendly.Mod defaultNullableMod = BeanFriendly.super.getDefaultNullableMod();
      return defaultNullableMod instanceof ModifiableMod
          ? (ModifiableMod) defaultNullableMod
          : new ModifiableMod().from(defaultNullableMod);
    }
  }

  /**
   * @return newly computed, not cached value of {@code derivedMod} attribute
   */
  @Override
  public BeanFriendly.Mod getDerivedMod() {
    BeanFriendly.Mod derivedMod = BeanFriendly.super.getDerivedMod();
    return derivedMod instanceof ModifiableMod
        ? (ModifiableMod) derivedMod
        : new ModifiableMod().from(derivedMod);
  }

  /**
   * @return newly computed, not cached value of {@code derivedNullableMod} attribute
   */
  @Override
  public @Nullable BeanFriendly.Mod getDerivedNullableMod() {
    BeanFriendly.Mod derivedNullableMod = BeanFriendly.super.getDerivedNullableMod();
    return derivedNullableMod instanceof ModifiableMod
        ? (ModifiableMod) derivedNullableMod
        : new ModifiableMod().from(derivedNullableMod);
  }

  /**
   * @return modifiable list {@code extra}
   */
  @Override
  public @Nullable List<Integer> getExtra() {
    return extra;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   */
  public void clear() {
    initBits = 0x7L;
    optBits = 0;
    primary = false;
    id = 0;
    description = null;
    names.clear();
    options.clear();
    mod = null;
    defaultMod = null;
    defaultNullableMod = null;
    extra = null;
    return;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.modifiable.Identifiable} instance.
   * @param instance The instance from which to copy values
   */
  public ModifiableBeanFriendly from(Identifiable instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.modifiable.BeanFriendly} instance.
   * @param instance The instance from which to copy values
   */
  public ModifiableBeanFriendly from(BeanFriendly instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link BeanFriendly} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableBeanFriendly from(ModifiableBeanFriendly instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof ModifiableBeanFriendly) {
      ModifiableBeanFriendly instance = (ModifiableBeanFriendly) object;
      if (instance.primaryIsSet()) {
        setPrimary(instance.isPrimary());
      }
      if (instance.idIsSet()) {
        setId(instance.getId());
      }
      if (instance.descriptionIsSet()) {
        setDescription(instance.getDescription());
      }
      addAllNames(instance.getNames());
      putAllOptions(instance.getOptions());
      @Nullable BeanFriendly.Mod modValue = instance.getMod();
      if (modValue != null) {
        setMod(modValue);
      }
      setDefaultMod(instance.getDefaultMod());
      @Nullable BeanFriendly.Mod defaultNullableModValue = instance.getDefaultNullableMod();
      if (defaultNullableModValue != null) {
        setDefaultNullableMod(defaultNullableModValue);
      }
      addAllExtra(instance.getExtra());
      return;
    }
    long bits = 0;
    if (object instanceof Identifiable) {
      Identifiable instance = (Identifiable) object;
      if ((bits & 0x1L) == 0) {
        setId(instance.getId());
        bits |= 0x1L;
      }
    }
    if (object instanceof BeanFriendly) {
      BeanFriendly instance = (BeanFriendly) object;
      setDefaultMod(instance.getDefaultMod());
      addAllNames(instance.getNames());
      @Nullable BeanFriendly.Mod modValue = instance.getMod();
      if (modValue != null) {
        setMod(modValue);
      }
      addAllExtra(instance.getExtra());
      putAllOptions(instance.getOptions());
      setDescription(instance.getDescription());
      @Nullable BeanFriendly.Mod defaultNullableModValue = instance.getDefaultNullableMod();
      if (defaultNullableModValue != null) {
        setDefaultNullableMod(defaultNullableModValue);
      }
      if ((bits & 0x1L) == 0) {
        setId(instance.getId());
        bits |= 0x1L;
      }
      setPrimary(instance.isPrimary());
    }
  }

  /**
   * Assigns a value to the {@link BeanFriendly#isPrimary() primary} attribute.
   * @param primary The value for primary
   */
  public void setPrimary(boolean primary) {
    this.primary = primary;
    initBits &= ~INIT_BIT_PRIMARY;
    return;
  }

  /**
   * Assigns a value to the {@link BeanFriendly#getId() id} attribute.
   * @param id The value for id
   */
  public void setId(int id) {
    this.id = id;
    initBits &= ~INIT_BIT_ID;
    return;
  }

  /**
   * Assigns a value to the {@link BeanFriendly#getDescription() description} attribute.
   * @param description The value for description
   */
  public void setDescription(String description) {
    this.description = Objects.requireNonNull(description, "description");
    initBits &= ~INIT_BIT_DESCRIPTION;
    return;
  }

  /**
   * Adds one element to {@link BeanFriendly#getNames() names} set.
   * @param element The names element
   */
  public void addNames(String element) {
    Objects.requireNonNull(element, "names element");
    this.names.add(element);
    return;
  }

  /**
   * Adds elements to {@link BeanFriendly#getNames() names} set.
   * @param elements An array of names elements
   */
  public final void addNames(String... elements) {
    for (String e : elements) {
      addNames(e);
    }
    return;
  }

  /**
   * Sets or replaces all elements for {@link BeanFriendly#getNames() names} set.
   * @param elements An iterable of names elements
   */
  public void setNames(Set<String> elements) {
    this.names = Objects.requireNonNull(elements, "elements");
    return;
  }

  /**
   * Adds elements to {@link BeanFriendly#getNames() names} set.
   * @param elements An iterable of names elements
   */
  public void addAllNames(Iterable<String> elements) {
    for (String e : elements) {
      addNames(e);
    }
    return;
  }

  /**
   * Put one entry to the {@link BeanFriendly#getOptions() options} map.
   * @param key The key in options map
   * @param value The associated value in the options map
   */
  public void putOptions(String key, String value) {
    this.options.put(
        Objects.requireNonNull(key, "options key"),
        Objects.requireNonNull(value, "options value"));
    return;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link BeanFriendly#getOptions() options} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the options map
   */
  public void setOptions(Map<String, String> entries) {
    this.options.clear();
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.options.put(
          Objects.requireNonNull(k, "options key"),
          Objects.requireNonNull(v, "options value"));
    }
    return;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link BeanFriendly#getOptions() options} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to options map
   */
  public void putAllOptions(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.options.put(
          Objects.requireNonNull(k, "options key"),
          Objects.requireNonNull(v, "options value"));
    }
    return;
  }

  /**
   * Assigns a value to the {@link BeanFriendly#getMod() mod} attribute.
   * @param mod The value for mod, can be {@code null}
   */
  public void setMod(@Nullable BeanFriendly.Mod mod) {
    this.mod = mod == null ? null : (mod instanceof ModifiableMod ? (ModifiableMod) mod : new ModifiableMod().from(mod));
    return;
  }

  /**
   * Assigns a value to the {@link BeanFriendly#getDefaultMod() defaultMod} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link BeanFriendly#getDefaultMod() defaultMod}.</em>
   * @param defaultMod The value for defaultMod
   */
  public void setDefaultMod(BeanFriendly.Mod defaultMod) {
    this.defaultMod = (defaultMod instanceof ModifiableMod ? (ModifiableMod) defaultMod : new ModifiableMod().from(defaultMod));
    return;
  }

  /**
   * Assigns a value to the {@link BeanFriendly#getDefaultNullableMod() defaultNullableMod} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link BeanFriendly#getDefaultNullableMod() defaultNullableMod}.</em>
   * @param defaultNullableMod The value for defaultNullableMod, can be {@code null}
   */
  public void setDefaultNullableMod(@Nullable BeanFriendly.Mod defaultNullableMod) {
    this.defaultNullableMod = defaultNullableMod == null ? null : (defaultNullableMod instanceof ModifiableMod ? (ModifiableMod) defaultNullableMod : new ModifiableMod().from(defaultNullableMod));
    optBits |= OPT_BIT_DEFAULT_NULLABLE_MOD;
    return;
  }

  /**
   * Adds one element to {@link BeanFriendly#getExtra() extra} list.
   * @param element The extra element
   */
  public void addExtra(int element) {
    if (this.extra == null) {
      this.extra = new ArrayList<Integer>();
    }
    this.extra.add(element);
    return;
  }

  /**
   * Adds elements to {@link BeanFriendly#getExtra() extra} list.
   * @param elements An array of extra elements
   */
  public final void addExtra(int... elements) {
    for (int e : elements) {
      addExtra(Objects.requireNonNull(e, "extra element"));
    }
    return;
  }

  /**
   * Sets or replaces all elements for {@link BeanFriendly#getExtra() extra} list.
   * @param elements An iterable of extra elements, can be {@code null}
   */
  public void setExtra(@Nullable List<Integer> elements) {
    this.extra = elements;
    return;
  }

  /**
   * Adds elements to {@link BeanFriendly#getExtra() extra} list.
   * @param elements An iterable of extra elements
   */
  public void addAllExtra(Iterable<Integer> elements) {
    if (elements == null) return;
    if (this.extra == null) {
      this.extra = new ArrayList<Integer>();
    }
    for (int e : elements) {
      addExtra(e);
    }
    return;
  }

  /**
   * Returns {@code true} if the required attribute {@link BeanFriendly#isPrimary() primary} is set.
   * @return {@code true} if set
   */
  public final boolean primaryIsSet() {
    return (initBits & INIT_BIT_PRIMARY) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link BeanFriendly#getId() id} is set.
   * @return {@code true} if set
   */
  public final boolean idIsSet() {
    return (initBits & INIT_BIT_ID) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link BeanFriendly#getDescription() description} is set.
   * @return {@code true} if set
   */
  public final boolean descriptionIsSet() {
    return (initBits & INIT_BIT_DESCRIPTION) == 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link BeanFriendly#getDefaultNullableMod() defaultNullableMod} is set.
   * @return {@code true} if set
   */
  public final boolean defaultNullableModIsSet() {
    return (optBits & OPT_BIT_DEFAULT_NULLABLE_MOD) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link BeanFriendly#getDefaultMod() defaultMod} is set.
   * @return {@code true} if set
   */
  public final boolean defaultModIsSet() {
    return defaultMod != null;
  }


  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetPrimary() {
    initBits |= INIT_BIT_PRIMARY;
    primary = false;
    return;
  }

  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetId() {
    initBits |= INIT_BIT_ID;
    id = 0;
    return;
  }

  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetDescription() {
    initBits |= INIT_BIT_DESCRIPTION;
    description = null;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetDefaultNullableMod() {
    optBits |= 0;
    defaultNullableMod = null;
    return;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!primaryIsSet()) attributes.add("primary");
    if (!idIsSet()) attributes.add("id");
    if (!descriptionIsSet()) attributes.add("description");
    return "BeanFriendly is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableBeanFriendly ImmutableBeanFriendly}.
   * @return An immutable instance of BeanFriendly
   */
  public final ImmutableBeanFriendly toImmutable() {
    checkRequiredAttributes();
    return ImmutableBeanFriendly.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableBeanFriendly} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableBeanFriendly)) return false;
    ModifiableBeanFriendly other = (ModifiableBeanFriendly) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableBeanFriendly another) {
    BeanFriendly.Mod defaultMod = getDefaultMod();
    BeanFriendly.Mod defaultNullableMod = getDefaultNullableMod();
    BeanFriendly.Mod derivedMod = getDerivedMod();
    BeanFriendly.Mod derivedNullableMod = getDerivedNullableMod();
    return primary == another.primary
        && id == another.id
        && description.equals(another.description)
        && names.equals(another.names)
        && options.equals(another.options)
        && Objects.equals(mod, another.mod)
        && defaultMod.equals(another.getDefaultMod())
        && Objects.equals(defaultNullableMod, another.getDefaultNullableMod())
        && derivedMod.equals(another.getDerivedMod())
        && Objects.equals(derivedNullableMod, another.getDerivedNullableMod())
        && Objects.equals(extra, another.extra);
  }

  /**
   * Computes a hash code from attributes: {@code primary}, {@code id}, {@code description}, {@code names}, {@code options}, {@code mod}, {@code defaultMod}, {@code defaultNullableMod}, {@code derivedMod}, {@code derivedNullableMod}, {@code extra}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Booleans.hashCode(primary);
    h += (h << 5) + id;
    h += (h << 5) + description.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + options.hashCode();
    h += (h << 5) + Objects.hashCode(mod);
    BeanFriendly.Mod defaultMod = getDefaultMod();
    h += (h << 5) + defaultMod.hashCode();
    BeanFriendly.Mod defaultNullableMod = getDefaultNullableMod();
    h += (h << 5) + Objects.hashCode(defaultNullableMod);
    BeanFriendly.Mod derivedMod = getDerivedMod();
    h += (h << 5) + derivedMod.hashCode();
    BeanFriendly.Mod derivedNullableMod = getDerivedNullableMod();
    h += (h << 5) + Objects.hashCode(derivedNullableMod);
    h += (h << 5) + Objects.hashCode(extra);
    return h;
  }

  /**
   * Generates a string representation of this {@code BeanFriendly}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableBeanFriendly")
        .add("primary", primaryIsSet() ? isPrimary() : "?")
        .add("id", idIsSet() ? getId() : "?")
        .add("description", descriptionIsSet() ? getDescription() : "?")
        .add("names", getNames())
        .add("options", getOptions())
        .add("mod", getMod())
        .add("defaultMod", getDefaultMod())
        .add("defaultNullableMod", getDefaultNullableMod())
        .add("extra", getExtra())
        .toString();
  }
}
