package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link HavingEqualsHashCode HavingEqualsHashCode} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableHavingEqualsHashCode is not thread-safe</em>
 * @see ImmutableHavingEqualsHashCode
 */
@Generated(from = "HavingEqualsHashCode", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "HavingEqualsHashCode"})
@NotThreadSafe
public final class ModifiableHavingEqualsHashCode
    extends HavingEqualsHashCode {

  private ModifiableHavingEqualsHashCode() {}

  /**
   * Construct a modifiable instance of {@code HavingEqualsHashCode}.
   * @return A new modifiable instance
   */
  public static ModifiableHavingEqualsHashCode create() {
    return new ModifiableHavingEqualsHashCode();
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableHavingEqualsHashCode clear() {
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link HavingEqualsHashCode} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableHavingEqualsHashCode from(HavingEqualsHashCode instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableHavingEqualsHashCode) {
      from((ModifiableHavingEqualsHashCode) instance);
      return this;
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link HavingEqualsHashCode} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableHavingEqualsHashCode from(ModifiableHavingEqualsHashCode instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableHavingEqualsHashCode ImmutableHavingEqualsHashCode}.
   * @return An immutable instance of HavingEqualsHashCode
   */
  public final ImmutableHavingEqualsHashCode toImmutable() {
    return ImmutableHavingEqualsHashCode.copyOf(this);
  }

  /**
   * Generates a string representation of this {@code HavingEqualsHashCode}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableHavingEqualsHashCode{}";
  }
}
