package org.immutables.fixture.modifiable;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link BeanFriendly.Mod Mod} type.
 * <p>Use the constructor to create new modifiable instances. You may even extend this class to
 * add some convenience methods, however most of the methods in this class are final
 * to preserve safety and predictable invariants.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableMod is not thread-safe</em>
 * @see ImmutableMod
 */
@Generated(from = "BeanFriendly.Mod", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "BeanFriendly.Mod"})
@NotThreadSafe
public class ModifiableMod implements BeanFriendly.Mod {

  /**
   * Clears the object by setting all attributes to their initial values.
   */
  public void clear() {
    return;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link BeanFriendly.Mod} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableMod from(BeanFriendly.Mod instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableMod) {
      from((ModifiableMod) instance);
      return this;
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link BeanFriendly.Mod} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableMod from(ModifiableMod instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableMod ImmutableMod}.
   * @return An immutable instance of Mod
   */
  public final ImmutableMod toImmutable() {
    return ImmutableMod.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableMod} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableMod)) return false;
    ModifiableMod other = (ModifiableMod) another;
    return equalTo(other);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ModifiableMod another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1252040576;
  }

  /**
   * Generates a string representation of this {@code Mod}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableMod{}";
  }
}
