package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link ModStricBuilderAndDefault ModStricBuilderAndDefault} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableModStricBuilderAndDefault is not thread-safe</em>
 * @see ImmutableModStricBuilderAndDefault
 */
@Generated(from = "ModStricBuilderAndDefault", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "ModStricBuilderAndDefault"})
@NotThreadSafe
public final class ModifiableModStricBuilderAndDefault
    extends ModStricBuilderAndDefault {
  private static final long INIT_BIT_A = 0x1L;
  private static final long OPT_BIT_B = 0x1L;
  private static final long OPT_BIT_C = 0x2L;
  private long initBits = 0x1L;
  private long optBits;

  private String a;
  private String b;
  private @Nullable Integer c;

  private ModifiableModStricBuilderAndDefault() {}

  /**
   * Construct a modifiable instance of {@code ModStricBuilderAndDefault}.
   * @return A new modifiable instance
   */
  public static ModifiableModStricBuilderAndDefault create() {
    return new ModifiableModStricBuilderAndDefault();
  }

  /**
   * @return value of {@code a} attribute
   */
  @Override
  public final String a() {
    if (!aIsSet()) {
      checkRequiredAttributes();
    }
    return a;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code b} attribute
   */
  @Override
  public final String b() {
    if (bIsSet()) {
      return b;
    } else {
      return super.b();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code c} attribute
   */
  @Override
  public final @Nullable Integer c() {
    if (cIsSet()) {
      return c;
    } else {
      return super.c();
    }
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableModStricBuilderAndDefault clear() {
    initBits = 0x1L;
    optBits = 0;
    a = null;
    b = null;
    c = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ModStricBuilderAndDefault} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableModStricBuilderAndDefault from(ModStricBuilderAndDefault instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableModStricBuilderAndDefault) {
      from((ModifiableModStricBuilderAndDefault) instance);
      return this;
    }
    setA(instance.a());
    setB(instance.b());
    @Nullable Integer cValue = instance.c();
    if (cValue != null) {
      setC(cValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ModStricBuilderAndDefault} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableModStricBuilderAndDefault from(ModifiableModStricBuilderAndDefault instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.aIsSet()) {
      setA(instance.a());
    }
    setB(instance.b());
    @Nullable Integer cValue = instance.c();
    if (cValue != null) {
      setC(cValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link ModStricBuilderAndDefault#a() a} attribute.
   * @param a The value for a
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableModStricBuilderAndDefault setA(String a) {
    this.a = Objects.requireNonNull(a, "a");
    initBits &= ~INIT_BIT_A;
    return this;
  }

  /**
   * Assigns a value to the {@link ModStricBuilderAndDefault#b() b} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link ModStricBuilderAndDefault#b() b}.</em>
   * @param b The value for b
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableModStricBuilderAndDefault setB(String b) {
    this.b = Objects.requireNonNull(b, "b");
    optBits |= OPT_BIT_B;
    return this;
  }

  /**
   * Assigns a value to the {@link ModStricBuilderAndDefault#c() c} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link ModStricBuilderAndDefault#c() c}.</em>
   * @param c The value for c, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableModStricBuilderAndDefault setC(@Nullable Integer c) {
    this.c = c;
    optBits |= OPT_BIT_C;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link ModStricBuilderAndDefault#a() a} is set.
   * @return {@code true} if set
   */
  public final boolean aIsSet() {
    return (initBits & INIT_BIT_A) == 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link ModStricBuilderAndDefault#b() b} is set.
   * @return {@code true} if set
   */
  public final boolean bIsSet() {
    return (optBits & OPT_BIT_B) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link ModStricBuilderAndDefault#c() c} is set.
   * @return {@code true} if set
   */
  public final boolean cIsSet() {
    return (optBits & OPT_BIT_C) != 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableModStricBuilderAndDefault unsetA() {
    initBits |= INIT_BIT_A;
    a = null;
    return this;
  }
  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableModStricBuilderAndDefault unsetB() {
    optBits |= 0;
    b = null;
    return this;
  }
  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableModStricBuilderAndDefault unsetC() {
    optBits |= 0;
    c = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!aIsSet()) attributes.add("a");
    return "ModStricBuilderAndDefault is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableModStricBuilderAndDefault ImmutableModStricBuilderAndDefault}.
   * @return An immutable instance of ModStricBuilderAndDefault
   */
  public final ImmutableModStricBuilderAndDefault toImmutable() {
    checkRequiredAttributes();
    return ImmutableModStricBuilderAndDefault.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableModStricBuilderAndDefault} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableModStricBuilderAndDefault)) return false;
    ModifiableModStricBuilderAndDefault other = (ModifiableModStricBuilderAndDefault) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableModStricBuilderAndDefault another) {
    String b = b();
    Integer c = c();
    return a.equals(another.a)
        && b.equals(another.b())
        && Objects.equals(c, another.c());
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + a.hashCode();
    String b = b();
    h += (h << 5) + b.hashCode();
    Integer c = c();
    h += (h << 5) + Objects.hashCode(c);
    return h;
  }

  /**
   * Generates a string representation of this {@code ModStricBuilderAndDefault}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableModStricBuilderAndDefault")
        .add("a", aIsSet() ? a() : "?")
        .add("b", b())
        .add("c", c())
        .toString();
  }
}
