package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link NullableList NullableList} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableNullableList is not thread-safe</em>
 * @see ImmutableNullableList
 */
@Generated(from = "NullableList", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "NullableList"})
@NotThreadSafe
public final class ModifiableNullableList implements NullableList {
  private @Nullable Object object;
  private @Nullable ArrayList<Object> objects = null;

  private ModifiableNullableList() {}

  /**
   * Construct a modifiable instance of {@code NullableList}.
   * @return A new modifiable instance
   */
  public static ModifiableNullableList create() {
    return new ModifiableNullableList();
  }

  /**
   * @return value of {@code object} attribute, may be {@code null}
   */
  @Override
  public final @Nullable Object getObject() {
    return object;
  }

  /**
   * @return modifiable list {@code objects}
   */
  @Override
  public final @Nullable List<Object> getObjects() {
    return objects;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableList clear() {
    object = null;
    objects = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link NullableList} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableNullableList from(NullableList instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableNullableList) {
      from((ModifiableNullableList) instance);
      return this;
    }
    @Nullable Object objectValue = instance.getObject();
    if (objectValue != null) {
      setObject(objectValue);
    }
    addAllObjects(instance.getObjects());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link NullableList} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableNullableList from(ModifiableNullableList instance) {
    Objects.requireNonNull(instance, "instance");
    @Nullable Object objectValue = instance.getObject();
    if (objectValue != null) {
      setObject(objectValue);
    }
    addAllObjects(instance.getObjects());
    return this;
  }

  /**
   * Assigns a value to the {@link NullableList#getObject() object} attribute.
   * @param object The value for object, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableList setObject(@Nullable Object object) {
    this.object = object;
    return this;
  }

  /**
   * Adds one element to {@link NullableList#getObjects() objects} list.
   * @param element The objects element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableList addObjects(Object element) {
    if (this.objects == null) {
      this.objects = new ArrayList<Object>();
    }
    Objects.requireNonNull(element, "objects element");
    this.objects.add(element);
    return this;
  }

  /**
   * Adds elements to {@link NullableList#getObjects() objects} list.
   * @param elements An array of objects elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableList addObjects(Object... elements) {
    for (Object e : elements) {
      addObjects(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link NullableList#getObjects() objects} list.
   * @param elements An iterable of objects elements, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableList setObjects(@Nullable Iterable<? extends Object> elements) {
    if (elements == null) {
      this.objects = null;
      return this;
    }
    if (this.objects == null) {
      this.objects = new ArrayList<Object>();
    } else {
      this.objects.clear();
    }
    addAllObjects(elements);
    return this;
  }

  /**
   * Adds elements to {@link NullableList#getObjects() objects} list.
   * @param elements An iterable of objects elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableList addAllObjects(Iterable<? extends Object> elements) {
    if (elements == null) return this;
    if (this.objects == null) {
      this.objects = new ArrayList<Object>();
    }
    for (Object e : elements) {
      addObjects(e);
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableNullableList ImmutableNullableList}.
   * @return An immutable instance of NullableList
   */
  public final ImmutableNullableList toImmutable() {
    return ImmutableNullableList.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableNullableList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableNullableList)) return false;
    ModifiableNullableList other = (ModifiableNullableList) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableNullableList another) {
    return Objects.equals(object, another.object)
        && Objects.equals(objects, another.objects);
  }

  /**
   * Computes a hash code from attributes: {@code object}, {@code objects}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(object);
    h += (h << 5) + Objects.hashCode(objects);
    return h;
  }

  /**
   * Generates a string representation of this {@code NullableList}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableNullableList")
        .add("object", getObject())
        .add("objects", getObjects())
        .toString();
  }
}
