package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Shorts;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Companion.Standalone Standalone} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableStandalone is not thread-safe</em>
 */
@Generated(from = "Companion.Standalone", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Companion.Standalone"})
@NotThreadSafe
public final class ModifiableStandalone implements Companion.Standalone {
  private static final long INIT_BIT_FIRST = 0x1L;
  private static final long INIT_BIT_SECOND = 0x2L;
  private static final long INIT_BIT_SH = 0x4L;
  private static final long INIT_BIT_CH = 0x8L;
  private static final long INIT_BIT_BOOL = 0x10L;
  private static final long INIT_BIT_DOB = 0x20L;
  private static final long INIT_BIT_FL = 0x40L;
  private static final long OPT_BIT_DEF = 0x1L;
  private long initBits = 0x7fL;
  private long optBits;

  private int first;
  private String second;
  private short sh;
  private char ch;
  private boolean bool;
  private double dob;
  private float fl;
  private Optional<Integer> v1 = Optional.absent();
  private java.util.Optional<Integer> v2 = java.util.Optional.empty();
  private OptionalInt i1 = OptionalInt.empty();
  private OptionalLong l1 = OptionalLong.empty();
  private OptionalDouble d1 = OptionalDouble.empty();
  private Option<Integer> fugue3 = Option.none();
  private int def;
  private String defs;
  private @Nullable ArrayList<Unit> nullableUnit = null;

  private ModifiableStandalone() {}

  /**
   * Construct a modifiable instance of {@code Standalone}.
   * @param first The value for the {@code first} attribute 
   * @param second The value for the {@code second} attribute 
   * @param sh The value for the {@code sh} attribute 
   * @param ch The value for the {@code ch} attribute 
   * @param bool The value for the {@code bool} attribute 
   * @param dob The value for the {@code dob} attribute 
   * @param fl The value for the {@code fl} attribute 
   * @return A new modifiable instance
   */
  public static ModifiableStandalone create(int first, String second, short sh, char ch, boolean bool, double dob, float fl) {
    return new ModifiableStandalone()
        .setFirst(first)
        .setSecond(second)
        .setSh(sh)
        .setCh(ch)
        .setBool(bool)
        .setDob(dob)
        .setFl(fl);
  }

  /**
   * Construct a modifiable instance of {@code Standalone}.
   * @return A new modifiable instance
   */
  public static ModifiableStandalone create() {
    return new ModifiableStandalone();
  }

  /**
   * @return value of {@code first} attribute
   */
  @Override
  public final int first() {
    if (!firstIsSet()) {
      checkRequiredAttributes();
    }
    return first;
  }

  /**
   * @return value of {@code second} attribute
   */
  @Override
  public final String second() {
    if (!secondIsSet()) {
      checkRequiredAttributes();
    }
    return second;
  }

  /**
   * @return value of {@code sh} attribute
   */
  @Override
  public final short sh() {
    if (!shIsSet()) {
      checkRequiredAttributes();
    }
    return sh;
  }

  /**
   * @return value of {@code ch} attribute
   */
  @Override
  public final char ch() {
    if (!chIsSet()) {
      checkRequiredAttributes();
    }
    return ch;
  }

  /**
   * @return value of {@code bool} attribute
   */
  @Override
  public final boolean bool() {
    if (!boolIsSet()) {
      checkRequiredAttributes();
    }
    return bool;
  }

  /**
   * @return value of {@code dob} attribute
   */
  @Override
  public final double dob() {
    if (!dobIsSet()) {
      checkRequiredAttributes();
    }
    return dob;
  }

  /**
   * @return value of {@code fl} attribute
   */
  @Override
  public final float fl() {
    if (!flIsSet()) {
      checkRequiredAttributes();
    }
    return fl;
  }

  /**
   * @return value of {@code v1} attribute
   */
  @Override
  public final Optional<Integer> v1() {
    return v1;
  }

  /**
   * @return value of {@code v2} attribute
   */
  @Override
  public final java.util.Optional<Integer> v2() {
    return v2;
  }

  /**
   * @return value of {@code i1} attribute
   */
  @Override
  public final OptionalInt i1() {
    return i1;
  }

  /**
   * @return value of {@code l1} attribute
   */
  @Override
  public final OptionalLong l1() {
    return l1;
  }

  /**
   * @return value of {@code d1} attribute
   */
  @Override
  public final OptionalDouble d1() {
    return d1;
  }

  /**
   * @return value of {@code fugue3} attribute
   */
  @Override
  public final Option<Integer> fugue3() {
    return fugue3;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code def} attribute
   */
  @Override
  public final int def() {
    if (defIsSet()) {
      return def;
    } else {
      return Companion.Standalone.super.def();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code defs} attribute
   */
  @Override
  public final String defs() {
    if (defsIsSet()) {
      return defs;
    } else {
      return Companion.Standalone.super.defs();
    }
  }

  /**
   * @return newly computed, not cached value of {@code derived} attribute
   */
  @Override
  public final int derived() {
    return Companion.Standalone.super.derived();
  }

  /**
   * @return modifiable list {@code nullableUnit}
   */
  @Override
  public final @Nullable List<Unit> nullableUnit() {
    return nullableUnit;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone clear() {
    initBits = 0x7fL;
    optBits = 0;
    first = 0;
    second = null;
    sh = 0;
    ch = 0;
    bool = false;
    dob = 0;
    fl = 0;
    v1 = Optional.absent();
    v2 = java.util.Optional.empty();
    i1 = OptionalInt.empty();
    l1 = OptionalLong.empty();
    d1 = OptionalDouble.empty();
    fugue3 = Option.none();
    def = 0;
    defs = null;
    nullableUnit = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion.Standalone} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableStandalone from(Companion.Standalone instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableStandalone) {
      from((ModifiableStandalone) instance);
      return this;
    }
    setFirst(instance.first());
    setSecond(instance.second());
    setSh(instance.sh());
    setCh(instance.ch());
    setBool(instance.bool());
    setDob(instance.dob());
    setFl(instance.fl());
    Optional<Integer> v1Optional = instance.v1();
    if (v1Optional.isPresent()) {
      setV1(v1Optional);
    }
    java.util.Optional<Integer> v2Optional = instance.v2();
    if (v2Optional.isPresent()) {
      setV2(v2Optional);
    }
    OptionalInt i1Optional = instance.i1();
    if (i1Optional.isPresent()) {
      setI1(i1Optional);
    }
    OptionalLong l1Optional = instance.l1();
    if (l1Optional.isPresent()) {
      setL1(l1Optional);
    }
    OptionalDouble d1Optional = instance.d1();
    if (d1Optional.isPresent()) {
      setD1(d1Optional);
    }
    Option<Integer> fugue3Optional = instance.fugue3();
    if (fugue3Optional.isDefined()) {
      setFugue3(fugue3Optional);
    }
    setDef(instance.def());
    setDefs(instance.defs());
    addAllNullableUnit(instance.nullableUnit());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion.Standalone} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableStandalone from(ModifiableStandalone instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.firstIsSet()) {
      setFirst(instance.first());
    }
    if (instance.secondIsSet()) {
      setSecond(instance.second());
    }
    if (instance.shIsSet()) {
      setSh(instance.sh());
    }
    if (instance.chIsSet()) {
      setCh(instance.ch());
    }
    if (instance.boolIsSet()) {
      setBool(instance.bool());
    }
    if (instance.dobIsSet()) {
      setDob(instance.dob());
    }
    if (instance.flIsSet()) {
      setFl(instance.fl());
    }
    Optional<Integer> v1Optional = instance.v1();
    if (v1Optional.isPresent()) {
      setV1(v1Optional);
    }
    java.util.Optional<Integer> v2Optional = instance.v2();
    if (v2Optional.isPresent()) {
      setV2(v2Optional);
    }
    OptionalInt i1Optional = instance.i1();
    if (i1Optional.isPresent()) {
      setI1(i1Optional);
    }
    OptionalLong l1Optional = instance.l1();
    if (l1Optional.isPresent()) {
      setL1(l1Optional);
    }
    OptionalDouble d1Optional = instance.d1();
    if (d1Optional.isPresent()) {
      setD1(d1Optional);
    }
    Option<Integer> fugue3Optional = instance.fugue3();
    if (fugue3Optional.isDefined()) {
      setFugue3(fugue3Optional);
    }
    setDef(instance.def());
    setDefs(instance.defs());
    addAllNullableUnit(instance.nullableUnit());
    return this;
  }

  /**
   * Assigns a value to the {@code first} attribute.
   * @param first The value for first
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setFirst(int first) {
    this.first = first;
    initBits &= ~INIT_BIT_FIRST;
    return this;
  }

  /**
   * Assigns a value to the {@code second} attribute.
   * @param second The value for second
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setSecond(String second) {
    this.second = Objects.requireNonNull(second, "second");
    initBits &= ~INIT_BIT_SECOND;
    return this;
  }

  /**
   * Assigns a value to the {@code sh} attribute.
   * @param sh The value for sh
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setSh(short sh) {
    this.sh = sh;
    initBits &= ~INIT_BIT_SH;
    return this;
  }

  /**
   * Assigns a value to the {@code ch} attribute.
   * @param ch The value for ch
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setCh(char ch) {
    this.ch = ch;
    initBits &= ~INIT_BIT_CH;
    return this;
  }

  /**
   * Assigns a value to the {@code bool} attribute.
   * @param bool The value for bool
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setBool(boolean bool) {
    this.bool = bool;
    initBits &= ~INIT_BIT_BOOL;
    return this;
  }

  /**
   * Assigns a value to the {@code dob} attribute.
   * @param dob The value for dob
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setDob(double dob) {
    this.dob = dob;
    initBits &= ~INIT_BIT_DOB;
    return this;
  }

  /**
   * Assigns a value to the {@code fl} attribute.
   * @param fl The value for fl
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setFl(float fl) {
    this.fl = fl;
    initBits &= ~INIT_BIT_FL;
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@code v1} attribute.
   * @param v1 A value for v1
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setV1(int v1) {
    this.v1 = Optional.of(v1);
    return this;
  }

  /**
   * Assigns an optional value for {@code v1}.
   * @param v1 A value for v1
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setV1(Optional<Integer> v1) {
    this.v1 = Objects.requireNonNull(v1, "v1");
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@code v2} attribute.
   * @param v2 A value for v2
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setV2(int v2) {
    this.v2 = java.util.Optional.of(v2);
    return this;
  }

  /**
   * Assigns an optional value for {@code v2}.
   * @param v2 A value for v2
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setV2(java.util.Optional<Integer> v2) {
    this.v2 = Objects.requireNonNull(v2, "v2");
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@code i1} attribute.
   * @param i1 A value for i1
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setI1(int i1) {
    this.i1 = OptionalInt.of(i1);
    return this;
  }

  /**
   * Assigns an optional value for {@code i1}.
   * @param i1 A value for i1
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setI1(OptionalInt i1) {
    this.i1 = Objects.requireNonNull(i1, "i1");
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@code l1} attribute.
   * @param l1 A value for l1
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setL1(long l1) {
    this.l1 = OptionalLong.of(l1);
    return this;
  }

  /**
   * Assigns an optional value for {@code l1}.
   * @param l1 A value for l1
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setL1(OptionalLong l1) {
    this.l1 = Objects.requireNonNull(l1, "l1");
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@code d1} attribute.
   * @param d1 A value for d1
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setD1(double d1) {
    this.d1 = OptionalDouble.of(d1);
    return this;
  }

  /**
   * Assigns an optional value for {@code d1}.
   * @param d1 A value for d1
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setD1(OptionalDouble d1) {
    this.d1 = Objects.requireNonNull(d1, "d1");
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@code fugue3} attribute.
   * @param fugue3 A value for fugue3
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setFugue3(int fugue3) {
    this.fugue3 = Option.some(fugue3);
    return this;
  }

  /**
   * Assigns an optional value for {@code fugue3}.
   * @param fugue3 A value for fugue3
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setFugue3(Option<Integer> fugue3) {
    this.fugue3 = Objects.requireNonNull(fugue3, "fugue3");
    return this;
  }

  /**
   * Assigns a value to the {@code def} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code def}.</em>
   * @param def The value for def
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setDef(int def) {
    this.def = def;
    optBits |= OPT_BIT_DEF;
    return this;
  }

  /**
   * Assigns a value to the {@code defs} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code defs}.</em>
   * @param defs The value for defs
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setDefs(String defs) {
    this.defs = Objects.requireNonNull(defs, "defs");
    return this;
  }

  /**
   * Adds one element to {@code nullableUnit} list.
   * @param element The nullableUnit element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone addNullableUnit(Unit element) {
    if (this.nullableUnit == null) {
      this.nullableUnit = new ArrayList<Unit>();
    }
    Objects.requireNonNull(element, "nullableUnit element");
    this.nullableUnit.add(element);
    return this;
  }

  /**
   * Adds elements to {@code nullableUnit} list.
   * @param elements An array of nullableUnit elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone addNullableUnit(Unit... elements) {
    for (Unit e : elements) {
      addNullableUnit(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@code nullableUnit} list.
   * @param elements An iterable of nullableUnit elements, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone setNullableUnit(@Nullable Iterable<? extends Unit> elements) {
    if (elements == null) {
      this.nullableUnit = null;
      return this;
    }
    if (this.nullableUnit == null) {
      this.nullableUnit = new ArrayList<Unit>();
    } else {
      this.nullableUnit.clear();
    }
    addAllNullableUnit(elements);
    return this;
  }

  /**
   * Adds elements to {@code nullableUnit} list.
   * @param elements An iterable of nullableUnit elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStandalone addAllNullableUnit(Iterable<? extends Unit> elements) {
    if (elements == null) return this;
    if (this.nullableUnit == null) {
      this.nullableUnit = new ArrayList<Unit>();
    }
    for (Unit e : elements) {
      addNullableUnit(e);
    }
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@code first} is set.
   * @return {@code true} if set
   */
  public final boolean firstIsSet() {
    return (initBits & INIT_BIT_FIRST) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@code second} is set.
   * @return {@code true} if set
   */
  public final boolean secondIsSet() {
    return (initBits & INIT_BIT_SECOND) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@code sh} is set.
   * @return {@code true} if set
   */
  public final boolean shIsSet() {
    return (initBits & INIT_BIT_SH) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@code ch} is set.
   * @return {@code true} if set
   */
  public final boolean chIsSet() {
    return (initBits & INIT_BIT_CH) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@code bool} is set.
   * @return {@code true} if set
   */
  public final boolean boolIsSet() {
    return (initBits & INIT_BIT_BOOL) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@code dob} is set.
   * @return {@code true} if set
   */
  public final boolean dobIsSet() {
    return (initBits & INIT_BIT_DOB) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@code fl} is set.
   * @return {@code true} if set
   */
  public final boolean flIsSet() {
    return (initBits & INIT_BIT_FL) == 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code def} is set.
   * @return {@code true} if set
   */
  public final boolean defIsSet() {
    return (optBits & OPT_BIT_DEF) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code defs} is set.
   * @return {@code true} if set
   */
  public final boolean defsIsSet() {
    return defs != null;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone unsetFirst() {
    initBits |= INIT_BIT_FIRST;
    first = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone unsetSecond() {
    initBits |= INIT_BIT_SECOND;
    second = null;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone unsetSh() {
    initBits |= INIT_BIT_SH;
    sh = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone unsetCh() {
    initBits |= INIT_BIT_CH;
    ch = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone unsetBool() {
    initBits |= INIT_BIT_BOOL;
    bool = false;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone unsetDob() {
    initBits |= INIT_BIT_DOB;
    dob = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone unsetFl() {
    initBits |= INIT_BIT_FL;
    fl = 0;
    return this;
  }
  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableStandalone unsetDef() {
    optBits |= 0;
    def = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!firstIsSet()) attributes.add("first");
    if (!secondIsSet()) attributes.add("second");
    if (!shIsSet()) attributes.add("sh");
    if (!chIsSet()) attributes.add("ch");
    if (!boolIsSet()) attributes.add("bool");
    if (!dobIsSet()) attributes.add("dob");
    if (!flIsSet()) attributes.add("fl");
    return "Standalone is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * This instance is equal to all instances of {@code ModifiableStandalone} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableStandalone)) return false;
    ModifiableStandalone other = (ModifiableStandalone) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableStandalone another) {
    int def = def();
    String defs = defs();
    int derived = derived();
    return first == another.first
        && second.equals(another.second)
        && sh == another.sh
        && ch == another.ch
        && bool == another.bool
        && Double.doubleToLongBits(dob) == Double.doubleToLongBits(another.dob)
        && Float.floatToIntBits(fl) == Float.floatToIntBits(another.fl)
        && v1.equals(another.v1)
        && Objects.equals(v2, another.v2)
        && Objects.equals(i1, another.i1)
        && Objects.equals(l1, another.l1)
        && Objects.equals(d1, another.d1)
        && fugue3.equals(another.fugue3)
        && def == another.def()
        && defs.equals(another.defs())
        && derived == another.derived()
        && Objects.equals(nullableUnit, another.nullableUnit);
  }

  /**
   * Computes a hash code from attributes: {@code first}, {@code second}, {@code sh}, {@code ch}, {@code bool}, {@code dob}, {@code fl}, {@code v1}, {@code v2}, {@code i1}, {@code l1}, {@code d1}, {@code fugue3}, {@code def}, {@code defs}, {@code derived}, {@code nullableUnit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + first;
    h += (h << 5) + second.hashCode();
    h += (h << 5) + Shorts.hashCode(sh);
    h += (h << 5) + Chars.hashCode(ch);
    h += (h << 5) + Booleans.hashCode(bool);
    h += (h << 5) + Doubles.hashCode(dob);
    h += (h << 5) + Floats.hashCode(fl);
    h += (h << 5) + v1.hashCode();
    h += (h << 5) + v2.hashCode();
    h += (h << 5) + i1.hashCode();
    h += (h << 5) + l1.hashCode();
    h += (h << 5) + d1.hashCode();
    h += (h << 5) + fugue3.hashCode();
    int def = def();
    h += (h << 5) + def;
    String defs = defs();
    h += (h << 5) + defs.hashCode();
    int derived = derived();
    h += (h << 5) + derived;
    h += (h << 5) + Objects.hashCode(nullableUnit);
    return h;
  }

  /**
   * Generates a string representation of this {@code Standalone}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableStandalone")
        .add("first", firstIsSet() ? first() : "?")
        .add("second", secondIsSet() ? second() : "?")
        .add("sh", shIsSet() ? sh() : "?")
        .add("ch", chIsSet() ? ch() : "?")
        .add("bool", boolIsSet() ? bool() : "?")
        .add("dob", dobIsSet() ? dob() : "?")
        .add("fl", flIsSet() ? fl() : "?")
        .add("v1", v1())
        .add("v2", v2())
        .add("i1", i1())
        .add("l1", l1())
        .add("d1", d1())
        .add("fugue3", fugue3())
        .add("def", def())
        .add("defs", defs())
        .add("nullableUnit", nullableUnit())
        .toString();
  }
}
