package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link WithModifiableSuperclass WithModifiableSuperclass} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableWithModifiableSuperclass is not thread-safe</em>
 */
@Generated(from = "WithModifiableSuperclass", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "WithModifiableSuperclass"})
@NotThreadSafe
final class ModifiableWithModifiableSuperclass extends WithModifiableSuperclass.Modifiable {
  private final ArrayList<Float> prices = new ArrayList<Float>();
  private final ArrayList<Float> pricesWithSalesTax = new ArrayList<Float>();

  private ModifiableWithModifiableSuperclass() {}

  /**
   * Construct a modifiable instance of {@code WithModifiableSuperclass}.
   * @return A new modifiable instance
   */
  public static ModifiableWithModifiableSuperclass create() {
    return new ModifiableWithModifiableSuperclass();
  }

  /**
   * @return modifiable list {@code prices}
   */
  @Override
  final List<Float> getPrices() {
    return prices;
  }

  /**
   * @return modifiable list {@code pricesWithSalesTax}
   */
  @Override
  final List<Float> getPricesWithSalesTax() {
    return pricesWithSalesTax;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableWithModifiableSuperclass clear() {
    prices.clear();
    pricesWithSalesTax.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link WithModifiableSuperclass} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableWithModifiableSuperclass from(WithModifiableSuperclass instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableWithModifiableSuperclass) {
      from((ModifiableWithModifiableSuperclass) instance);
      return this;
    }
    addAllPrices(instance.getPrices());
    addAllPricesWithSalesTax(instance.getPricesWithSalesTax());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link WithModifiableSuperclass} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableWithModifiableSuperclass from(ModifiableWithModifiableSuperclass instance) {
    Objects.requireNonNull(instance, "instance");
    addAllPrices(instance.getPrices());
    addAllPricesWithSalesTax(instance.getPricesWithSalesTax());
    return this;
  }

  /**
   * Adds one element to {@code prices} list.
   * @param element The prices element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableWithModifiableSuperclass addPrices(float element) {
    this.prices.add(element);
    return this;
  }

  /**
   * Adds elements to {@code prices} list.
   * @param elements An array of prices elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableWithModifiableSuperclass addPrices(float... elements) {
    for (float e : elements) {
      addPrices(Objects.requireNonNull(e, "prices element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@code prices} list.
   * @param elements An iterable of prices elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableWithModifiableSuperclass setPrices(Iterable<Float> elements) {
    this.prices.clear();
    addAllPrices(elements);
    return this;
  }

  /**
   * Adds elements to {@code prices} list.
   * @param elements An iterable of prices elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableWithModifiableSuperclass addAllPrices(Iterable<Float> elements) {
    for (float e : elements) {
      addPrices(e);
    }
    return this;
  }

  /**
   * Adds one element to {@code pricesWithSalesTax} list.
   * @param element The pricesWithSalesTax element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableWithModifiableSuperclass addPricesWithSalesTax(float element) {
    this.pricesWithSalesTax.add(element);
    return this;
  }

  /**
   * Adds elements to {@code pricesWithSalesTax} list.
   * @param elements An array of pricesWithSalesTax elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableWithModifiableSuperclass addPricesWithSalesTax(float... elements) {
    for (float e : elements) {
      addPricesWithSalesTax(Objects.requireNonNull(e, "pricesWithSalesTax element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@code pricesWithSalesTax} list.
   * @param elements An iterable of pricesWithSalesTax elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableWithModifiableSuperclass setPricesWithSalesTax(Iterable<Float> elements) {
    this.pricesWithSalesTax.clear();
    addAllPricesWithSalesTax(elements);
    return this;
  }

  /**
   * Adds elements to {@code pricesWithSalesTax} list.
   * @param elements An iterable of pricesWithSalesTax elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableWithModifiableSuperclass addAllPricesWithSalesTax(Iterable<Float> elements) {
    for (float e : elements) {
      addPricesWithSalesTax(e);
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * This instance is equal to all instances of {@code ModifiableWithModifiableSuperclass} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableWithModifiableSuperclass)) return false;
    ModifiableWithModifiableSuperclass other = (ModifiableWithModifiableSuperclass) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableWithModifiableSuperclass another) {
    return prices.equals(another.prices)
        && pricesWithSalesTax.equals(another.pricesWithSalesTax);
  }

  /**
   * Computes a hash code from attributes: {@code prices}, {@code pricesWithSalesTax}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + prices.hashCode();
    h += (h << 5) + pricesWithSalesTax.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code WithModifiableSuperclass}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableWithModifiableSuperclass")
        .add("prices", getPrices())
        .add("pricesWithSalesTax", getPricesWithSalesTax())
        .toString();
  }
}
