package org.immutables.fixture.modifiable.nested;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;
import org.immutables.fixture.modifiable.ModifiableCompanion;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link ReferenceDifferentPackage ReferenceDifferentPackage} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableReferenceDifferentPackage is not thread-safe</em>
 */
@Generated(from = "ReferenceDifferentPackage", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "ReferenceDifferentPackage"})
@NotThreadSafe
public final class ModifiableReferenceDifferentPackage
    implements ReferenceDifferentPackage {
  private static final long INIT_BIT_COMPANION = 0x1L;
  private long initBits = 0x1L;

  private ModifiableCompanion companion;

  private ModifiableReferenceDifferentPackage() {}

  /**
   * Construct a modifiable instance of {@code ReferenceDifferentPackage}.
   * @return A new modifiable instance
   */
  public static ModifiableReferenceDifferentPackage create() {
    return new ModifiableReferenceDifferentPackage();
  }

  /**
   * @return value of {@code companion} attribute
   */
  @Override
  public final ModifiableCompanion companion() {
    if (!companionIsSet()) {
      checkRequiredAttributes();
    }
    return companion;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableReferenceDifferentPackage clear() {
    initBits = 0x1L;
    companion = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ReferenceDifferentPackage} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableReferenceDifferentPackage from(ReferenceDifferentPackage instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableReferenceDifferentPackage) {
      from((ModifiableReferenceDifferentPackage) instance);
      return this;
    }
    setCompanion(instance.companion());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ReferenceDifferentPackage} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableReferenceDifferentPackage from(ModifiableReferenceDifferentPackage instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.companionIsSet()) {
      setCompanion(instance.companion());
    }
    return this;
  }

  /**
   * Assigns a value to the {@code companion} attribute.
   * @param companion The value for companion
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableReferenceDifferentPackage setCompanion(Companion companion) {
    this.companion = (companion instanceof ModifiableCompanion ? (ModifiableCompanion) companion : ModifiableCompanion.create().from(companion));
    initBits &= ~INIT_BIT_COMPANION;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@code companion} is set.
   * @return {@code true} if set
   */
  public final boolean companionIsSet() {
    return (initBits & INIT_BIT_COMPANION) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableReferenceDifferentPackage unsetCompanion() {
    initBits |= INIT_BIT_COMPANION;
    companion = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!companionIsSet()) attributes.add("companion");
    return "ReferenceDifferentPackage is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * This instance is equal to all instances of {@code ModifiableReferenceDifferentPackage} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableReferenceDifferentPackage)) return false;
    ModifiableReferenceDifferentPackage other = (ModifiableReferenceDifferentPackage) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableReferenceDifferentPackage another) {
    return companion.equals(another.companion);
  }

  /**
   * Computes a hash code from attributes: {@code companion}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + companion.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code ReferenceDifferentPackage}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableReferenceDifferentPackage")
        .add("companion", companionIsSet() ? companion() : "?")
        .toString();
  }
}
