package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BaseFromComplicated.AB}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAB.builder()}.
 */
@Generated(from = "BaseFromComplicated.AB", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAB implements BaseFromComplicated.AB {
  private final int a;
  private final int c;
  private final ImmutableList<String> b;

  private ImmutableAB(int a, int c, ImmutableList<String> b) {
    this.a = a;
    this.c = c;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public int c() {
    return c;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public ImmutableList<String> b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseFromComplicated.AB#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAB withA(int value) {
    if (this.a == value) return this;
    return new ImmutableAB(value, this.c, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseFromComplicated.AB#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAB withC(int value) {
    if (this.c == value) return this;
    return new ImmutableAB(this.a, value, this.b);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BaseFromComplicated.AB#b() b}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAB withB(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAB(this.a, this.c, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BaseFromComplicated.AB#b() b}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of b elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAB withB(Iterable<String> elements) {
    if (this.b == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAB(this.a, this.c, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAB} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAB
        && equalTo(0, (ImmutableAB) another);
  }

  private boolean equalTo(int synthetic, ImmutableAB another) {
    return a == another.a
        && c == another.c
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code c}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + c;
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AB} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AB")
        .omitNullValues()
        .add("a", a)
        .add("c", c)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link BaseFromComplicated.AB} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AB instance
   */
  public static ImmutableAB copyOf(BaseFromComplicated.AB instance) {
    if (instance instanceof ImmutableAB) {
      return (ImmutableAB) instance;
    }
    return ImmutableAB.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAB ImmutableAB}.
   * <pre>
   * ImmutableAB.builder()
   *    .a(int) // required {@link BaseFromComplicated.AB#a() a}
   *    .c(int) // required {@link BaseFromComplicated.AB#c() c}
   *    .addB|addAllB(String) // {@link BaseFromComplicated.AB#b() b} elements
   *    .build();
   * </pre>
   * @return A new ImmutableAB builder
   */
  public static ImmutableAB.Builder builder() {
    return new ImmutableAB.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAB ImmutableAB}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BaseFromComplicated.AB", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_C = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private int c;
    private ImmutableList.Builder<String> b = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nested.BaseFromComplicated.AB} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseFromComplicated.AB instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nested.BaseFromComplicated.AA} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseFromComplicated.AA instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nested.BaseFromComplicated.A} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseFromComplicated.A instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nested.BaseFromComplicated.B} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseFromComplicated.B instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BaseFromComplicated.AB) {
        BaseFromComplicated.AB instance = (BaseFromComplicated.AB) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          addAllB(instance.b());
          bits |= 0x2L;
        }
        c(instance.c());
      }
      if (object instanceof BaseFromComplicated.AA) {
        BaseFromComplicated.AA instance = (BaseFromComplicated.AA) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
      }
      if (object instanceof BaseFromComplicated.A) {
        BaseFromComplicated.A instance = (BaseFromComplicated.A) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          addAllB(instance.b());
          bits |= 0x2L;
        }
      }
      if (object instanceof BaseFromComplicated.B) {
        BaseFromComplicated.B instance = (BaseFromComplicated.B) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          addAllB(instance.b());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link BaseFromComplicated.AB#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link BaseFromComplicated.AB#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(int c) {
      this.c = c;
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Adds one element to {@link BaseFromComplicated.AB#b() b} list.
     * @param element A b element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(String element) {
      this.b.add(element);
      return this;
    }

    /**
     * Adds elements to {@link BaseFromComplicated.AB#b() b} list.
     * @param elements An array of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(String... elements) {
      this.b.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BaseFromComplicated.AB#b() b} list.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(Iterable<String> elements) {
      this.b = ImmutableList.builder();
      return addAllB(elements);
    }

    /**
     * Adds elements to {@link BaseFromComplicated.AB#b() b} list.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllB(Iterable<String> elements) {
      this.b.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAB ImmutableAB}.
     * @return An immutable instance of AB
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAB build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAB(a, c, b.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build AB, some of required attributes are not set " + attributes;
    }
  }
}
