package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableFoo} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link Foo}.
 * @see ImmutableFoo.Bar
 */
@Generated(from = "Foo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableFoo {
  private ImmutableFoo() {}

  /**
   * Immutable implementation of {@link Foo.Bar}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableFoo.Bar.builder()}.
   */
  @Generated(from = "Foo.Bar", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Bar implements Foo.Bar {
    private final String value;

    private Bar(String value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public String value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Foo.Bar#value() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableFoo.Bar withValue(String value) {
      String newValue = Objects.requireNonNull(value, "value");
      if (this.value.equals(newValue)) return this;
      return new ImmutableFoo.Bar(newValue);
    }

    /**
     * This instance is equal to all instances of {@code Bar} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableFoo.Bar
          && equalTo(0, (ImmutableFoo.Bar) another);
    }

    private boolean equalTo(int synthetic, ImmutableFoo.Bar another) {
      return value.equals(another.value);
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + value.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Bar} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Bar")
          .omitNullValues()
          .add("value", value)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Foo.Bar} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Bar instance
     */
    public static ImmutableFoo.Bar copyOf(Foo.Bar instance) {
      if (instance instanceof ImmutableFoo.Bar) {
        return (ImmutableFoo.Bar) instance;
      }
      return ImmutableFoo.Bar.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableFoo.Bar Bar}.
     * <pre>
     * ImmutableFoo.Bar.builder()
     *    .value(String) // required {@link Foo.Bar#value() value}
     *    .build();
     * </pre>
     * @return A new Bar builder
     */
    public static ImmutableFoo.Bar.Builder builder() {
      return new ImmutableFoo.Bar.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableFoo.Bar Bar}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Foo.Bar", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_VALUE = 0x1L;
      private long initBits = 0x1L;

      private @Nullable String value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nested.Foo} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(Foo instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nested.Foo.Bar} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(Foo.Bar instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        @Var long bits = 0;
        if (object instanceof Foo) {
          Foo instance = (Foo) object;
          if ((bits & 0x1L) == 0) {
            value(instance.value());
            bits |= 0x1L;
          }
        }
        if (object instanceof Foo.Bar) {
          Foo.Bar instance = (Foo.Bar) object;
          if ((bits & 0x1L) == 0) {
            value(instance.value());
            bits |= 0x1L;
          }
        }
      }

      /**
       * Initializes the value for the {@link Foo.Bar#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder value(String value) {
        this.value = Objects.requireNonNull(value, "value");
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableFoo.Bar Bar}.
       * @return An immutable instance of Bar
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableFoo.Bar build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableFoo.Bar(value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build Bar, some of required attributes are not set " + attributes;
      }
    }
  }
}
