package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link BaseFromComplicated.AAA AAA} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableAAA is not thread-safe</em>
 * @see ImmutableAAA
 */
@Generated(from = "BaseFromComplicated.AAA", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "BaseFromComplicated.AAA"})
@NotThreadSafe
public final class ModifiableAAA implements BaseFromComplicated.AAA {
  private static final long INIT_BIT_A = 0x1L;
  private long initBits = 0x1L;

  private int a;
  private final ArrayList<String> b = new ArrayList<String>();

  private ModifiableAAA() {}

  /**
   * Construct a modifiable instance of {@code AAA}.
   * @return A new modifiable instance
   */
  public static ModifiableAAA create() {
    return new ModifiableAAA();
  }

  /**
   * @return value of {@code a} attribute
   */
  @Override
  public final int a() {
    if (!aIsSet()) {
      checkRequiredAttributes();
    }
    return a;
  }

  /**
   * @return modifiable list {@code b}
   */
  @Override
  public final List<String> b() {
    return b;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAAA clear() {
    initBits = 0x1L;
    a = 0;
    b.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.nested.BaseFromComplicated.AAA} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAAA from(BaseFromComplicated.AAA instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.nested.BaseFromComplicated.AA} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAAA from(BaseFromComplicated.AA instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.nested.BaseFromComplicated.A} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAAA from(BaseFromComplicated.A instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link BaseFromComplicated.AAA} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAAA from(ModifiableAAA instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof ModifiableAAA) {
      ModifiableAAA instance = (ModifiableAAA) object;
      if (instance.aIsSet()) {
        setA(instance.a());
      }
      addAllB(instance.b());
      return;
    }
    long bits = 0;
    if (object instanceof BaseFromComplicated.AAA) {
      BaseFromComplicated.AAA instance = (BaseFromComplicated.AAA) object;
      if ((bits & 0x1L) == 0) {
        setA(instance.a());
        bits |= 0x1L;
      }
      if ((bits & 0x2L) == 0) {
        addAllB(instance.b());
        bits |= 0x2L;
      }
    }
    if (object instanceof BaseFromComplicated.AA) {
      BaseFromComplicated.AA instance = (BaseFromComplicated.AA) object;
      if ((bits & 0x1L) == 0) {
        setA(instance.a());
        bits |= 0x1L;
      }
    }
    if (object instanceof BaseFromComplicated.A) {
      BaseFromComplicated.A instance = (BaseFromComplicated.A) object;
      if ((bits & 0x1L) == 0) {
        setA(instance.a());
        bits |= 0x1L;
      }
      if ((bits & 0x2L) == 0) {
        addAllB(instance.b());
        bits |= 0x2L;
      }
    }
  }

  /**
   * Assigns a value to the {@link BaseFromComplicated.AAA#a() a} attribute.
   * @param a The value for a
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAAA setA(int a) {
    this.a = a;
    initBits &= ~INIT_BIT_A;
    return this;
  }

  /**
   * Adds one element to {@link BaseFromComplicated.AAA#b() b} list.
   * @param element The b element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAAA addB(String element) {
    Objects.requireNonNull(element, "b element");
    this.b.add(element);
    return this;
  }

  /**
   * Adds elements to {@link BaseFromComplicated.AAA#b() b} list.
   * @param elements An array of b elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableAAA addB(String... elements) {
    for (String e : elements) {
      addB(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link BaseFromComplicated.AAA#b() b} list.
   * @param elements An iterable of b elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAAA setB(Iterable<String> elements) {
    this.b.clear();
    addAllB(elements);
    return this;
  }

  /**
   * Adds elements to {@link BaseFromComplicated.AAA#b() b} list.
   * @param elements An iterable of b elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAAA addAllB(Iterable<String> elements) {
    for (String e : elements) {
      addB(e);
    }
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link BaseFromComplicated.AAA#a() a} is set.
   * @return {@code true} if set
   */
  public final boolean aIsSet() {
    return (initBits & INIT_BIT_A) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableAAA unsetA() {
    initBits |= INIT_BIT_A;
    a = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!aIsSet()) attributes.add("a");
    return "AAA is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableAAA ImmutableAAA}.
   * @return An immutable instance of AAA
   */
  public final ImmutableAAA toImmutable() {
    checkRequiredAttributes();
    return ImmutableAAA.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableAAA} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableAAA)) return false;
    ModifiableAAA other = (ModifiableAAA) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableAAA another) {
    return a == another.a
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code AAA}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableAAA")
        .add("a", aIsSet() ? a() : "?")
        .add("b", b())
        .toString();
  }
}
