package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FromNullCollection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFromNullCollection.builder()}.
 */
@Generated(from = "FromNullCollection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFromNullCollection implements FromNullCollection {
  private final @Nullable ImmutableList<String> items;
  private final @Nullable ImmutableMap<Integer, String> freq;

  private ImmutableFromNullCollection(
      @Nullable ImmutableList<String> items,
      @Nullable ImmutableMap<Integer, String> freq) {
    this.items = items;
    this.freq = freq;
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @Override
  public @Nullable ImmutableList<String> getItems() {
    return items;
  }

  /**
   * @return The value of the {@code freq} attribute
   */
  @Override
  public @Nullable ImmutableMap<Integer, String> getFreq() {
    return freq;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FromNullCollection#getItems() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFromNullCollection withItems(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableFromNullCollection(null, this.freq);
    }
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableFromNullCollection(newValue, this.freq);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FromNullCollection#getItems() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFromNullCollection withItems(@Nullable Iterable<String> elements) {
    if (this.items == elements) return this;
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableFromNullCollection(newValue, this.freq);
  }

  /**
   * Copy the current immutable object by replacing the {@link FromNullCollection#getFreq() freq} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the freq map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFromNullCollection withFreq(@Nullable Map<Integer, ? extends String> entries) {
    if (this.freq == entries) return this;
    @Nullable ImmutableMap<Integer, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return new ImmutableFromNullCollection(this.items, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFromNullCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFromNullCollection
        && equalTo(0, (ImmutableFromNullCollection) another);
  }

  private boolean equalTo(int synthetic, ImmutableFromNullCollection another) {
    return Objects.equals(items, another.items)
        && Objects.equals(freq, another.freq);
  }

  /**
   * Computes a hash code from attributes: {@code items}, {@code freq}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(items);
    h += (h << 5) + Objects.hashCode(freq);
    return h;
  }

  /**
   * Prints the immutable value {@code FromNullCollection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FromNullCollection")
        .omitNullValues()
        .add("items", items)
        .add("freq", freq)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FromNullCollection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FromNullCollection instance
   */
  public static ImmutableFromNullCollection copyOf(FromNullCollection instance) {
    if (instance instanceof ImmutableFromNullCollection) {
      return (ImmutableFromNullCollection) instance;
    }
    return ImmutableFromNullCollection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFromNullCollection ImmutableFromNullCollection}.
   * <pre>
   * ImmutableFromNullCollection.builder()
   *    .items(List&amp;lt;String&amp;gt; | null) // nullable {@link FromNullCollection#getItems() items}
   *    .freq(Map&amp;lt;Integer, String&amp;gt; | null) // nullable {@link FromNullCollection#getFreq() freq}
   *    .build();
   * </pre>
   * @return A new ImmutableFromNullCollection builder
   */
  public static ImmutableFromNullCollection.Builder builder() {
    return new ImmutableFromNullCollection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFromNullCollection ImmutableFromNullCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FromNullCollection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> items = null;
    private ImmutableMap.Builder<Integer, String> freq = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FromNullCollection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FromNullCollection instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<String> itemsValue = instance.getItems();
      if (itemsValue != null) {
        addAllItems(itemsValue);
      }
      @Nullable Map<Integer, String> freqValue = instance.getFreq();
      if (freqValue != null) {
        putAllFreq(freqValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link FromNullCollection#getItems() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(String element) {
      if (this.items == null) {
        this.items = ImmutableList.builder();
      }
      this.items.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FromNullCollection#getItems() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(String... elements) {
      if (this.items == null) {
        this.items = ImmutableList.builder();
      }
      this.items.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FromNullCollection#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder items(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.items = null;
        return this;
      }
      this.items = ImmutableList.builder();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link FromNullCollection#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllItems(Iterable<String> elements) {
      Objects.requireNonNull(elements, "items element");
      if (this.items == null) {
        this.items = ImmutableList.builder();
      }
      this.items.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link FromNullCollection#getFreq() freq} map.
     * @param key The key in the freq map
     * @param value The associated value in the freq map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putFreq(int key, String value) {
      if (this.freq == null) {
        this.freq = ImmutableMap.builder();
      }
      this.freq.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FromNullCollection#getFreq() freq} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putFreq(Map.Entry<Integer, ? extends String> entry) {
      if (this.freq == null) {
        this.freq = ImmutableMap.builder();
      }
      this.freq.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FromNullCollection#getFreq() freq} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the freq map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder freq(@Nullable Map<Integer, ? extends String> entries) {
      if (entries == null) {
        this.freq = null;
        return this;
      }
      this.freq = ImmutableMap.builder();
      return putAllFreq(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FromNullCollection#getFreq() freq} map. Nulls are not permitted
     * @param entries The entries that will be added to the freq map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllFreq(Map<Integer, ? extends String> entries) {
      if (this.freq == null) {
        this.freq = ImmutableMap.builder();
      }
      this.freq.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFromNullCollection ImmutableFromNullCollection}.
     * @return An immutable instance of FromNullCollection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFromNullCollection build() {
      return new ImmutableFromNullCollection(items == null ? null : items.build(), freq == null ? null : freq.build());
    }
  }
}
