package org.immutables.fixture.nullable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullAnnElements}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullAnnElements.builder()}.
 */
@Generated(from = "NullAnnElements", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNullAnnElements implements NullAnnElements {
  private final List<Void> al;
  private final List<String> sk;
  private final Map<String, Integer> bl;
  private final Map<String, Integer> sm;
  private final Set<String> rg;

  private ImmutableNullAnnElements(
      List<Void> al,
      List<String> sk,
      Map<String, Integer> bl,
      Map<String, Integer> sm,
      Set<String> rg) {
    this.al = al;
    this.sk = sk;
    this.bl = bl;
    this.sm = sm;
    this.rg = rg;
  }

  /**
   * @return The value of the {@code al} attribute
   */
  @Override
  public List<Void> al() {
    return al;
  }

  /**
   * @return The value of the {@code sk} attribute
   */
  @Override
  public List<String> sk() {
    return sk;
  }

  /**
   * @return The value of the {@code bl} attribute
   */
  @Override
  public Map<String, Integer> bl() {
    return bl;
  }

  /**
   * @return The value of the {@code sm} attribute
   */
  @Override
  public Map<String, Integer> sm() {
    return sm;
  }

  /**
   * @return The value of the {@code rg} attribute
   */
  @Override
  public Set<String> rg() {
    return rg;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullAnnElements#al() al}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullAnnElements withAl(Void... elements) {
    List<Void> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableNullAnnElements(newValue, this.sk, this.bl, this.sm, this.rg);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullAnnElements#al() al}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of al elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullAnnElements withAl(Iterable<? extends Void> elements) {
    if (this.al == elements) return this;
    List<Void> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableNullAnnElements(newValue, this.sk, this.bl, this.sm, this.rg);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullAnnElements#sk() sk}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullAnnElements withSk(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, true));
    return new ImmutableNullAnnElements(this.al, newValue, this.bl, this.sm, this.rg);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullAnnElements#sk() sk}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sk elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullAnnElements withSk(Iterable<String> elements) {
    if (this.sk == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, true));
    return new ImmutableNullAnnElements(this.al, newValue, this.bl, this.sm, this.rg);
  }

  /**
   * Copy the current immutable object by replacing the {@link NullAnnElements#bl() bl} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the bl map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullAnnElements withBl(Map<String, ? extends Integer> entries) {
    if (this.bl == entries) return this;
    Map<String, Integer> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableNullAnnElements(this.al, this.sk, newValue, this.sm, this.rg);
  }

  /**
   * Copy the current immutable object by replacing the {@link NullAnnElements#sm() sm} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the sm map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullAnnElements withSm(Map<String, ? extends Integer> entries) {
    if (this.sm == entries) return this;
    Map<String, Integer> newValue = createUnmodifiableMap(false, true, entries);
    return new ImmutableNullAnnElements(this.al, this.sk, this.bl, newValue, this.rg);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullAnnElements#rg() rg}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullAnnElements withRg(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableNullAnnElements(this.al, this.sk, this.bl, this.sm, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullAnnElements#rg() rg}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of rg elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullAnnElements withRg(Iterable<String> elements) {
    if (this.rg == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableNullAnnElements(this.al, this.sk, this.bl, this.sm, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullAnnElements} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullAnnElements
        && equalTo(0, (ImmutableNullAnnElements) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullAnnElements another) {
    return al.equals(another.al)
        && sk.equals(another.sk)
        && bl.equals(another.bl)
        && sm.equals(another.sm)
        && rg.equals(another.rg);
  }

  /**
   * Computes a hash code from attributes: {@code al}, {@code sk}, {@code bl}, {@code sm}, {@code rg}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + al.hashCode();
    h += (h << 5) + sk.hashCode();
    h += (h << 5) + bl.hashCode();
    h += (h << 5) + sm.hashCode();
    h += (h << 5) + rg.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NullAnnElements} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NullAnnElements{"
        + "al=" + al
        + ", sk=" + sk
        + ", bl=" + bl
        + ", sm=" + sm
        + ", rg=" + rg
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link NullAnnElements} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullAnnElements instance
   */
  public static ImmutableNullAnnElements copyOf(NullAnnElements instance) {
    if (instance instanceof ImmutableNullAnnElements) {
      return (ImmutableNullAnnElements) instance;
    }
    return ImmutableNullAnnElements.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullAnnElements ImmutableNullAnnElements}.
   * <pre>
   * ImmutableNullAnnElements.builder()
   *    .addAl|addAllAl(Void) // {@link NullAnnElements#al() al} elements
   *    .addSk|addAllSk(String) // {@link NullAnnElements#sk() sk} elements
   *    .putBl|putAllBl(String =&gt; Integer) // {@link NullAnnElements#bl() bl} mappings
   *    .putSm|putAllSm(String =&gt; Integer) // {@link NullAnnElements#sm() sm} mappings
   *    .addRg|addAllRg(String) // {@link NullAnnElements#rg() rg} elements
   *    .build();
   * </pre>
   * @return A new ImmutableNullAnnElements builder
   */
  public static ImmutableNullAnnElements.Builder builder() {
    return new ImmutableNullAnnElements.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullAnnElements ImmutableNullAnnElements}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullAnnElements", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Void> al = new ArrayList<Void>();
    private List<String> sk = new ArrayList<String>();
    private Map<String, Integer> bl = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> sm = new LinkedHashMap<String, Integer>();
    private List<String> rg = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullAnnElements} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullAnnElements instance) {
      Objects.requireNonNull(instance, "instance");
      addAllAl(instance.al());
      addAllSk(instance.sk());
      putAllBl(instance.bl());
      putAllSm(instance.sm());
      addAllRg(instance.rg());
      return this;
    }

    /**
     * Adds one element to {@link NullAnnElements#al() al} list.
     * @param element A al element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAl(@Nullable Void element) {
      this.al.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NullAnnElements#al() al} list.
     * @param elements An array of al elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAl(Void... elements) {
      for (Void element : elements) {
        this.al.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NullAnnElements#al() al} list.
     * @param elements An iterable of al elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder al(Iterable<? extends Void> elements) {
      this.al.clear();
      return addAllAl(elements);
    }

    /**
     * Adds elements to {@link NullAnnElements#al() al} list.
     * @param elements An iterable of al elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAl(Iterable<? extends Void> elements) {
      for (Void element : elements) {
        this.al.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link NullAnnElements#sk() sk} list.
     * @param element A sk element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSk(@Nullable String element) {
      if (element != null) this.sk.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NullAnnElements#sk() sk} list.
     * @param elements An array of sk elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSk(String... elements) {
      for (String element : elements) {
        if (element != null) this.sk.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NullAnnElements#sk() sk} list.
     * @param elements An iterable of sk elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sk(Iterable<String> elements) {
      this.sk.clear();
      return addAllSk(elements);
    }

    /**
     * Adds elements to {@link NullAnnElements#sk() sk} list.
     * @param elements An iterable of sk elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSk(Iterable<String> elements) {
      for (String element : elements) {
        if (element != null) this.sk.add(element);
      }
      return this;
    }

    /**
     * Put one entry to the {@link NullAnnElements#bl() bl} map.
     * @param key The key in the bl map
     * @param value The associated value in the bl map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBl(@Nullable String key, @Nullable Integer value) {
      this.bl.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NullAnnElements#bl() bl} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBl(Map.Entry<String, ? extends Integer> entry) {
      String k = entry.getKey();
      Integer v = entry.getValue();
      this.bl.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NullAnnElements#bl() bl} map. Nulls are not permitted
     * @param entries The entries that will be added to the bl map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bl(Map<String, ? extends Integer> entries) {
      this.bl.clear();
      return putAllBl(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NullAnnElements#bl() bl} map. Nulls are not permitted
     * @param entries The entries that will be added to the bl map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllBl(Map<String, ? extends Integer> entries) {
      for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
        String k = e.getKey();
        Integer v = e.getValue();
        this.bl.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link NullAnnElements#sm() sm} map.
     * @param key The key in the sm map
     * @param value The associated value in the sm map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSm(@Nullable String key, @Nullable Integer value) {
      if (value != null && key != null) this.sm.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NullAnnElements#sm() sm} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSm(Map.Entry<String, ? extends Integer> entry) {
      String k = entry.getKey();
      Integer v = entry.getValue();
      if (k != null && v != null) this.sm.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NullAnnElements#sm() sm} map. Nulls are not permitted
     * @param entries The entries that will be added to the sm map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sm(Map<String, ? extends Integer> entries) {
      this.sm.clear();
      return putAllSm(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NullAnnElements#sm() sm} map. Nulls are not permitted
     * @param entries The entries that will be added to the sm map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllSm(Map<String, ? extends Integer> entries) {
      for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
        String k = e.getKey();
        Integer v = e.getValue();
        if (k != null && v != null) this.sm.put(k, v);
      }
      return this;
    }

    /**
     * Adds one element to {@link NullAnnElements#rg() rg} set.
     * @param element A rg element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRg(String element) {
      this.rg.add(Objects.requireNonNull(element, "rg element"));
      return this;
    }

    /**
     * Adds elements to {@link NullAnnElements#rg() rg} set.
     * @param elements An array of rg elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRg(String... elements) {
      for (String element : elements) {
        this.rg.add(Objects.requireNonNull(element, "rg element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NullAnnElements#rg() rg} set.
     * @param elements An iterable of rg elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rg(Iterable<String> elements) {
      this.rg.clear();
      return addAllRg(elements);
    }

    /**
     * Adds elements to {@link NullAnnElements#rg() rg} set.
     * @param elements An iterable of rg elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRg(Iterable<String> elements) {
      for (String element : elements) {
        this.rg.add(Objects.requireNonNull(element, "rg element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullAnnElements ImmutableNullAnnElements}.
     * @return An immutable instance of NullAnnElements
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullAnnElements build() {
      return new ImmutableNullAnnElements(
          createUnmodifiableList(true, al),
          createUnmodifiableList(true, sk),
          createUnmodifiableMap(false, false, bl),
          createUnmodifiableMap(false, false, sm),
          createUnmodifiableSet(rg));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
