package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jdt.annotation.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullableTypeUseJdtAccepted}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableTypeUseJdtAccepted.builder()}.
 */
@Generated(from = "NullableTypeUseJdtAccepted", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableNullableTypeUseJdtAccepted
    implements NullableTypeUseJdtAccepted {
  private final java.lang.@Nullable Integer i1;
  private final java.lang.@Nullable Long l2;

  private ImmutableNullableTypeUseJdtAccepted(
      java.lang.@Nullable Integer i1,
      java.lang.@Nullable Long l2) {
    this.i1 = i1;
    this.l2 = l2;
  }

  /**
   * @return The value of the {@code i1} attribute
   */
  @Override
  public java.lang.@Nullable Integer i1() {
    return i1;
  }

  /**
   * @return The value of the {@code l2} attribute
   */
  @Override
  public java.lang.@Nullable Long l2() {
    return l2;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NullableTypeUseJdtAccepted#i1() i1} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for i1 (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullableTypeUseJdtAccepted withI1(java.lang.@Nullable Integer value) {
    if (Objects.equals(this.i1, value)) return this;
    return new ImmutableNullableTypeUseJdtAccepted(value, this.l2);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NullableTypeUseJdtAccepted#l2() l2} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for l2 (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullableTypeUseJdtAccepted withL2(java.lang.@Nullable Long value) {
    if (Objects.equals(this.l2, value)) return this;
    return new ImmutableNullableTypeUseJdtAccepted(this.i1, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableTypeUseJdtAccepted} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableTypeUseJdtAccepted
        && equalTo(0, (ImmutableNullableTypeUseJdtAccepted) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableTypeUseJdtAccepted another) {
    return Objects.equals(i1, another.i1)
        && Objects.equals(l2, another.l2);
  }

  /**
   * Computes a hash code from attributes: {@code i1}, {@code l2}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(i1);
    h += (h << 5) + Objects.hashCode(l2);
    return h;
  }

  /**
   * Prints the immutable value {@code NullableTypeUseJdtAccepted} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullableTypeUseJdtAccepted")
        .omitNullValues()
        .add("i1", i1)
        .add("l2", l2)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NullableTypeUseJdtAccepted} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableTypeUseJdtAccepted instance
   */
  public static ImmutableNullableTypeUseJdtAccepted copyOf(NullableTypeUseJdtAccepted instance) {
    if (instance instanceof ImmutableNullableTypeUseJdtAccepted) {
      return (ImmutableNullableTypeUseJdtAccepted) instance;
    }
    return ImmutableNullableTypeUseJdtAccepted.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableTypeUseJdtAccepted ImmutableNullableTypeUseJdtAccepted}.
   * <pre>
   * ImmutableNullableTypeUseJdtAccepted.builder()
   *    .i1(@org.eclipse.jdt.annotation.Nullable Integer | null) // nullable {@link NullableTypeUseJdtAccepted#i1() i1}
   *    .l2(@org.eclipse.jdt.annotation.Nullable Long | null) // nullable {@link NullableTypeUseJdtAccepted#l2() l2}
   *    .build();
   * </pre>
   * @return A new ImmutableNullableTypeUseJdtAccepted builder
   */
  public static ImmutableNullableTypeUseJdtAccepted.Builder builder() {
    return new ImmutableNullableTypeUseJdtAccepted.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableTypeUseJdtAccepted ImmutableNullableTypeUseJdtAccepted}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullableTypeUseJdtAccepted", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable java.lang.@Nullable Integer i1;
    private @javax.annotation.Nullable java.lang.@Nullable Long l2;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableTypeUseJdtAccepted} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullableTypeUseJdtAccepted instance) {
      Objects.requireNonNull(instance, "instance");
      java.lang.@Nullable Integer i1Value = instance.i1();
      if (i1Value != null) {
        i1(i1Value);
      }
      java.lang.@Nullable Long l2Value = instance.l2();
      if (l2Value != null) {
        l2(l2Value);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NullableTypeUseJdtAccepted#i1() i1} attribute.
     * @param i1 The value for i1 (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i1(java.lang.@Nullable Integer i1) {
      this.i1 = i1;
      return this;
    }

    /**
     * Initializes the value for the {@link NullableTypeUseJdtAccepted#l2() l2} attribute.
     * @param l2 The value for l2 (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l2(java.lang.@Nullable Long l2) {
      this.l2 = l2;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableTypeUseJdtAccepted ImmutableNullableTypeUseJdtAccepted}.
     * @return An immutable instance of NullableTypeUseJdtAccepted
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableTypeUseJdtAccepted build() {
      return new ImmutableNullableTypeUseJdtAccepted(i1, l2);
    }
  }
}
