package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FromSupertypeNullable.Subtype}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSubtype.builder()}.
 */
@Generated(from = "FromSupertypeNullable.Subtype", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSubtype implements FromSupertypeNullable.Subtype {
  private final String a;
  private final String b;

  private ImmutableSubtype(String a, String b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FromSupertypeNullable.Subtype#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSubtype withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableSubtype(newValue, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FromSupertypeNullable.Subtype#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSubtype withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableSubtype(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSubtype} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSubtype
        && equalTo(0, (ImmutableSubtype) another);
  }

  private boolean equalTo(int synthetic, ImmutableSubtype another) {
    return a.equals(another.a)
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Subtype} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Subtype")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FromSupertypeNullable.Subtype} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Subtype instance
   */
  public static ImmutableSubtype copyOf(FromSupertypeNullable.Subtype instance) {
    if (instance instanceof ImmutableSubtype) {
      return (ImmutableSubtype) instance;
    }
    return ImmutableSubtype.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSubtype ImmutableSubtype}.
   * <pre>
   * ImmutableSubtype.builder()
   *    .a(String) // required {@link FromSupertypeNullable.Subtype#a() a}
   *    .b(String) // required {@link FromSupertypeNullable.Subtype#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableSubtype builder
   */
  public static ImmutableSubtype.Builder builder() {
    return new ImmutableSubtype.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSubtype ImmutableSubtype}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FromSupertypeNullable.Subtype", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String a;
    private @Nullable String b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nullable.FromSupertypeNullable.Subtype} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FromSupertypeNullable.Subtype instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nullable.FromSupertypeNullable.SuperB} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FromSupertypeNullable.SuperB instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nullable.FromSupertypeNullable.SuperA} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FromSupertypeNullable.SuperA instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof FromSupertypeNullable.Subtype) {
        FromSupertypeNullable.Subtype instance = (FromSupertypeNullable.Subtype) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String aValue = instance.a();
          if (aValue != null) {
            a(aValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable String bValue = instance.b();
          if (bValue != null) {
            b(bValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof FromSupertypeNullable.SuperB) {
        FromSupertypeNullable.SuperB instance = (FromSupertypeNullable.SuperB) object;
        if ((bits & 0x2L) == 0) {
          @Nullable String bValue = instance.b();
          if (bValue != null) {
            b(bValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof FromSupertypeNullable.SuperA) {
        FromSupertypeNullable.SuperA instance = (FromSupertypeNullable.SuperA) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String aValue = instance.a();
          if (aValue != null) {
            a(aValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link FromSupertypeNullable.Subtype#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link FromSupertypeNullable.Subtype#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSubtype ImmutableSubtype}.
     * @return An immutable instance of Subtype
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSubtype build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSubtype(a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build Subtype, some of required attributes are not set " + attributes;
    }
  }
}
