package org.immutables.fixture.routine;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import static org.immutables.fixture.routine.Defaults.immutableCopyOf;
import static org.immutables.fixture.routine.Routines.immutableCopyOf;

/**
 * Immutable implementation of {@link Bb}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBb.builder()}.
 */
@Generated(from = "Bb", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBb implements Bb {
  private final Aa aa;
  private final Bb bb;
  private final @Nullable Bb zz;
  private final Optional<List<String>> uu;

  private ImmutableBb(
      Aa aa,
      Bb bb,
      @Nullable Bb zz,
      Optional<List<String>> uu) {
    this.aa = aa;
    this.bb = bb;
    this.zz = zz;
    this.uu = uu;
  }

  /**
   * @return The value of the {@code aa} attribute
   */
  @Override
  public Aa aa() {
    return aa;
  }

  /**
   * @return The value of the {@code bb} attribute
   */
  @Override
  public Bb bb() {
    return bb;
  }

  /**
   * @return The value of the {@code zz} attribute
   */
  @Override
  public java.util.Optional<Bb> zz() {
    return java.util.Optional.ofNullable(zz);
  }

  /**
   * @return The value of the {@code uu} attribute
   */
  @Override
  public Optional<List<String>> uu() {
    return uu;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bb#aa() aa} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aa
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBb withAa(Aa value) {
    if (this.aa == value) return this;
    Aa newValue = immutableCopyOf(Objects.requireNonNull(value, "aa"));
    return new ImmutableBb(newValue, this.bb, this.zz, this.uu);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bb#bb() bb} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bb
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBb withBb(Bb value) {
    if (this.bb == value) return this;
    Bb newValue = immutableCopyOf(Objects.requireNonNull(value, "bb"));
    return new ImmutableBb(this.aa, newValue, this.zz, this.uu);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Bb#zz() zz} attribute.
   * @param value The value for zz
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBb withZz(Bb value) {
    @Nullable Bb newValue = immutableCopyOf(Objects.requireNonNull(value, "zz"));
    if (this.zz == newValue) return this;
    return new ImmutableBb(this.aa, this.bb, newValue, this.uu);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Bb#zz() zz} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for zz
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableBb withZz(java.util.Optional<? extends Bb> optional) {
    @Nullable Bb value = immutableCopyOf(optional.orElse(null));
    if (this.zz == value) return this;
    return new ImmutableBb(this.aa, this.bb, value, this.uu);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Bb#uu() uu} attribute.
   * @param value The value for uu
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBb withUu(List<String> value) {
    Optional<List<String>> newValue = Optional.of(immutableCopyOf(value));
    if (this.uu.isPresent() && this.uu.get() == value) return this;
    return new ImmutableBb(this.aa, this.bb, this.zz, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Bb#uu() uu} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for uu
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableBb withUu(Optional<? extends List<String>> optional) {
    Optional<List<String>> value = (Optional<List<String>>) immutableCopyOf(optional);
    if (!this.uu.isPresent() && !value.isPresent()) return this;
    if (this.uu.isPresent() && value.isPresent() && this.uu.get() == value.get()) return this;
    return new ImmutableBb(this.aa, this.bb, this.zz, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBb} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBb
        && equalTo(0, (ImmutableBb) another);
  }

  private boolean equalTo(int synthetic, ImmutableBb another) {
    return aa.equals(another.aa)
        && bb.equals(another.bb)
        && Objects.equals(zz, another.zz)
        && uu.equals(another.uu);
  }

  /**
   * Computes a hash code from attributes: {@code aa}, {@code bb}, {@code zz}, {@code uu}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + aa.hashCode();
    h += (h << 5) + bb.hashCode();
    h += (h << 5) + Objects.hashCode(zz);
    h += (h << 5) + uu.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Bb} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Bb")
        .omitNullValues()
        .add("aa", aa)
        .add("bb", bb)
        .add("zz", zz)
        .add("uu", uu.orNull())
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Bb} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Bb instance
   */
  public static ImmutableBb copyOf(Bb instance) {
    if (instance instanceof ImmutableBb) {
      return (ImmutableBb) instance;
    }
    return ImmutableBb.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBb ImmutableBb}.
   * <pre>
   * ImmutableBb.builder()
   *    .aa(org.immutables.fixture.routine.Aa) // required {@link Bb#aa() aa}
   *    .bb(org.immutables.fixture.routine.Bb) // required {@link Bb#bb() bb}
   *    .zz(org.immutables.fixture.routine.Bb) // optional {@link Bb#zz() zz}
   *    .uu(List&amp;lt;String&amp;gt;) // optional {@link Bb#uu() uu}
   *    .build();
   * </pre>
   * @return A new ImmutableBb builder
   */
  public static ImmutableBb.Builder builder() {
    return new ImmutableBb.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBb ImmutableBb}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Bb", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_AA = 0x1L;
    private static final long INIT_BIT_BB = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Aa aa;
    private @Nullable Bb bb;
    private @Nullable Bb zz;
    private Optional<List<String>> uu = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Bb} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Bb instance) {
      Objects.requireNonNull(instance, "instance");
      aa(instance.aa());
      bb(instance.bb());
      java.util.Optional<Bb> zzOptional = instance.zz();
      if (zzOptional.isPresent()) {
        zz(zzOptional);
      }
      Optional<List<String>> uuOptional = instance.uu();
      if (uuOptional.isPresent()) {
        uu(uuOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Bb#aa() aa} attribute.
     * @param aa The value for aa 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder aa(Aa aa) {
      this.aa = immutableCopyOf(Objects.requireNonNull(aa, "aa"));
      initBits &= ~INIT_BIT_AA;
      return this;
    }

    /**
     * Initializes the value for the {@link Bb#bb() bb} attribute.
     * @param bb The value for bb 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bb(Bb bb) {
      this.bb = immutableCopyOf(Objects.requireNonNull(bb, "bb"));
      initBits &= ~INIT_BIT_BB;
      return this;
    }

    /**
     * Initializes the optional value {@link Bb#zz() zz} to zz.
     * @param zz The value for zz
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder zz(Bb zz) {
      this.zz = immutableCopyOf(Objects.requireNonNull(zz, "zz"));
      return this;
    }

    /**
     * Initializes the optional value {@link Bb#zz() zz} to zz.
     * @param zz The value for zz
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder zz(java.util.Optional<? extends Bb> zz) {
      this.zz = immutableCopyOf(zz.orElse(null));
      return this;
    }

    /**
     * Initializes the optional value {@link Bb#uu() uu} to uu.
     * @param uu The value for uu
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder uu(List<String> uu) {
      this.uu = Optional.of(immutableCopyOf(uu));
      return this;
    }

    /**
     * Initializes the optional value {@link Bb#uu() uu} to uu.
     * @param uu The value for uu
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder uu(Optional<? extends List<String>> uu) {
      this.uu = (Optional<List<String>>) immutableCopyOf(uu);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBb ImmutableBb}.
     * @return An immutable instance of Bb
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBb build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBb(aa, bb, zz, uu);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AA) != 0) attributes.add("aa");
      if ((initBits & INIT_BIT_BB) != 0) attributes.add("bb");
      return "Cannot build Bb, some of required attributes are not set " + attributes;
    }
  }
}
