package org.immutables.fixture.strict;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Bar}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBar.builder()}.
 */
@Generated(from = "Bar", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableBar implements Bar {
  private final ImmutableList<Integer> nums;
  private final ImmutableMap<String, Integer> map;
  private final ImmutableMap<String, Integer> immutableMap;
  private final SortedMap<String, Integer> sortedMap;
  private final ImmutableSortedMap<String, Integer> immutableSortedMap;
  private final ImmutableSet<String> set;
  private final ImmutableSet<String> immutableSet;
  private final SortedSet<String> sortedSet;
  private final ImmutableSortedSet<String> immutableSortedSet;
  private final Optional<Integer> opt;
  private final EnumMap<BoundType, Integer> enumMap;
  private final EnumSet<BoundType> enumSet;

  private ImmutableBar(
      ImmutableList<Integer> nums,
      ImmutableMap<String, Integer> map,
      ImmutableMap<String, Integer> immutableMap,
      SortedMap<String, Integer> sortedMap,
      ImmutableSortedMap<String, Integer> immutableSortedMap,
      ImmutableSet<String> set,
      ImmutableSet<String> immutableSet,
      SortedSet<String> sortedSet,
      ImmutableSortedSet<String> immutableSortedSet,
      Optional<Integer> opt,
      EnumMap<BoundType, Integer> enumMap,
      EnumSet<BoundType> enumSet) {
    this.nums = nums;
    this.map = map;
    this.immutableMap = immutableMap;
    this.sortedMap = sortedMap;
    this.immutableSortedMap = immutableSortedMap;
    this.set = set;
    this.immutableSet = immutableSet;
    this.sortedSet = sortedSet;
    this.immutableSortedSet = immutableSortedSet;
    this.opt = opt;
    this.enumMap = enumMap;
    this.enumSet = enumSet;
  }

  /**
   * @return The value of the {@code nums} attribute
   */
  @Override
  public ImmutableList<Integer> nums() {
    return nums;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public ImmutableMap<String, Integer> map() {
    return map;
  }

  /**
   * @return The value of the {@code immutableMap} attribute
   */
  @Override
  public ImmutableMap<String, Integer> immutableMap() {
    return immutableMap;
  }

  /**
   * @return The value of the {@code sortedMap} attribute
   */
  @Override
  public SortedMap<String, Integer> sortedMap() {
    return sortedMap;
  }

  /**
   * @return The value of the {@code immutableSortedMap} attribute
   */
  @Override
  public ImmutableSortedMap<String, Integer> immutableSortedMap() {
    return immutableSortedMap;
  }

  /**
   * @return The value of the {@code set} attribute
   */
  @Override
  public ImmutableSet<String> set() {
    return set;
  }

  /**
   * @return The value of the {@code immutableSet} attribute
   */
  @Override
  public ImmutableSet<String> immutableSet() {
    return immutableSet;
  }

  /**
   * @return The value of the {@code sortedSet} attribute
   */
  @Override
  public SortedSet<String> sortedSet() {
    return sortedSet;
  }

  /**
   * @return The value of the {@code immutableSortedSet} attribute
   */
  @Override
  public ImmutableSortedSet<String> immutableSortedSet() {
    return immutableSortedSet;
  }

  /**
   * @return The value of the {@code opt} attribute
   */
  @Override
  public Optional<Integer> opt() {
    return opt;
  }

  /**
   * @return The value of the {@code enumMap} attribute
   */
  @Override
  public EnumMap<BoundType, Integer> enumMap() {
    return enumMap;
  }

  /**
   * @return The value of the {@code enumSet} attribute
   */
  @Override
  public EnumSet<BoundType> enumSet() {
    return enumSet;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Bar#nums() nums}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withNums(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableBar(
        newValue,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Bar#nums() nums}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nums elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withNums(Iterable<Integer> elements) {
    if (this.nums == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBar(
        newValue,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by replacing the {@link Bar#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withMap(Map<String, ? extends Integer> entries) {
    if (this.map == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableBar(
        this.nums,
        newValue,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by replacing the {@link Bar#immutableMap() immutableMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the immutableMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withImmutableMap(Map<String, ? extends Integer> entries) {
    if (this.immutableMap == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableBar(
        this.nums,
        this.map,
        newValue,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bar#sortedMap() sortedMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sortedMap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBar withSortedMap(SortedMap<String, Integer> value) {
    if (this.sortedMap == value) return this;
    SortedMap<String, Integer> newValue = Objects.requireNonNull(value, "sortedMap");
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        newValue,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bar#immutableSortedMap() immutableSortedMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for immutableSortedMap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBar withImmutableSortedMap(ImmutableSortedMap<String, Integer> value) {
    if (this.immutableSortedMap == value) return this;
    ImmutableSortedMap<String, Integer> newValue = Objects.requireNonNull(value, "immutableSortedMap");
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        newValue,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Bar#set() set}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withSet(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        newValue,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Bar#set() set}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of set elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withSet(Iterable<String> elements) {
    if (this.set == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        newValue,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Bar#immutableSet() immutableSet}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withImmutableSet(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        newValue,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Bar#immutableSet() immutableSet}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of immutableSet elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withImmutableSet(Iterable<String> elements) {
    if (this.immutableSet == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        newValue,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bar#sortedSet() sortedSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sortedSet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBar withSortedSet(SortedSet<String> value) {
    if (this.sortedSet == value) return this;
    SortedSet<String> newValue = Objects.requireNonNull(value, "sortedSet");
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        newValue,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bar#immutableSortedSet() immutableSortedSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for immutableSortedSet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBar withImmutableSortedSet(ImmutableSortedSet<String> value) {
    if (this.immutableSortedSet == value) return this;
    ImmutableSortedSet<String> newValue = Objects.requireNonNull(value, "immutableSortedSet");
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        newValue,
        this.opt,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Bar#opt() opt} attribute.
   * @param value The value for opt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withOpt(int value) {
    Optional<Integer> newValue = Optional.of(value);
    if (this.opt.equals(newValue)) return this;
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        newValue,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Bar#opt() opt} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for opt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBar withOpt(Optional<Integer> optional) {
    Optional<Integer> value = optional;
    if (this.opt.equals(value)) return this;
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        value,
        this.enumMap,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bar#enumMap() enumMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enumMap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBar withEnumMap(EnumMap<BoundType, Integer> value) {
    if (this.enumMap == value) return this;
    EnumMap<BoundType, Integer> newValue = Objects.requireNonNull(value, "enumMap");
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        newValue,
        this.enumSet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bar#enumSet() enumSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enumSet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBar withEnumSet(EnumSet<BoundType> value) {
    if (this.enumSet == value) return this;
    EnumSet<BoundType> newValue = Objects.requireNonNull(value, "enumSet");
    return new ImmutableBar(
        this.nums,
        this.map,
        this.immutableMap,
        this.sortedMap,
        this.immutableSortedMap,
        this.set,
        this.immutableSet,
        this.sortedSet,
        this.immutableSortedSet,
        this.opt,
        this.enumMap,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBar} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBar
        && equalTo(0, (ImmutableBar) another);
  }

  private boolean equalTo(int synthetic, ImmutableBar another) {
    return nums.equals(another.nums)
        && map.equals(another.map)
        && immutableMap.equals(another.immutableMap)
        && sortedMap.equals(another.sortedMap)
        && immutableSortedMap.equals(another.immutableSortedMap)
        && set.equals(another.set)
        && immutableSet.equals(another.immutableSet)
        && sortedSet.equals(another.sortedSet)
        && immutableSortedSet.equals(another.immutableSortedSet)
        && opt.equals(another.opt)
        && enumMap.equals(another.enumMap)
        && enumSet.equals(another.enumSet);
  }

  /**
   * Computes a hash code from attributes: {@code nums}, {@code map}, {@code immutableMap}, {@code sortedMap}, {@code immutableSortedMap}, {@code set}, {@code immutableSet}, {@code sortedSet}, {@code immutableSortedSet}, {@code opt}, {@code enumMap}, {@code enumSet}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + nums.hashCode();
    h += (h << 5) + map.hashCode();
    h += (h << 5) + immutableMap.hashCode();
    h += (h << 5) + sortedMap.hashCode();
    h += (h << 5) + immutableSortedMap.hashCode();
    h += (h << 5) + set.hashCode();
    h += (h << 5) + immutableSet.hashCode();
    h += (h << 5) + sortedSet.hashCode();
    h += (h << 5) + immutableSortedSet.hashCode();
    h += (h << 5) + opt.hashCode();
    h += (h << 5) + enumMap.hashCode();
    h += (h << 5) + enumSet.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Bar} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Bar")
        .omitNullValues()
        .add("nums", nums)
        .add("map", map)
        .add("immutableMap", immutableMap)
        .add("sortedMap", sortedMap)
        .add("immutableSortedMap", immutableSortedMap)
        .add("set", set)
        .add("immutableSet", immutableSet)
        .add("sortedSet", sortedSet)
        .add("immutableSortedSet", immutableSortedSet)
        .add("opt", opt.orNull())
        .add("enumMap", enumMap)
        .add("enumSet", enumSet)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Bar} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Bar instance
   */
  public static ImmutableBar copyOf(Bar instance) {
    if (instance instanceof ImmutableBar) {
      return (ImmutableBar) instance;
    }
    return ImmutableBar.builder()
        .addAllNums(instance.nums())
        .putAllMap(instance.map())
        .putAllImmutableMap(instance.immutableMap())
        .sortedMap(instance.sortedMap())
        .immutableSortedMap(instance.immutableSortedMap())
        .addAllSet(instance.set())
        .addAllImmutableSet(instance.immutableSet())
        .sortedSet(instance.sortedSet())
        .immutableSortedSet(instance.immutableSortedSet())
        .opt(instance.opt())
        .enumMap(instance.enumMap())
        .enumSet(instance.enumSet())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBar ImmutableBar}.
   * <pre>
   * ImmutableBar.builder()
   *    .addNums|addAllNums(int) // {@link Bar#nums() nums} elements
   *    .putMap|putAllMap(String =&gt; int) // {@link Bar#map() map} mappings
   *    .putImmutableMap|putAllImmutableMap(String =&gt; int) // {@link Bar#immutableMap() immutableMap} mappings
   *    .sortedMap(SortedMap&amp;lt;String, Integer&amp;gt;) // required {@link Bar#sortedMap() sortedMap}
   *    .immutableSortedMap(com.google.common.collect.ImmutableSortedMap&amp;lt;String, Integer&amp;gt;) // required {@link Bar#immutableSortedMap() immutableSortedMap}
   *    .addSet|addAllSet(String) // {@link Bar#set() set} elements
   *    .addImmutableSet|addAllImmutableSet(String) // {@link Bar#immutableSet() immutableSet} elements
   *    .sortedSet(SortedSet&amp;lt;String&amp;gt;) // required {@link Bar#sortedSet() sortedSet}
   *    .immutableSortedSet(com.google.common.collect.ImmutableSortedSet&amp;lt;String&amp;gt;) // required {@link Bar#immutableSortedSet() immutableSortedSet}
   *    .opt(Integer) // optional {@link Bar#opt() opt}
   *    .enumMap(EnumMap&amp;lt;com.google.common.collect.BoundType, Integer&amp;gt;) // required {@link Bar#enumMap() enumMap}
   *    .enumSet(EnumSet&amp;lt;com.google.common.collect.BoundType&amp;gt;) // required {@link Bar#enumSet() enumSet}
   *    .build();
   * </pre>
   * @return A new ImmutableBar builder
   */
  public static ImmutableBar.Builder builder() {
    return new ImmutableBar.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBar ImmutableBar}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Bar", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SORTED_MAP = 0x1L;
    private static final long INIT_BIT_IMMUTABLE_SORTED_MAP = 0x2L;
    private static final long INIT_BIT_SORTED_SET = 0x4L;
    private static final long INIT_BIT_IMMUTABLE_SORTED_SET = 0x8L;
    private static final long INIT_BIT_ENUM_MAP = 0x10L;
    private static final long INIT_BIT_ENUM_SET = 0x20L;
    private static final long OPT_BIT_OPT = 0x1L;
    private long initBits = 0x3fL;
    private long optBits;

    private final ImmutableList.Builder<Integer> nums = ImmutableList.builder();
    private final ImmutableMap.Builder<String, Integer> map = ImmutableMap.builder();
    private final ImmutableMap.Builder<String, Integer> immutableMap = ImmutableMap.builder();
    private @Nullable SortedMap<String, Integer> sortedMap;
    private @Nullable ImmutableSortedMap<String, Integer> immutableSortedMap;
    private final ImmutableSet.Builder<String> set = ImmutableSet.builder();
    private final ImmutableSet.Builder<String> immutableSet = ImmutableSet.builder();
    private @Nullable SortedSet<String> sortedSet;
    private @Nullable ImmutableSortedSet<String> immutableSortedSet;
    private Optional<Integer> opt = Optional.absent();
    private @Nullable EnumMap<BoundType, Integer> enumMap;
    private @Nullable EnumSet<BoundType> enumSet;

    private Builder() {
    }

    /**
     * Adds one element to {@link Bar#nums() nums} list.
     * @param element A nums element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNums(int element) {
      this.nums.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Bar#nums() nums} list.
     * @param elements An array of nums elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNums(int... elements) {
      this.nums.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Adds elements to {@link Bar#nums() nums} list.
     * @param elements An iterable of nums elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNums(Iterable<Integer> elements) {
      this.nums.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link Bar#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(String key, int value) {
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Bar#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends Integer> entry) {
      this.map.put(entry);
      return this;
    }

    /**
     * Put all mappings from the specified map as entries to {@link Bar#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends Integer> entries) {
      this.map.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link Bar#immutableMap() immutableMap} map.
     * @param key The key in the immutableMap map
     * @param value The associated value in the immutableMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putImmutableMap(String key, int value) {
      this.immutableMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Bar#immutableMap() immutableMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putImmutableMap(Map.Entry<String, ? extends Integer> entry) {
      this.immutableMap.put(entry);
      return this;
    }

    /**
     * Put all mappings from the specified map as entries to {@link Bar#immutableMap() immutableMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the immutableMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllImmutableMap(Map<String, ? extends Integer> entries) {
      this.immutableMap.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link Bar#sortedMap() sortedMap} attribute.
     * @param sortedMap The value for sortedMap 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sortedMap(SortedMap<String, Integer> sortedMap) {
      checkNotIsSet(sortedMapIsSet(), "sortedMap");
      this.sortedMap = Objects.requireNonNull(sortedMap, "sortedMap");
      initBits &= ~INIT_BIT_SORTED_MAP;
      return this;
    }

    /**
     * Initializes the value for the {@link Bar#immutableSortedMap() immutableSortedMap} attribute.
     * @param immutableSortedMap The value for immutableSortedMap 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder immutableSortedMap(ImmutableSortedMap<String, Integer> immutableSortedMap) {
      checkNotIsSet(immutableSortedMapIsSet(), "immutableSortedMap");
      this.immutableSortedMap = Objects.requireNonNull(immutableSortedMap, "immutableSortedMap");
      initBits &= ~INIT_BIT_IMMUTABLE_SORTED_MAP;
      return this;
    }

    /**
     * Adds one element to {@link Bar#set() set} set.
     * @param element A set element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet(String element) {
      this.set.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Bar#set() set} set.
     * @param elements An array of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet(String... elements) {
      this.set.add(elements);
      return this;
    }


    /**
     * Adds elements to {@link Bar#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSet(Iterable<String> elements) {
      this.set.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Bar#immutableSet() immutableSet} set.
     * @param element A immutableSet element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImmutableSet(String element) {
      this.immutableSet.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Bar#immutableSet() immutableSet} set.
     * @param elements An array of immutableSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImmutableSet(String... elements) {
      this.immutableSet.add(elements);
      return this;
    }


    /**
     * Adds elements to {@link Bar#immutableSet() immutableSet} set.
     * @param elements An iterable of immutableSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllImmutableSet(Iterable<String> elements) {
      this.immutableSet.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Bar#sortedSet() sortedSet} attribute.
     * @param sortedSet The value for sortedSet 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sortedSet(SortedSet<String> sortedSet) {
      checkNotIsSet(sortedSetIsSet(), "sortedSet");
      this.sortedSet = Objects.requireNonNull(sortedSet, "sortedSet");
      initBits &= ~INIT_BIT_SORTED_SET;
      return this;
    }

    /**
     * Initializes the value for the {@link Bar#immutableSortedSet() immutableSortedSet} attribute.
     * @param immutableSortedSet The value for immutableSortedSet 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder immutableSortedSet(ImmutableSortedSet<String> immutableSortedSet) {
      checkNotIsSet(immutableSortedSetIsSet(), "immutableSortedSet");
      this.immutableSortedSet = Objects.requireNonNull(immutableSortedSet, "immutableSortedSet");
      initBits &= ~INIT_BIT_IMMUTABLE_SORTED_SET;
      return this;
    }

    /**
     * Initializes the optional value {@link Bar#opt() opt} to opt.
     * @param opt The value for opt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opt(int opt) {
      checkNotIsSet(optIsSet(), "opt");
      this.opt = Optional.of(opt);
      optBits |= OPT_BIT_OPT;
      return this;
    }

    /**
     * Initializes the optional value {@link Bar#opt() opt} to opt.
     * @param opt The value for opt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opt(Optional<Integer> opt) {
      checkNotIsSet(optIsSet(), "opt");
      this.opt = opt;
      optBits |= OPT_BIT_OPT;
      return this;
    }

    /**
     * Initializes the value for the {@link Bar#enumMap() enumMap} attribute.
     * @param enumMap The value for enumMap 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enumMap(EnumMap<BoundType, Integer> enumMap) {
      checkNotIsSet(enumMapIsSet(), "enumMap");
      this.enumMap = Objects.requireNonNull(enumMap, "enumMap");
      initBits &= ~INIT_BIT_ENUM_MAP;
      return this;
    }

    /**
     * Initializes the value for the {@link Bar#enumSet() enumSet} attribute.
     * @param enumSet The value for enumSet 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enumSet(EnumSet<BoundType> enumSet) {
      checkNotIsSet(enumSetIsSet(), "enumSet");
      this.enumSet = Objects.requireNonNull(enumSet, "enumSet");
      initBits &= ~INIT_BIT_ENUM_SET;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBar ImmutableBar}.
     * @return An immutable instance of Bar
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBar build() {
      checkRequiredAttributes();
      return new ImmutableBar(
          nums.build(),
          map.build(),
          immutableMap.build(),
          sortedMap,
          immutableSortedMap,
          set.build(),
          immutableSet.build(),
          sortedSet,
          immutableSortedSet,
          opt,
          enumMap,
          enumSet);
    }

    private boolean optIsSet() {
      return (optBits & OPT_BIT_OPT) != 0;
    }

    private boolean sortedMapIsSet() {
      return (initBits & INIT_BIT_SORTED_MAP) == 0;
    }

    private boolean immutableSortedMapIsSet() {
      return (initBits & INIT_BIT_IMMUTABLE_SORTED_MAP) == 0;
    }

    private boolean sortedSetIsSet() {
      return (initBits & INIT_BIT_SORTED_SET) == 0;
    }

    private boolean immutableSortedSetIsSet() {
      return (initBits & INIT_BIT_IMMUTABLE_SORTED_SET) == 0;
    }

    private boolean enumMapIsSet() {
      return (initBits & INIT_BIT_ENUM_MAP) == 0;
    }

    private boolean enumSetIsSet() {
      return (initBits & INIT_BIT_ENUM_SET) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of Bar is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!sortedMapIsSet()) attributes.add("sortedMap");
      if (!immutableSortedMapIsSet()) attributes.add("immutableSortedMap");
      if (!sortedSetIsSet()) attributes.add("sortedSet");
      if (!immutableSortedSetIsSet()) attributes.add("immutableSortedSet");
      if (!enumMapIsSet()) attributes.add("enumMap");
      if (!enumSetIsSet()) attributes.add("enumSet");
      return "Cannot build Bar, some of required attributes are not set " + attributes;
    }
  }
}
