package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link ConservativeStyleDetected ConservativeStyleDetected}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code ConservativeStyleDetectedBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "ConservativeStyleDetected", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class ConservativeStyleDetectedBuilder {
  private static final long INIT_BIT_VALUE = 0x1L;
  private static final long INIT_BIT_STRING = 0x2L;
  private long initBits = 0x3L;

  private ImmutableList.Builder<String> em = ImmutableList.builder();
  private int value;
  private @Nullable String string;

  /**
   * Creates a builder for {@link ConservativeStyleDetected ConservativeStyleDetected} instances.
   * <pre>
   * new ConservativeStyleDetectedBuilder()
   *    .addEm|addAllEm(String) // {@link ConservativeStyleDetected#getEm() em} elements
   *    .setValue(int) // required {@link ConservativeStyleDetected#getValue() value}
   *    .setString(String) // required {@link ConservativeStyleDetected#getString() string}
   *    .build();
   * </pre>
   */
  public ConservativeStyleDetectedBuilder() {
  }

  /**
   * Fill a builder with attribute values from the provided {@code ConservativeStyleDetected} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ConservativeStyleDetectedBuilder from(ConservativeStyleDetected instance) {
    Objects.requireNonNull(instance, "instance");
    addAllEm(instance.getEm());
    setValue(instance.getValue());
    setString(instance.getString());
    return this;
  }

  /**
   * Adds one element to {@link ConservativeStyleDetected#getEm() em} list.
   * @param element A em element
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ConservativeStyleDetectedBuilder addEm(String element) {
    this.em.add(element);
    return this;
  }

  /**
   * Adds elements to {@link ConservativeStyleDetected#getEm() em} list.
   * @param elements An array of em elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ConservativeStyleDetectedBuilder addEm(String... elements) {
    this.em.add(elements);
    return this;
  }


  /**
   * Sets or replaces all elements for {@link ConservativeStyleDetected#getEm() em} list.
   * @param elements An iterable of em elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ConservativeStyleDetectedBuilder setEm(Iterable<String> elements) {
    this.em = ImmutableList.builder();
    return addAllEm(elements);
  }

  /**
   * Adds elements to {@link ConservativeStyleDetected#getEm() em} list.
   * @param elements An iterable of em elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ConservativeStyleDetectedBuilder addAllEm(Iterable<String> elements) {
    this.em.addAll(elements);
    return this;
  }

  /**
   * Initializes the value for the {@link ConservativeStyleDetected#getValue() value} attribute.
   * @param value The value for value 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ConservativeStyleDetectedBuilder setValue(int value) {
    this.value = value;
    initBits &= ~INIT_BIT_VALUE;
    return this;
  }

  /**
   * Initializes the value for the {@link ConservativeStyleDetected#getString() string} attribute.
   * @param string The value for string 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ConservativeStyleDetectedBuilder setString(String string) {
    this.string = Objects.requireNonNull(string, "string");
    initBits &= ~INIT_BIT_STRING;
    return this;
  }

  /**
   * Builds a new {@link ConservativeStyleDetected ConservativeStyleDetected}.
   * @return An immutable instance of ConservativeStyleDetected
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public ConservativeStyleDetected build() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
    return new ConservativeStyleDetectedBuilder.ImmutableConservativeStyleDetected(this);
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
    if ((initBits & INIT_BIT_STRING) != 0) attributes.add("string");
    return "Cannot build ConservativeStyleDetected, some of required attributes are not set " + attributes;
  }

  /**
   * Immutable implementation of {@link ConservativeStyleDetected}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new ConservativeStyleDetectedBuilder()}.
   */
  @Generated(from = "ConservativeStyleDetected", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  private static final class ImmutableConservativeStyleDetected
      extends ConservativeStyleDetected {
    private final ImmutableList<String> em;
    private final int value;
    private final String string;

    private ImmutableConservativeStyleDetected(ConservativeStyleDetectedBuilder builder) {
      this.em = builder.em.build();
      this.value = builder.value;
      this.string = builder.string;
    }

    /**
     * @return The value of the {@code em} attribute
     */
    @Override
    ImmutableList<String> getEm() {
      return em;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    int getValue() {
      return value;
    }

    /**
     * @return The value of the {@code string} attribute
     */
    @Override
    String getString() {
      return string;
    }

    /**
     * This instance is equal to all instances of {@code ImmutableConservativeStyleDetected} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ConservativeStyleDetectedBuilder.ImmutableConservativeStyleDetected
          && equalTo(0, (ConservativeStyleDetectedBuilder.ImmutableConservativeStyleDetected) another);
    }

    private boolean equalTo(int synthetic, ConservativeStyleDetectedBuilder.ImmutableConservativeStyleDetected another) {
      return em.equals(another.em)
          && value == another.value
          && string.equals(another.string);
    }

    /**
     * Computes a hash code from attributes: {@code em}, {@code value}, {@code string}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + em.hashCode();
      h += (h << 5) + value;
      h += (h << 5) + string.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ConservativeStyleDetected} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ConservativeStyleDetected")
          .omitNullValues()
          .add("em", em)
          .add("value", value)
          .add("string", string)
          .toString();
    }
  }
}
