package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code EnclosingFactory} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link EnclosingHiddenImplementation}.
 * @see EnclosingHiddenImplementation.HiddenImplementation
 * @see EnclosingHiddenImplementation.NonexposedImplementation
 * @see EnclosingHiddenImplementation.VisibleImplementation
 */
@Generated(from = "EnclosingHiddenImplementation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class EnclosingFactory {
  private EnclosingFactory() {}

  /**
   * Immutable implementation of {@link EnclosingHiddenImplementation.HiddenImplementation}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code EnclosingFactory.HiddenImplementationBuilder.create()}.
   * Use the static factory method to get the default singleton instance:
   * {@code EnclosingFactory.singletonInstanceHiddenImplementation()}.
   */
  @Generated(from = "EnclosingHiddenImplementation.HiddenImplementation", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  private static final class HiddenImplementation
      extends EnclosingHiddenImplementation.HiddenImplementation {

    private HiddenImplementation() {}

    /**
     * This instance is equal to all instances of {@code HiddenImplementation} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof EnclosingFactory.HiddenImplementation
          && equalTo(0, (EnclosingFactory.HiddenImplementation) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, EnclosingFactory.HiddenImplementation another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 848011062;
    }

    /**
     * Prints the immutable value {@code HiddenImplementation}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "HiddenImplementation{}";
    }

    private static final EnclosingFactory.HiddenImplementation INSTANCE = validate(new EnclosingFactory.HiddenImplementation());

    /**
     * Returns the default immutable singleton value of {@code HiddenImplementation}
     * @return An immutable instance of HiddenImplementation
     */
    public static EnclosingHiddenImplementation.HiddenImplementation singletonInstance() {
      return INSTANCE;
    }

    private static EnclosingFactory.HiddenImplementation validate(EnclosingFactory.HiddenImplementation instance) {
      return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }
  }

  /**
   * Builds instances of type {@link EnclosingHiddenImplementation.HiddenImplementation HiddenImplementation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code HiddenImplementationBuilder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EnclosingHiddenImplementation.HiddenImplementation", generator = "Immutables")
  @NotThreadSafe
  public static final class HiddenImplementationBuilder {

    private HiddenImplementationBuilder() {
    }

    /**
     * Creates a builder for {@link EnclosingHiddenImplementation.HiddenImplementation HiddenImplementation} instances.
     * @return A new builder
     */
    public static HiddenImplementationBuilder create() {
      return new HiddenImplementationBuilder();
    }

    /**
     * Fill a builder with attribute values from the provided {@code HiddenImplementation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final HiddenImplementationBuilder from(EnclosingHiddenImplementation.HiddenImplementation instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link EnclosingHiddenImplementation.HiddenImplementation HiddenImplementation}.
     * @return An immutable instance of HiddenImplementation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EnclosingHiddenImplementation.HiddenImplementation build() {
      return EnclosingFactory.singletonInstanceHiddenImplementation();
    }
  }

  /**
   * Returns a default immutable singleton value of HiddenImplementation.
   * @return An immutable instance of HiddenImplementation
   */
  public static EnclosingHiddenImplementation.HiddenImplementation singletonInstanceHiddenImplementation() {
    return EnclosingFactory.HiddenImplementation.singletonInstance();
  }

  /**
   * Immutable implementation of {@link EnclosingHiddenImplementation.NonexposedImplementation}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code EnclosingFactory.NonexposedImplementationBuilder.create()}.
   * Use the static factory method to create immutable instances:
   * {@code EnclosingFactory.newNonexposedImplementation()}.
   * Use the static factory method to get the default singleton instance:
   * {@code EnclosingFactory.singletonInstanceNonexposedImplementation()}.
   */
  @Generated(from = "EnclosingHiddenImplementation.NonexposedImplementation", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  private static final class NonexposedImplementation
      extends EnclosingHiddenImplementation.NonexposedImplementation {
    private final Optional<Integer> cons;

    private NonexposedImplementation() {
      this.cons = Optional.absent();
    }

    private NonexposedImplementation(Optional<Integer> cons) {
      this.cons = cons;
    }

    private NonexposedImplementation(EnclosingFactory.NonexposedImplementationBuilder builder) {
      this.cons = builder.cons;
    }

    /**
     * @return The value of the {@code cons} attribute
     */
    @Override
    public Optional<Integer> cons() {
      return cons;
    }

    /**
     * This instance is equal to all instances of {@code NonexposedImplementation} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof EnclosingFactory.NonexposedImplementation
          && equalTo(0, (EnclosingFactory.NonexposedImplementation) another);
    }

    private boolean equalTo(int synthetic, EnclosingFactory.NonexposedImplementation another) {
      return cons.equals(another.cons);
    }

    /**
     * Computes a hash code from attributes: {@code cons}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + cons.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code NonexposedImplementation} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("NonexposedImplementation")
          .omitNullValues()
          .add("cons", cons.orNull())
          .toString();
    }

    private static final EnclosingFactory.NonexposedImplementation INSTANCE = validate(new EnclosingFactory.NonexposedImplementation());

    /**
     * Returns the default immutable singleton value of {@code NonexposedImplementation}
     * @return An immutable instance of NonexposedImplementation
     */
    public static EnclosingHiddenImplementation.NonexposedImplementation singletonInstance() {
      return INSTANCE;
    }

    /**
     * Construct a new immutable {@code NonexposedImplementation} instance.
     * @param cons The value for the {@code cons} attribute
     * @return An immutable NonexposedImplementation instance
     */
    public static EnclosingHiddenImplementation.NonexposedImplementation newNonexposedImplementation(Optional<Integer> cons) {
      return validate(new EnclosingFactory.NonexposedImplementation(cons));
    }

    private static EnclosingFactory.NonexposedImplementation validate(EnclosingFactory.NonexposedImplementation instance) {
      return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }
  }

  /**
   * Builds instances of type {@link EnclosingHiddenImplementation.NonexposedImplementation NonexposedImplementation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code NonexposedImplementationBuilder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EnclosingHiddenImplementation.NonexposedImplementation", generator = "Immutables")
  @NotThreadSafe
  public static final class NonexposedImplementationBuilder {
    private Optional<Integer> cons = Optional.absent();

    private NonexposedImplementationBuilder() {
    }

    /**
     * Creates a builder for {@link EnclosingHiddenImplementation.NonexposedImplementation NonexposedImplementation} instances.
     * @return A new builder
     */
    public static NonexposedImplementationBuilder create() {
      return new NonexposedImplementationBuilder();
    }

    /**
     * Fill a builder with attribute values from the provided {@code NonexposedImplementation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final NonexposedImplementationBuilder from(EnclosingHiddenImplementation.NonexposedImplementation instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<Integer> consOptional = instance.cons();
      if (consOptional.isPresent()) {
        cons(consOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link EnclosingHiddenImplementation.NonexposedImplementation#cons() cons} to cons.
     * @param cons The value for cons
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final NonexposedImplementationBuilder cons(int cons) {
      this.cons = Optional.of(cons);
      return this;
    }

    /**
     * Initializes the optional value {@link EnclosingHiddenImplementation.NonexposedImplementation#cons() cons} to cons.
     * @param cons The value for cons
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final NonexposedImplementationBuilder cons(Optional<Integer> cons) {
      this.cons = cons;
      return this;
    }

    /**
     * Builds a new {@link EnclosingHiddenImplementation.NonexposedImplementation NonexposedImplementation}.
     * @return An immutable instance of NonexposedImplementation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EnclosingHiddenImplementation.NonexposedImplementation build() {
      return EnclosingFactory.NonexposedImplementation.validate(new EnclosingFactory.NonexposedImplementation(this));
    }
  }

  /**
   * Returns a default immutable singleton value of NonexposedImplementation.
   * @return An immutable instance of NonexposedImplementation
   */
  public static EnclosingHiddenImplementation.NonexposedImplementation singletonInstanceNonexposedImplementation() {
    return EnclosingFactory.NonexposedImplementation.singletonInstance();
  }

  /**
   * Construct a new immutable {@code NonexposedImplementation} instance.
   * @param cons The value for the {@code cons} attribute
   * @return An immutable NonexposedImplementation instance
   */
  public static EnclosingHiddenImplementation.NonexposedImplementation newNonexposedImplementation(Optional<Integer> cons) {
    return EnclosingFactory.NonexposedImplementation.newNonexposedImplementation(cons);
  }

  /**
   * Immutable implementation of {@link EnclosingHiddenImplementation.VisibleImplementation}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code EnclosingFactory.newVisibleImplementation()}.
   */
  @Generated(from = "EnclosingHiddenImplementation.VisibleImplementation", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  private static final class VisibleImplementation
      extends EnclosingHiddenImplementation.VisibleImplementation {
    private final Optional<Integer> cons;

    private VisibleImplementation(Optional<Integer> cons) {
      this.cons = cons;
    }

    /**
     * @return The value of the {@code cons} attribute
     */
    @Override
    public Optional<Integer> cons() {
      return cons;
    }

    /**
     * This instance is equal to all instances of {@code VisibleImplementation} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof EnclosingFactory.VisibleImplementation
          && equalTo(0, (EnclosingFactory.VisibleImplementation) another);
    }

    private boolean equalTo(int synthetic, EnclosingFactory.VisibleImplementation another) {
      return cons.equals(another.cons);
    }

    /**
     * Computes a hash code from attributes: {@code cons}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + cons.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code VisibleImplementation} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("VisibleImplementation")
          .omitNullValues()
          .add("cons", cons.orNull())
          .toString();
    }

    /**
     * Construct a new immutable {@code VisibleImplementation} instance.
     * @param cons The value for the {@code cons} attribute
     * @return An immutable VisibleImplementation instance
     */
    public static EnclosingHiddenImplementation.VisibleImplementation newVisibleImplementation(Optional<Integer> cons) {
      return new EnclosingFactory.VisibleImplementation(cons);
    }
  }

  /**
   * Construct a new immutable {@code VisibleImplementation} instance.
   * @param cons The value for the {@code cons} attribute
   * @return An immutable VisibleImplementation instance
   */
  public static EnclosingHiddenImplementation.VisibleImplementation newVisibleImplementation(Optional<Integer> cons) {
    return EnclosingFactory.VisibleImplementation.newVisibleImplementation(cons);
  }
}
