package org.immutables.fixture.style;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExtendingAndStagedBuilder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ExtendingAndStagedBuilder.Builder()}.
 */
@Generated(from = "ExtendingAndStagedBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableExtendingAndStagedBuilder
    implements ExtendingAndStagedBuilder {
  private final String name;

  private ImmutableExtendingAndStagedBuilder(String name) {
    this.name = name;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtendingAndStagedBuilder#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtendingAndStagedBuilder withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableExtendingAndStagedBuilder(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExtendingAndStagedBuilder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExtendingAndStagedBuilder
        && equalTo(0, (ImmutableExtendingAndStagedBuilder) another);
  }

  private boolean equalTo(int synthetic, ImmutableExtendingAndStagedBuilder another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExtendingAndStagedBuilder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExtendingAndStagedBuilder")
        .omitNullValues()
        .add("name", name)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ExtendingAndStagedBuilder", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ExtendingAndStagedBuilder {
    @Nullable String name;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableExtendingAndStagedBuilder fromJson(Json json) {
    ExtendingAndStagedBuilder.Builder builder = new ExtendingAndStagedBuilder.Builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    return (ImmutableExtendingAndStagedBuilder) builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ExtendingAndStagedBuilder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExtendingAndStagedBuilder instance
   */
  public static ExtendingAndStagedBuilder copyOf(ExtendingAndStagedBuilder instance) {
    if (instance instanceof ImmutableExtendingAndStagedBuilder) {
      return (ImmutableExtendingAndStagedBuilder) instance;
    }
    return new ExtendingAndStagedBuilder.Builder()
        .name(instance.name())
        .build();
  }

  /**
   * Builds instances of type {@link ExtendingAndStagedBuilder ExtendingAndStagedBuilder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExtendingAndStagedBuilder", generator = "Immutables")
  @NotThreadSafe
  public static class Builder implements NameBuildStage, BuildFinal {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;

    /**
     * Creates a builder for {@link ExtendingAndStagedBuilder ExtendingAndStagedBuilder} instances.
     * <pre>
     * new ExtendingAndStagedBuilder.Builder()
     *    .name(String) // required {@link ExtendingAndStagedBuilder#name() name}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ExtendingAndStagedBuilder.Builder)) {
        throw new UnsupportedOperationException("Use: new ExtendingAndStagedBuilder.Builder()");
      }
    }

    /**
     * Initializes the value for the {@link ExtendingAndStagedBuilder#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final ExtendingAndStagedBuilder.Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return (ExtendingAndStagedBuilder.Builder) this;
    }

    /**
     * Builds a new {@link ExtendingAndStagedBuilder ExtendingAndStagedBuilder}.
     * @return An immutable instance of ExtendingAndStagedBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExtendingAndStagedBuilder build() {
      checkRequiredAttributes();
      return new ImmutableExtendingAndStagedBuilder(name);
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of ExtendingAndStagedBuilder is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!nameIsSet()) attributes.add("name");
      return "Cannot build ExtendingAndStagedBuilder, some of required attributes are not set " + attributes;
    }
  }

  @Generated(from = "ExtendingAndStagedBuilder", generator = "Immutables")
  public interface NameBuildStage {
    /**
     * Initializes the value for the {@link ExtendingAndStagedBuilder#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal name(String name);
  }

  @Generated(from = "ExtendingAndStagedBuilder", generator = "Immutables")
  public interface BuildFinal {

    /**
     * Builds a new {@link ExtendingAndStagedBuilder ExtendingAndStagedBuilder}.
     * @return An immutable instance of ExtendingAndStagedBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    ExtendingAndStagedBuilder build();
  }
}
