package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HaveBuilderNew}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableHaveBuilderNew.Builder()}.
 */
@Generated(from = "HaveBuilderNew", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHaveBuilderNew implements HaveBuilderNew {
  private final int a;

  private ImmutableHaveBuilderNew(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HaveBuilderNew#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHaveBuilderNew withA(int value) {
    if (this.a == value) return this;
    return new ImmutableHaveBuilderNew(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHaveBuilderNew} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHaveBuilderNew
        && equalTo(0, (ImmutableHaveBuilderNew) another);
  }

  private boolean equalTo(int synthetic, ImmutableHaveBuilderNew another) {
    return a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    return h;
  }

  /**
   * Prints the immutable value {@code HaveBuilderNew} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HaveBuilderNew")
        .omitNullValues()
        .add("a", a)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link HaveBuilderNew} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HaveBuilderNew instance
   */
  public static ImmutableHaveBuilderNew copyOf(HaveBuilderNew instance) {
    if (instance instanceof ImmutableHaveBuilderNew) {
      return (ImmutableHaveBuilderNew) instance;
    }
    return new ImmutableHaveBuilderNew.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableHaveBuilderNew ImmutableHaveBuilderNew}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HaveBuilderNew", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;

    /**
     * Creates a builder for {@link ImmutableHaveBuilderNew ImmutableHaveBuilderNew} instances.
     * <pre>
     * new ImmutableHaveBuilderNew.Builder()
     *    .a(int) // required {@link HaveBuilderNew#a() a}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HaveBuilderNew} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HaveBuilderNew instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link HaveBuilderNew#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHaveBuilderNew ImmutableHaveBuilderNew}.
     * @return An immutable instance of HaveBuilderNew
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHaveBuilderNew build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHaveBuilderNew(a);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build HaveBuilderNew, some of required attributes are not set " + attributes;
    }
  }
}
