package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableIncludeNestedTypes} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link IncludeNestedTypes}.
 * @see ImmutableIncludeNestedTypes.Target
 * @see ImmutableIncludeNestedTypes.Retention
 */
@Generated(from = "IncludeNestedTypes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableIncludeNestedTypes {
  private ImmutableIncludeNestedTypes() {}

  /**
   * Immutable implementation of {@link java.lang.annotation.Target}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableIncludeNestedTypes.Target.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableIncludeNestedTypes.Target.of()}.
   */
  @Generated(from = "java.lang.annotation.Target", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Target implements java.lang.annotation.Target {
    private final ElementType[] value;

    private Target(ElementType[] value) {
      this.value = value.clone();
    }

    private Target(ImmutableIncludeNestedTypes.Target original, ElementType[] value) {
      this.value = value;
    }

    /** {@inheritDoc} */
    @Override
    public Class<? extends Annotation> annotationType() {
      return java.lang.annotation.Target.class;
    }

    /**
     * @return A cloned {@code value} array
     */
    @Override
    public ElementType[] value() {
      return value.clone();
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link java.lang.annotation.Target#value() value}.
     * The array is cloned before being saved as attribute values.
     * @param elements The non-null elements for value
     * @return A modified copy of {@code this} object
     */
    public final ImmutableIncludeNestedTypes.Target copyWithValue(ElementType... elements) {
      ElementType[] newValue = elements.clone();
      return new ImmutableIncludeNestedTypes.Target(this, newValue);
    }

    /**
     * This instance is equal to any implementation of the {@link ImmutableIncludeNestedTypes.Target} type with equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof java.lang.annotation.Target
          && equalTo(0, (java.lang.annotation.Target) another);
    }

    private boolean equalTo(int synthetic, java.lang.annotation.Target another) {
      return Arrays.equals(value, another.value());
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 0;
      h += 127 * "value".hashCode() ^ Arrays.hashCode(value);
      return h;
    }

    /**
     * Prints the immutable value {@code Target} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("@Target")
          .omitNullValues()
          .add("value", Arrays.toString(value))
          .toString();
    }

    /**
     * Construct a new immutable {@code Target} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable Target instance
     */
    public static ImmutableIncludeNestedTypes.Target of(ElementType[] value) {
      return new ImmutableIncludeNestedTypes.Target(value);
    }

    /**
     * Creates an immutable copy of a {@link java.lang.annotation.Target} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Target instance
     */
    public static ImmutableIncludeNestedTypes.Target copyOf(java.lang.annotation.Target instance) {
      if (instance instanceof ImmutableIncludeNestedTypes.Target) {
        return (ImmutableIncludeNestedTypes.Target) instance;
      }
      return ImmutableIncludeNestedTypes.Target.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableIncludeNestedTypes.Target Target}.
     * <pre>
     * ImmutableIncludeNestedTypes.Target.builder()
     *    .value(annotation.ElementType) // required {@link java.lang.annotation.Target#value() value}
     *    .build();
     * </pre>
     * @return A new Target builder
     */
    public static ImmutableIncludeNestedTypes.Target.Builder builder() {
      return new ImmutableIncludeNestedTypes.Target.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableIncludeNestedTypes.Target Target}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "java.lang.annotation.Target", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_VALUE = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ElementType[] value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Target} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(java.lang.annotation.Target instance) {
        Objects.requireNonNull(instance, "instance");
        value(instance.value());
        return this;
      }

      /**
       * Initializes the value for the {@link java.lang.annotation.Target#value() value} attribute.
       * @param value The elements for value
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder value(ElementType... value) {
        this.value = value.clone();
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableIncludeNestedTypes.Target Target}.
       * @return An immutable instance of Target
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableIncludeNestedTypes.Target build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableIncludeNestedTypes.Target(null, value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build Target, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link java.lang.annotation.Retention}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableIncludeNestedTypes.Retention.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableIncludeNestedTypes.Retention.of()}.
   */
  @Generated(from = "java.lang.annotation.Retention", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Retention implements java.lang.annotation.Retention {
    private final RetentionPolicy value;

    private Retention(RetentionPolicy value) {
      this.value = Objects.requireNonNull(value, "value");
    }

    private Retention(ImmutableIncludeNestedTypes.Retention original, RetentionPolicy value) {
      this.value = value;
    }

    /** {@inheritDoc} */
    @Override
    public Class<? extends Annotation> annotationType() {
      return java.lang.annotation.Retention.class;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public RetentionPolicy value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link java.lang.annotation.Retention#value() value} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableIncludeNestedTypes.Retention copyWithValue(RetentionPolicy value) {
      RetentionPolicy newValue = Objects.requireNonNull(value, "value");
      if (this.value == newValue) return this;
      return new ImmutableIncludeNestedTypes.Retention(this, newValue);
    }

    /**
     * This instance is equal to any implementation of the {@link ImmutableIncludeNestedTypes.Retention} type with equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof java.lang.annotation.Retention
          && equalTo(0, (java.lang.annotation.Retention) another);
    }

    private boolean equalTo(int synthetic, java.lang.annotation.Retention another) {
      return value.equals(another.value());
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 0;
      h += 127 * "value".hashCode() ^ value.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Retention} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("@Retention")
          .omitNullValues()
          .add("value", value)
          .toString();
    }

    /**
     * Construct a new immutable {@code Retention} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable Retention instance
     */
    public static ImmutableIncludeNestedTypes.Retention of(RetentionPolicy value) {
      return new ImmutableIncludeNestedTypes.Retention(value);
    }

    /**
     * Creates an immutable copy of a {@link java.lang.annotation.Retention} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Retention instance
     */
    public static ImmutableIncludeNestedTypes.Retention copyOf(java.lang.annotation.Retention instance) {
      if (instance instanceof ImmutableIncludeNestedTypes.Retention) {
        return (ImmutableIncludeNestedTypes.Retention) instance;
      }
      return ImmutableIncludeNestedTypes.Retention.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableIncludeNestedTypes.Retention Retention}.
     * <pre>
     * ImmutableIncludeNestedTypes.Retention.builder()
     *    .value(annotation.RetentionPolicy) // required {@link java.lang.annotation.Retention#value() value}
     *    .build();
     * </pre>
     * @return A new Retention builder
     */
    public static ImmutableIncludeNestedTypes.Retention.Builder builder() {
      return new ImmutableIncludeNestedTypes.Retention.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableIncludeNestedTypes.Retention Retention}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "java.lang.annotation.Retention", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_VALUE = 0x1L;
      private long initBits = 0x1L;

      private @Nullable RetentionPolicy value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Retention} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(java.lang.annotation.Retention instance) {
        Objects.requireNonNull(instance, "instance");
        value(instance.value());
        return this;
      }

      /**
       * Initializes the value for the {@link java.lang.annotation.Retention#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder value(RetentionPolicy value) {
        this.value = Objects.requireNonNull(value, "value");
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableIncludeNestedTypes.Retention Retention}.
       * @return An immutable instance of Retention
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableIncludeNestedTypes.Retention build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableIncludeNestedTypes.Retention(null, value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build Retention, some of required attributes are not set " + attributes;
      }
    }
  }
}
