package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NonPublicInitializers}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNonPublicInitializers.builder()}.
 */
@Generated(from = "NonPublicInitializers", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNonPublicInitializers extends NonPublicInitializers {
  private final int a;
  private final String b;
  private final boolean c;

  private ImmutableNonPublicInitializers(int a, String b, boolean c) {
    this.a = a;
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected String b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  boolean c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NonPublicInitializers#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNonPublicInitializers withA(int value) {
    if (this.a == value) return this;
    return new ImmutableNonPublicInitializers(value, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NonPublicInitializers#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNonPublicInitializers withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableNonPublicInitializers(this.a, newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NonPublicInitializers#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNonPublicInitializers withC(boolean value) {
    if (this.c == value) return this;
    return new ImmutableNonPublicInitializers(this.a, this.b, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNonPublicInitializers} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNonPublicInitializers
        && equalTo(0, (ImmutableNonPublicInitializers) another);
  }

  private boolean equalTo(int synthetic, ImmutableNonPublicInitializers another) {
    return a == another.a
        && b.equals(another.b)
        && c == another.c;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + Booleans.hashCode(c);
    return h;
  }

  /**
   * Prints the immutable value {@code NonPublicInitializers} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NonPublicInitializers")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NonPublicInitializers} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NonPublicInitializers instance
   */
  public static ImmutableNonPublicInitializers copyOf(NonPublicInitializers instance) {
    if (instance instanceof ImmutableNonPublicInitializers) {
      return (ImmutableNonPublicInitializers) instance;
    }
    return ImmutableNonPublicInitializers.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNonPublicInitializers ImmutableNonPublicInitializers}.
   * <pre>
   * ImmutableNonPublicInitializers.builder()
   *    .a(int) // required {@link NonPublicInitializers#a() a}
   *    .b(String) // required {@link NonPublicInitializers#b() b}
   *    .c(boolean) // required {@link NonPublicInitializers#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutableNonPublicInitializers builder
   */
  public static ImmutableNonPublicInitializers.Builder builder() {
    return new ImmutableNonPublicInitializers.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNonPublicInitializers ImmutableNonPublicInitializers}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NonPublicInitializers", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_C = 0x4L;
    private long initBits = 0x7L;

    private int a;
    private @Nullable String b;
    private boolean c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NonPublicInitializers} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NonPublicInitializers instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link NonPublicInitializers#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link NonPublicInitializers#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    protected final Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link NonPublicInitializers#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder c(boolean c) {
      this.c = c;
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNonPublicInitializers ImmutableNonPublicInitializers}.
     * @return An immutable instance of NonPublicInitializers
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNonPublicInitializers build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNonPublicInitializers(a, b, c);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build NonPublicInitializers, some of required attributes are not set " + attributes;
    }
  }
}
